/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.api.EnumColor;
import mekanism.client.ThreadClientUpdate;
import mekanism.common.IModule;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.Version;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

@SideOnly(value=Side.CLIENT)
public class GuiCredits
extends GuiScreen {
    private static String updateProgress = "";
    private boolean updatedRecently;
    private boolean notified = false;

    @Override
    public void func_73866_w_() {
        this.field_73887_h.clear();
        this.field_73887_h.add(new GuiButton(0, this.field_73880_f / 2 - 100, this.field_73881_g / 4 + 72 + 12, "Update"));
        this.field_73887_h.add(new GuiButton(1, this.field_73880_f / 2 - 100, this.field_73881_g / 4 + 96 + 12, "Cancel"));
        ((GuiButton)this.field_73887_h.get((int)0)).field_73742_g = !MekanismUtils.noUpdates() && !ThreadClientUpdate.hasUpdated;
    }

    public static void onFinishedDownloading() {
        updateProgress = "Successfully updated. Restart Minecraft to load.";
        System.out.println("[Mekanism] Successfully updated to latest version (" + Mekanism.latestVersionNumber + ").");
        ThreadClientUpdate.hasUpdated = true;
    }

    public static void onErrorDownloading() {
        updateProgress = (Object)((Object)EnumColor.DARK_RED) + "Error updating.";
    }

    @Override
    protected void func_73875_a(GuiButton guibutton) {
        if (!guibutton.field_73742_g) {
            return;
        }
        if (guibutton.field_73741_f == 0) {
            if (!MekanismUtils.noUpdates()) {
                this.updatedRecently = true;
                updateProgress = "Downloading latest version...";
                guibutton.field_73742_g = false;
                if (Mekanism.versionNumber.comparedState(Version.get(Mekanism.latestVersionNumber)) == -1) {
                    new ThreadClientUpdate("http://dl.dropbox.com/u/90411166/Mekanism-v" + Mekanism.latestVersionNumber + ".jar", "");
                }
                for (IModule module : Mekanism.modulesLoaded) {
                    if (module.getVersion().comparedState(Version.get(Mekanism.latestVersionNumber)) != -1) continue;
                    new ThreadClientUpdate("http://dl.dropbox.com/u/90411166/Mekanism" + module.getName() + "-v" + Mekanism.latestVersionNumber + ".jar", module.getName());
                }
            } else {
                updateProgress = "You already have the latest version.";
            }
        }
        if (guibutton.field_73741_f == 1) {
            this.field_73882_e.func_71373_a(null);
        }
    }

    public void writeText(String text, int yAxis) {
        this.func_73731_b(this.field_73886_k, text, this.field_73880_f / 2 - 140, this.field_73881_g / 4 - 60 + 20 + yAxis, 0xA0A0A0);
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        if (this.updatedRecently && ThreadClientUpdate.modulesBeingDownloaded == 0 && !updateProgress.contains("Error")) {
            if (!this.notified) {
                GuiCredits.onFinishedDownloading();
                this.notified = true;
            }
        } else if (ThreadClientUpdate.hasUpdated && !this.notified) {
            updateProgress = "You have already downloaded the update. Restart MC!";
        }
        this.func_73873_v_();
        this.func_73732_a(this.field_73886_k, (Object)((Object)EnumColor.DARK_BLUE) + "Mekanism" + (Object)((Object)EnumColor.GREY) + " by aidancbrady", this.field_73880_f / 2, this.field_73881_g / 4 - 60 + 20, 0xFFFFFF);
        this.writeText((Object)((Object)EnumColor.INDIGO) + "Mekanism " + (Object)((Object)(Mekanism.versionNumber.comparedState(Version.get(Mekanism.latestVersionNumber)) == -1 ? EnumColor.DARK_RED : EnumColor.GREY)) + Mekanism.versionNumber, 36);
        int size = 36;
        for (IModule module : Mekanism.modulesLoaded) {
            this.writeText((Object)((Object)EnumColor.INDIGO) + "Mekanism" + module.getName() + (Object)((Object)(module.getVersion().comparedState(Version.get(Mekanism.latestVersionNumber)) == -1 ? EnumColor.DARK_RED : EnumColor.GREY)) + " " + module.getVersion(), size += 9);
        }
        this.writeText((Object)((Object)EnumColor.GREY) + "Newest version: " + Mekanism.latestVersionNumber, size + 9);
        this.writeText((Object)((Object)EnumColor.GREY) + "*Developed on Mac OS X 10.8 Mountain Lion", size + 18);
        this.writeText((Object)((Object)EnumColor.GREY) + "*Code, textures, and ideas by aidancbrady", size + 27);
        this.writeText((Object)((Object)EnumColor.GREY) + "Recent news: " + (Object)((Object)EnumColor.DARK_BLUE) + (!Mekanism.recentNews.contains("null") ? Mekanism.recentNews : "couldn't access."), size + 36);
        this.writeText((Object)((Object)EnumColor.GREY) + updateProgress, size + 45);
        super.func_73863_a(i, j, f);
    }
}

