/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import mekanism.common.ISpecialBounds;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class MekanismRenderer {
    private static RenderBlocks renderBlocks = new RenderBlocks();
    private static float lightmapLastX;
    private static float lightmapLastY;

    public static void renderObject(Model3D object) {
        if (object == null) {
            return;
        }
        MekanismRenderer.renderBlocks.field_83026_h = object.maxX;
        MekanismRenderer.renderBlocks.field_83021_g = object.minX;
        MekanismRenderer.renderBlocks.field_83024_j = object.maxY;
        MekanismRenderer.renderBlocks.field_83027_i = object.minY;
        MekanismRenderer.renderBlocks.field_83022_l = object.maxZ;
        MekanismRenderer.renderBlocks.field_83025_k = object.minZ;
        MekanismRenderer.renderBlocks.field_78677_m = false;
        Tessellator.field_78398_a.func_78382_b();
        if (object.shouldSideRender(ForgeDirection.DOWN)) {
            renderBlocks.func_78613_a(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(0));
        }
        if (object.shouldSideRender(ForgeDirection.UP)) {
            renderBlocks.func_78617_b(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(1));
        }
        if (object.shouldSideRender(ForgeDirection.NORTH)) {
            renderBlocks.func_78611_c(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(2));
        }
        if (object.shouldSideRender(ForgeDirection.SOUTH)) {
            renderBlocks.func_78622_d(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(3));
        }
        if (object.shouldSideRender(ForgeDirection.WEST)) {
            renderBlocks.func_78573_e(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(4));
        }
        if (object.shouldSideRender(ForgeDirection.EAST)) {
            renderBlocks.func_78605_f(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(5));
        }
        if (Tessellator.field_78398_a.field_78415_z) {
            Tessellator.field_78398_a.func_78381_a();
        }
    }

    public static void glowOn() {
        GL11.glPushAttrib((int)64);
        lightmapLastX = OpenGlHelper.lastBrightnessX;
        lightmapLastY = OpenGlHelper.lastBrightnessY;
        RenderHelper.func_74518_a();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void glowOff() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapLastX, (float)lightmapLastY);
        GL11.glPopAttrib();
    }

    public static void renderItem(RenderBlocks renderer, int metadata, Block block) {
        if (!(block instanceof ISpecialBounds) || ((ISpecialBounds)block).doDefaultBoundSetting(metadata)) {
            block.func_71919_f();
        }
        if (block instanceof ISpecialBounds) {
            ((ISpecialBounds)block).setRenderBounds(block, metadata);
        }
        if (!(block instanceof ISpecialBounds) || ((ISpecialBounds)block).doDefaultBoundSetting(metadata)) {
            renderer.func_83018_a(block);
        } else {
            renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        if (renderer.field_78668_c) {
            int renderColor = block.func_71889_f_(metadata);
            float red = (float)(renderColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(renderColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(renderColor & 0xFF) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_78613_a(block, 0.0, 0.0, 0.0, block.func_71858_a(0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_78617_b(block, 0.0, 0.0, 0.0, block.func_71858_a(1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_78611_c(block, 0.0, 0.0, 0.0, block.func_71858_a(2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_78622_d(block, 0.0, 0.0, 0.0, block.func_71858_a(3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_78573_e(block, 0.0, 0.0, 0.0, block.func_71858_a(4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_78605_f(block, 0.0, 0.0, 0.0, block.func_71858_a(5, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void colorLiquid(LiquidStack liquidStack) {
        int color = liquidStack.asItemStack().func_77973_b().func_82790_a(liquidStack.asItemStack(), 0);
        float cR = (float)(color >> 16 & 0xFF) / 255.0f;
        float cG = (float)(color >> 8 & 0xFF) / 255.0f;
        float cB = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)cR, (float)cG, (float)cB, (float)1.0f);
    }

    public static class DisplayInteger {
        public int display;

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.display;
            return code;
        }

        public boolean equals(Object obj) {
            return obj instanceof DisplayInteger && ((DisplayInteger)obj).display == this.display;
        }
    }

    public static class Model3D {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;
        public Icon[] textures = new Icon[6];
        public boolean[] renderSides = new boolean[]{true, true, true, true, true, true};
        public Block baseBlock = Block.field_71939_E;

        public final void setBlockBounds(float xNeg, float yNeg, float zNeg, float xPos, float yPos, float zPos) {
            this.minX = xNeg;
            this.minY = yNeg;
            this.minZ = zNeg;
            this.maxX = xPos;
            this.maxY = yPos;
            this.maxZ = zPos;
        }

        public void setSideRender(ForgeDirection side, boolean value) {
            this.renderSides[side.ordinal()] = value;
        }

        public boolean shouldSideRender(ForgeDirection side) {
            return this.renderSides[side.ordinal()];
        }

        public Icon getBlockTextureFromSide(int i) {
            return this.textures[i];
        }

        public void setTexture(Icon tex) {
            Arrays.fill(this.textures, tex);
        }

        public void setTextures(Icon down, Icon up, Icon north, Icon south, Icon west, Icon east) {
            this.textures[0] = down;
            this.textures[1] = up;
            this.textures[2] = north;
            this.textures[3] = south;
            this.textures[4] = west;
            this.textures[5] = east;
        }
    }
}

