/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.Object3D;
import mekanism.api.SideData;
import mekanism.client.MekanismRenderer;
import mekanism.common.ItemConfigurator;
import mekanism.common.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderConfigurableMachine
extends TileEntitySpecialRenderer {
    private static Icon[] coloredOverlays;
    private Minecraft mc = FMLClientHandler.instance().getClient();
    private HashMap cachedOverlays = new HashMap();

    public RenderConfigurableMachine() {
        if (coloredOverlays == null) {
            coloredOverlays = new Icon[16];
            TextureMap registrar = this.mc.field_71446_o.field_94154_l;
            RenderConfigurableMachine.coloredOverlays[0] = registrar.func_94245_a("mekanism:OverlayBlack");
            RenderConfigurableMachine.coloredOverlays[1] = registrar.func_94245_a("mekanism:OverlayDarkBlue");
            RenderConfigurableMachine.coloredOverlays[2] = registrar.func_94245_a("mekanism:OverlayDarkGreen");
            RenderConfigurableMachine.coloredOverlays[3] = registrar.func_94245_a("mekanism:OverlayDarkAqua");
            RenderConfigurableMachine.coloredOverlays[4] = registrar.func_94245_a("mekanism:OverlayDarkRed");
            RenderConfigurableMachine.coloredOverlays[5] = registrar.func_94245_a("mekanism:OverlayPurple");
            RenderConfigurableMachine.coloredOverlays[6] = registrar.func_94245_a("mekanism:OverlayOrange");
            RenderConfigurableMachine.coloredOverlays[7] = registrar.func_94245_a("mekanism:OverlayGrey");
            RenderConfigurableMachine.coloredOverlays[8] = registrar.func_94245_a("mekanism:OverlayDarkGrey");
            RenderConfigurableMachine.coloredOverlays[9] = registrar.func_94245_a("mekanism:OverlayIndigo");
            RenderConfigurableMachine.coloredOverlays[10] = registrar.func_94245_a("mekanism:OverlayBrightGreen");
            RenderConfigurableMachine.coloredOverlays[11] = registrar.func_94245_a("mekanism:OverlayAqua");
            RenderConfigurableMachine.coloredOverlays[12] = registrar.func_94245_a("mekanism:OverlayRed");
            RenderConfigurableMachine.coloredOverlays[13] = registrar.func_94245_a("mekanism:OverlayPink");
            RenderConfigurableMachine.coloredOverlays[14] = registrar.func_94245_a("mekanism:OverlayYellow");
            RenderConfigurableMachine.coloredOverlays[15] = registrar.func_94245_a("mekanism:OverlayWhite");
        }
    }

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((IConfigurable)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(IConfigurable configurable, double x, double y, double z, float partialTick) {
        TileEntity tileEntity = (TileEntity)configurable;
        EntityClientPlayerMP player = this.mc.field_71439_g;
        World world = this.mc.field_71439_g.field_70170_p;
        ItemStack itemStack = player.func_71045_bC();
        MovingObjectPosition pos = player.func_70614_a(8.0, 1.0f);
        if (pos != null && itemStack != null && itemStack.func_77973_b() instanceof ItemConfigurator && ((ItemConfigurator)itemStack.func_77973_b()).getState(itemStack) == 0) {
            int xPos = MathHelper.func_76128_c((double)pos.field_72311_b);
            int yPos = MathHelper.func_76128_c((double)pos.field_72312_c);
            int zPos = MathHelper.func_76128_c((double)pos.field_72309_d);
            Object3D obj = new Object3D(xPos, yPos, zPos);
            if (xPos == tileEntity.field_70329_l && yPos == tileEntity.field_70330_m && zPos == tileEntity.field_70327_n) {
                EnumColor color = ((SideData)configurable.getSideData().get((int)configurable.getConfiguration()[MekanismUtils.getBaseOrientation((int)pos.field_72310_e, (int)configurable.getOrientation())])).color;
                this.push();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                this.func_76897_a("/mods/mekanism/textures/blocks/Overlay" + color.friendlyName.replace(" ", "") + ".png");
                GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
                int display = this.getOverlayDisplay((World)world, (ForgeDirection)ForgeDirection.getOrientation((int)pos.field_72310_e), (EnumColor)color).display;
                GL11.glCallList((int)display);
                this.pop();
            }
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private MekanismRenderer.DisplayInteger getOverlayDisplay(World world, ForgeDirection side, EnumColor color) {
        if (this.cachedOverlays.containsKey(side) && ((HashMap)this.cachedOverlays.get(side)).containsKey((Object)color)) {
            return (MekanismRenderer.DisplayInteger)((HashMap)this.cachedOverlays.get(side)).get((Object)color);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71981_t;
        toReturn.setTexture(coloredOverlays[color.ordinal()]);
        MekanismRenderer.DisplayInteger display = new MekanismRenderer.DisplayInteger();
        if (this.cachedOverlays.containsKey(side)) {
            ((HashMap)this.cachedOverlays.get(side)).put(color, display);
        } else {
            HashMap<EnumColor, MekanismRenderer.DisplayInteger> map = new HashMap<EnumColor, MekanismRenderer.DisplayInteger>();
            map.put(color, display);
            this.cachedOverlays.put(side, map);
        }
        display.display = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)display.display, (int)4864);
        switch (side) {
            case DOWN: {
                toReturn.minY = -0.01;
                toReturn.maxY = 0.0;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case UP: {
                toReturn.minY = 1.0;
                toReturn.maxY = 1.01;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case NORTH: {
                toReturn.minZ = -0.01;
                toReturn.maxZ = 0.0;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case SOUTH: {
                toReturn.minZ = 1.0;
                toReturn.maxZ = 1.01;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = -0.01;
                toReturn.maxX = 0.0;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case EAST: {
                toReturn.minX = 1.0;
                toReturn.maxX = 1.01;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        GL11.glEndList();
        return display;
    }
}

