/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Object3D;
import mekanism.client.MekanismRenderer;
import mekanism.common.SynchronizedTankData;
import mekanism.common.TileEntityDynamicTank;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderDynamicTank
extends TileEntitySpecialRenderer {
    private static Map cachedCenterLiquids = new HashMap();
    private static Map cachedValveLiquids = new HashMap();

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityDynamicTank)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityDynamicTank tileEntity, double x, double y, double z, float partialTick) {
        if (tileEntity.clientHasStructure && tileEntity.isRendering && tileEntity.structure != null && tileEntity.structure.liquidStored != null && tileEntity.structure.liquidStored.amount != 0) {
            RenderData data = new RenderData();
            data.location = tileEntity.structure.renderLocation;
            data.height = tileEntity.structure.volHeight;
            data.length = tileEntity.structure.volLength;
            data.width = tileEntity.structure.volWidth;
            this.func_76897_a(tileEntity.structure.liquidStored.canonical().getTextureSheet());
            if (data.location != null && data.height > 0 && Item.field_77698_e[tileEntity.structure.liquidStored.itemID] != null) {
                this.push();
                GL11.glTranslated((double)this.getX(data.location.xCoord), (double)this.getY(data.location.yCoord), (double)this.getZ(data.location.zCoord));
                int[] displayList = this.getListAndRender(data, tileEntity.structure.liquidStored.canonical(), tileEntity.field_70331_k);
                GL11.glCallList((int)displayList[(int)((float)tileEntity.structure.liquidStored.amount / (float)tileEntity.clientCapacity * ((float)this.getStages(data.height) - 1.0f))]);
                this.pop();
                for (SynchronizedTankData.ValveData valveData : tileEntity.valveViewing.keySet()) {
                    if ((Integer)tileEntity.valveViewing.get(valveData) <= 0) continue;
                    this.push();
                    GL11.glTranslated((double)this.getX(valveData.location.xCoord), (double)this.getY(valveData.location.yCoord), (double)this.getZ(valveData.location.zCoord));
                    int display = this.getValveDisplay((ValveRenderData)ValveRenderData.get((RenderData)data, (SynchronizedTankData.ValveData)valveData), (LiquidStack)tileEntity.structure.liquidStored, (World)tileEntity.field_70331_k).display;
                    GL11.glCallList((int)display);
                    this.pop();
                }
            }
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private int[] getListAndRender(RenderData data, LiquidStack stack, World world) {
        if (cachedCenterLiquids.containsKey(data) && ((HashMap)cachedCenterLiquids.get(data)).containsKey(stack)) {
            return (int[])((HashMap)cachedCenterLiquids.get(data)).get(stack);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71943_B;
        toReturn.setTexture(stack.getRenderingIcon());
        if (stack.itemID < Block.field_71973_m.length && Block.field_71973_m[stack.itemID] != null) {
            toReturn.baseBlock = Block.field_71973_m[stack.itemID];
        }
        int stages = this.getStages(data.height);
        int[] displays = new int[stages];
        if (cachedCenterLiquids.containsKey(data)) {
            ((HashMap)cachedCenterLiquids.get(data)).put(stack, displays);
        } else {
            HashMap<LiquidStack, int[]> map = new HashMap<LiquidStack, int[]>();
            map.put(stack, displays);
            cachedCenterLiquids.put(data, map);
        }
        MekanismRenderer.colorLiquid(stack);
        for (int i = 0; i < stages; ++i) {
            displays[i] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)displays[i], (int)4864);
            toReturn.minX = 0.01;
            toReturn.minY = 0.01;
            toReturn.minZ = 0.01;
            toReturn.maxX = (double)(data.length - 2) - 0.01;
            toReturn.maxY = (double)((float)i / (float)stages * (float)(data.height - 2)) - 0.01;
            toReturn.maxZ = (double)(data.width - 2) - 0.01;
            MekanismRenderer.renderObject(toReturn);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return displays;
    }

    private void setFlowingTexture(LiquidStack liquidStack, MekanismRenderer.Model3D model) {
        Icon flatIcon;
        if (liquidStack == null || liquidStack.amount <= 0 || liquidStack.itemID <= 0) {
            return;
        }
        ItemStack itemStack = liquidStack.asItemStack();
        String texturePath = liquidStack.canonical().getTextureSheet();
        Icon sideIcon = flatIcon = liquidStack.canonical().getRenderingIcon();
        if (itemStack.func_77973_b() instanceof ItemBlock) {
            flatIcon = Block.field_71973_m[itemStack.field_77993_c].func_71858_a(0, 0);
            sideIcon = Block.field_71973_m[itemStack.field_77993_c].func_71858_a(2, 0);
            texturePath = "/terrain.png";
        }
        model.setTextures(flatIcon, flatIcon, sideIcon, sideIcon, sideIcon, sideIcon);
        this.func_76897_a(texturePath);
    }

    private MekanismRenderer.DisplayInteger getValveDisplay(ValveRenderData data, LiquidStack stack, World world) {
        if (cachedValveLiquids.containsKey(data) && ((HashMap)cachedValveLiquids.get(data)).containsKey(stack)) {
            return (MekanismRenderer.DisplayInteger)((HashMap)cachedValveLiquids.get(data)).get(stack);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71943_B;
        this.setFlowingTexture(stack, toReturn);
        if (stack.itemID < Block.field_71973_m.length && Block.field_71973_m[stack.itemID] != null) {
            toReturn.baseBlock = Block.field_71973_m[stack.itemID];
        }
        MekanismRenderer.DisplayInteger display = new MekanismRenderer.DisplayInteger();
        if (cachedValveLiquids.containsKey(data)) {
            ((HashMap)cachedValveLiquids.get(data)).put(stack, display);
        } else {
            HashMap<LiquidStack, MekanismRenderer.DisplayInteger> map = new HashMap<LiquidStack, MekanismRenderer.DisplayInteger>();
            map.put(stack, display);
            cachedValveLiquids.put(data, map);
        }
        MekanismRenderer.colorLiquid(stack);
        display.display = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)display.display, (int)4864);
        switch (data.side) {
            case DOWN: {
                toReturn.minX = 0.3;
                toReturn.minY = 1.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 0.7;
                toReturn.maxY = 1.5;
                toReturn.maxZ = 0.7;
                break;
            }
            case UP: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-(data.height - 2)) - 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 0.7;
                toReturn.maxY = -0.01;
                toReturn.maxZ = 0.7;
                break;
            }
            case NORTH: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-this.getValveLiquidHeight(data)) + 0.01;
                toReturn.minZ = 1.02;
                toReturn.maxX = 0.7;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 1.4;
                break;
            }
            case SOUTH: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-this.getValveLiquidHeight(data)) + 0.01;
                toReturn.minZ = -0.4;
                toReturn.maxX = 0.7;
                toReturn.maxY = 0.7;
                toReturn.maxZ = -0.02;
                break;
            }
            case WEST: {
                toReturn.minX = 1.02;
                toReturn.minY = (double)(-this.getValveLiquidHeight(data)) + 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 1.4;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 0.7;
                break;
            }
            case EAST: {
                toReturn.minX = -0.4;
                toReturn.minY = (double)(-this.getValveLiquidHeight(data)) + 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = -0.02;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 0.7;
                break;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        GL11.glEndList();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return display;
    }

    private int getValveLiquidHeight(ValveRenderData data) {
        return data.valveLocation.yCoord - data.location.yCoord;
    }

    private int getStages(int height) {
        return (height - 2) * 1600;
    }

    private double getX(int x) {
        return (double)x - TileEntityRenderer.field_76961_b;
    }

    private double getY(int y) {
        return (double)y - TileEntityRenderer.field_76962_c;
    }

    private double getZ(int z) {
        return (double)z - TileEntityRenderer.field_76959_d;
    }

    public static class ValveRenderData
    extends RenderData {
        public ForgeDirection side;
        public Object3D valveLocation;

        public static ValveRenderData get(RenderData renderData, SynchronizedTankData.ValveData valveData) {
            ValveRenderData data = new ValveRenderData();
            data.location = renderData.location;
            data.height = renderData.height;
            data.length = renderData.length;
            data.width = renderData.width;
            data.side = valveData.side;
            data.valveLocation = valveData.location;
            return data;
        }

        @Override
        public boolean equals(Object data) {
            return data instanceof ValveRenderData && super.equals(data) && ((ValveRenderData)data).side.equals((Object)this.side);
        }

        @Override
        public int hashCode() {
            int code = 1;
            code = 31 * code + super.hashCode();
            code = 31 * code + this.side.ordinal();
            code = 31 * code + this.valveLocation.hashCode();
            return code;
        }
    }

    public static class RenderData {
        public Object3D location;
        public int height;
        public int length;
        public int width;

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.location.hashCode();
            code = 31 * code + this.height;
            code = 31 * code + this.length;
            code = 31 * code + this.width;
            return code;
        }

        public boolean equals(Object data) {
            return data instanceof RenderData && ((RenderData)data).location.equals(this.location) && ((RenderData)data).height == this.height;
        }
    }
}

