/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import mekanism.client.MekanismRenderer;
import mekanism.client.ModelTransmitter;
import mekanism.common.PipeUtils;
import mekanism.common.TileEntityMechanicalPipe;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderMechanicalPipe
extends TileEntitySpecialRenderer {
    private ModelTransmitter model = new ModelTransmitter();
    private HashMap cachedLiquids = new HashMap();
    private static final int stages = 40;
    private static final double offset = 0.015;

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityMechanicalPipe)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityMechanicalPipe tileEntity, double x, double y, double z, float partialTick) {
        int i;
        this.func_76897_a("/mods/mekanism/render/MechanicalPipe" + (tileEntity.isActive ? "Active" : "") + ".png");
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        boolean[] connectable = PipeUtils.getConnections(tileEntity);
        for (i = 0; i < 6; ++i) {
            this.model.renderSide(ForgeDirection.getOrientation((int)i), connectable[i]);
        }
        GL11.glPopMatrix();
        if (tileEntity.liquidScale > 0.0f && tileEntity.refLiquid != null) {
            this.push();
            if (tileEntity.refLiquid.itemID == Block.field_71938_D.field_71990_ca) {
                MekanismRenderer.glowOn();
            }
            this.func_76897_a(tileEntity.refLiquid.canonical().getTextureSheet());
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            for (i = 0; i < 6; ++i) {
                int[] displayList;
                if (!connectable[i] || (displayList = this.getListAndRender(ForgeDirection.getOrientation((int)i), tileEntity.refLiquid.canonical())) == null) continue;
                GL11.glCallList((int)displayList[Math.max(3, (int)(tileEntity.liquidScale * 39.0f))]);
            }
            int[] displayList = this.getListAndRender(ForgeDirection.UNKNOWN, tileEntity.refLiquid.canonical());
            if (displayList != null) {
                GL11.glCallList((int)displayList[Math.max(3, (int)(tileEntity.liquidScale * 39.0f))]);
            }
            if (tileEntity.refLiquid.itemID == Block.field_71938_D.field_71990_ca) {
                MekanismRenderer.glowOff();
            }
            this.pop();
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private int[] getListAndRender(ForgeDirection side, LiquidStack stack) {
        if (side == null || stack == null || stack.getRenderingIcon() == null) {
            return null;
        }
        if (this.cachedLiquids.containsKey(side) && ((HashMap)this.cachedLiquids.get(side)).containsKey(stack)) {
            return (int[])((HashMap)this.cachedLiquids.get(side)).get(stack);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71943_B;
        toReturn.setTexture(stack.getRenderingIcon());
        if (stack.itemID < Block.field_71973_m.length && Block.field_71973_m[stack.itemID] != null) {
            toReturn.baseBlock = Block.field_71973_m[stack.itemID];
        }
        int[] displays = new int[40];
        if (this.cachedLiquids.containsKey(side)) {
            ((HashMap)this.cachedLiquids.get(side)).put(stack, displays);
        } else {
            HashMap<LiquidStack, int[]> map = new HashMap<LiquidStack, int[]>();
            map.put(stack, displays);
            this.cachedLiquids.put(side, map);
        }
        MekanismRenderer.colorLiquid(stack);
        for (int i = 0; i < 40; ++i) {
            displays[i] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)displays[i], (int)4864);
            switch (side) {
                case UNKNOWN: {
                    toReturn.minX = 0.315;
                    toReturn.minY = 0.315;
                    toReturn.minZ = 0.315;
                    toReturn.maxX = 0.6849999999999999;
                    toReturn.maxY = 0.285 + (double)((float)i / 100.0f);
                    toReturn.maxZ = 0.6849999999999999;
                    break;
                }
                case DOWN: {
                    toReturn.minX = 0.515 - (double)((float)i / 100.0f / 2.0f);
                    toReturn.minY = 0.0;
                    toReturn.minZ = 0.515 - (double)((float)i / 100.0f / 2.0f);
                    toReturn.maxX = 0.485 + (double)((float)i / 100.0f / 2.0f);
                    toReturn.maxY = 0.315;
                    toReturn.maxZ = 0.485 + (double)((float)i / 100.0f / 2.0f);
                    break;
                }
                case UP: {
                    toReturn.minX = 0.515 - (double)((float)i / 100.0f / 2.0f);
                    toReturn.minY = 0.285 + (double)((float)i / 100.0f);
                    toReturn.minZ = 0.515 - (double)((float)i / 100.0f / 2.0f);
                    toReturn.maxX = 0.485 + (double)((float)i / 100.0f / 2.0f);
                    toReturn.maxY = 1.0;
                    toReturn.maxZ = 0.485 + (double)((float)i / 100.0f / 2.0f);
                    break;
                }
                case NORTH: {
                    toReturn.minX = 0.315;
                    toReturn.minY = 0.315;
                    toReturn.minZ = 0.0;
                    toReturn.maxX = 0.6849999999999999;
                    toReturn.maxY = 0.285 + (double)((float)i / 100.0f);
                    toReturn.maxZ = 0.315;
                    break;
                }
                case SOUTH: {
                    toReturn.minX = 0.315;
                    toReturn.minY = 0.315;
                    toReturn.minZ = 0.6849999999999999;
                    toReturn.maxX = 0.6849999999999999;
                    toReturn.maxY = 0.285 + (double)((float)i / 100.0f);
                    toReturn.maxZ = 1.0;
                    break;
                }
                case WEST: {
                    toReturn.minX = 0.0;
                    toReturn.minY = 0.315;
                    toReturn.minZ = 0.315;
                    toReturn.maxX = 0.315;
                    toReturn.maxY = 0.285 + (double)((float)i / 100.0f);
                    toReturn.maxZ = 0.6849999999999999;
                    break;
                }
                case EAST: {
                    toReturn.minX = 0.6849999999999999;
                    toReturn.minY = 0.315;
                    toReturn.minZ = 0.315;
                    toReturn.maxX = 1.0;
                    toReturn.maxY = 0.285 + (double)((float)i / 100.0f);
                    toReturn.maxZ = 0.6849999999999999;
                }
            }
            MekanismRenderer.renderObject(toReturn);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return displays;
    }
}

