/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.HashMap;
import mekanism.api.EnumGas;
import mekanism.api.GasTransmission;
import mekanism.api.ITubeConnection;
import mekanism.api.Object3D;
import mekanism.client.MekanismRenderer;
import mekanism.client.ModelTransmitter;
import mekanism.common.TileEntityGasTank;
import mekanism.common.TileEntityPressurizedTube;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderPressurizedTube
extends TileEntitySpecialRenderer {
    private ModelTransmitter model = new ModelTransmitter();
    private HashMap cachedGasses = new HashMap();
    private static final double offset = 0.015;

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityPressurizedTube)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityPressurizedTube tileEntity, double x, double y, double z, float partialTick) {
        ITubeConnection[] connections;
        this.func_76897_a("/mods/mekanism/render/PressurizedTube.png");
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        boolean[] connectable = new boolean[]{false, false, false, false, false, false};
        for (ITubeConnection connection : connections = GasTransmission.getConnections(tileEntity)) {
            int side;
            if (connection == null || !connection.canTubeConnect(ForgeDirection.getOrientation((int)(side = Arrays.asList(connections).indexOf(connection))).getOpposite())) continue;
            connectable[side] = true;
        }
        if (tileEntity.canTransferGas()) {
            for (int i = 0; i < 6; ++i) {
                TileEntity sideTile = Object3D.get(tileEntity).getFromSide(ForgeDirection.getOrientation((int)i)).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
                if (sideTile instanceof TileEntityGasTank && i != 0 && i != 1) {
                    GL11.glPushMatrix();
                    switch (ForgeDirection.getOrientation((int)i)) {
                        case NORTH: {
                            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.63f);
                            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.073f);
                            break;
                        }
                        case SOUTH: {
                            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.63f);
                            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.073f);
                            break;
                        }
                        case WEST: {
                            GL11.glScalef((float)1.63f, (float)1.0f, (float)1.0f);
                            GL11.glTranslatef((float)0.073f, (float)0.0f, (float)0.0f);
                            break;
                        }
                        case EAST: {
                            GL11.glScalef((float)1.63f, (float)1.0f, (float)1.0f);
                            GL11.glTranslatef((float)-0.073f, (float)0.0f, (float)0.0f);
                        }
                    }
                    this.model.renderSide(ForgeDirection.getOrientation((int)i), connectable[i]);
                    GL11.glPopMatrix();
                    continue;
                }
                this.model.renderSide(ForgeDirection.getOrientation((int)i), connectable[i]);
            }
        }
        GL11.glPopMatrix();
        if (tileEntity.gasScale > 0.0f && tileEntity.refGas != null && tileEntity.refGas.hasTexture()) {
            this.push();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)tileEntity.gasScale);
            this.func_76897_a(tileEntity.refGas.texturePath);
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            if (tileEntity.canTransferGas()) {
                for (int i = 0; i < 6; ++i) {
                    if (!connectable[i]) continue;
                    int displayList = this.getListAndRender((ForgeDirection)ForgeDirection.getOrientation((int)i), (EnumGas)tileEntity.refGas).display;
                    GL11.glCallList((int)displayList);
                }
            }
            int displayList = this.getListAndRender((ForgeDirection)ForgeDirection.UNKNOWN, (EnumGas)tileEntity.refGas).display;
            GL11.glCallList((int)displayList);
            this.pop();
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private MekanismRenderer.DisplayInteger getListAndRender(ForgeDirection side, EnumGas type) {
        if (this.cachedGasses.containsKey(side) && ((HashMap)this.cachedGasses.get(side)).containsKey((Object)type)) {
            return (MekanismRenderer.DisplayInteger)((HashMap)this.cachedGasses.get(side)).get((Object)type);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71943_B;
        toReturn.setTexture(type.gasIcon);
        MekanismRenderer.DisplayInteger display = new MekanismRenderer.DisplayInteger();
        if (this.cachedGasses.containsKey(side)) {
            ((HashMap)this.cachedGasses.get(side)).put(type, display);
        } else {
            HashMap<EnumGas, MekanismRenderer.DisplayInteger> map = new HashMap<EnumGas, MekanismRenderer.DisplayInteger>();
            map.put(type, display);
            this.cachedGasses.put(side, map);
        }
        display.display = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)display.display, (int)4864);
        switch (side) {
            case UNKNOWN: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.315;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 0.6849999999999999;
                break;
            }
            case DOWN: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.315;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 0.315;
                toReturn.maxZ = 0.6849999999999999;
                break;
            }
            case UP: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.285;
                toReturn.minZ = 0.315;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 0.6849999999999999;
                break;
            }
            case NORTH: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.0;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 0.315;
                break;
            }
            case SOUTH: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.6849999999999999;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = 0.0;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.315;
                toReturn.maxX = 0.315;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 0.6849999999999999;
                break;
            }
            case EAST: {
                toReturn.minX = 0.6849999999999999;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.315;
                toReturn.maxX = 1.0;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 0.6849999999999999;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        GL11.glEndList();
        return display;
    }
}

