/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.client.MekanismRenderer;
import mekanism.client.ModelTransmitter;
import mekanism.common.CableUtils;
import mekanism.common.Mekanism;
import mekanism.common.TileEntityUniversalCable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderUniversalCable
extends TileEntitySpecialRenderer {
    private ModelTransmitter model = new ModelTransmitter();
    private Icon renderIcon;
    private static final double offset = 0.015;

    public RenderUniversalCable() {
        this.renderIcon = FMLClientHandler.instance().getClient().field_71446_o.field_94155_m.func_94245_a("mekanism:LiquidEnergy");
    }

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityUniversalCable)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityUniversalCable tileEntity, double x, double y, double z, float partialTick) {
        int i;
        this.func_76897_a("/mods/mekanism/render/UniversalCable.png");
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        boolean[] connectable = CableUtils.getConnections(tileEntity);
        for (i = 0; i < 6; ++i) {
            this.model.renderSide(ForgeDirection.getOrientation((int)i), connectable[i]);
        }
        GL11.glPopMatrix();
        if (Mekanism.fancyUniversalCableRender) {
            this.push();
            MekanismRenderer.glowOn();
            this.func_76897_a("/mods/mekanism/textures/items/LiquidEnergy.png");
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            for (i = 0; i < 6; ++i) {
                if (!connectable[i]) continue;
                this.renderEnergy(ForgeDirection.getOrientation((int)i));
            }
            this.renderEnergy(ForgeDirection.UNKNOWN);
            MekanismRenderer.glowOff();
            this.pop();
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private void renderEnergy(ForgeDirection side) {
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71943_B;
        toReturn.setTexture(this.renderIcon);
        switch (side) {
            case UNKNOWN: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.315;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 0.6849999999999999;
                break;
            }
            case DOWN: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.315;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 0.315;
                toReturn.maxZ = 0.6849999999999999;
                break;
            }
            case UP: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.6849999999999999;
                toReturn.minZ = 0.315;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 0.6849999999999999;
                break;
            }
            case NORTH: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.0;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 0.315;
                break;
            }
            case SOUTH: {
                toReturn.minX = 0.315;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.6849999999999999;
                toReturn.maxX = 0.6849999999999999;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = 0.0;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.315;
                toReturn.maxX = 0.315;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 0.6849999999999999;
                break;
            }
            case EAST: {
                toReturn.minX = 0.6849999999999999;
                toReturn.minY = 0.315;
                toReturn.minZ = 0.315;
                toReturn.maxX = 1.0;
                toReturn.maxY = 0.6849999999999999;
                toReturn.maxZ = 0.6849999999999999;
            }
        }
        MekanismRenderer.renderObject(toReturn);
    }
}

