/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URL;
import java.util.Map;
import mekanism.client.IHasSound;
import mekanism.common.Mekanism;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

@SideOnly(value=Side.CLIENT)
public class Sound {
    public String soundPath;
    public String identifier;
    public TileEntity tileEntity;
    public boolean isPlaying = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sound(String id, String sound, TileEntity tileentity) {
        Map map = Mekanism.audioHandler.sounds;
        synchronized (map) {
            this.soundPath = sound;
            this.identifier = id;
            this.tileEntity = tileentity;
            URL url = this.getClass().getClassLoader().getResource("mods/mekanism/sound/" + sound);
            if (url == null) {
                System.out.println("[Mekanism] Invalid sound file: " + sound);
            }
            if (Mekanism.audioHandler.soundSystem != null) {
                Mekanism.audioHandler.soundSystem.newSource(false, id, url, sound, true, (float)this.tileEntity.field_70329_l, (float)this.tileEntity.field_70330_m, (float)this.tileEntity.field_70327_n, 0, 16.0f);
                this.updateVolume((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
                Mekanism.audioHandler.soundSystem.activate(id);
            }
            Mekanism.audioHandler.sounds.put(this.tileEntity, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        Map map = Mekanism.audioHandler.sounds;
        synchronized (map) {
            if (this.isPlaying) {
                return;
            }
            if (Mekanism.audioHandler.soundSystem != null) {
                this.updateVolume((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
                Mekanism.audioHandler.soundSystem.play(this.identifier);
            }
            this.isPlaying = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoop() {
        Map map = Mekanism.audioHandler.sounds;
        synchronized (map) {
            if (!this.isPlaying) {
                return;
            }
            if (Mekanism.audioHandler.soundSystem != null) {
                this.updateVolume((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
                Mekanism.audioHandler.soundSystem.stop(this.identifier);
            }
            this.isPlaying = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        Map map = Mekanism.audioHandler.sounds;
        synchronized (map) {
            if (this.isPlaying) {
                this.stopLoop();
            }
            Mekanism.audioHandler.sounds.remove(this.tileEntity);
            if (Mekanism.audioHandler.soundSystem != null) {
                this.updateVolume((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
                Mekanism.audioHandler.soundSystem.removeSource(this.identifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVolume(EntityPlayer entityplayer) {
        Map map = Mekanism.audioHandler.sounds;
        synchronized (map) {
            if (entityplayer != null && this.tileEntity != null && entityplayer.field_70170_p == this.tileEntity.field_70331_k) {
                float multiplier = ((IHasSound)this.tileEntity).getVolumeMultiplier();
                float volume = 0.0f;
                float masterVolume = Mekanism.audioHandler.masterVolume;
                double distance = entityplayer.func_70011_f((double)this.tileEntity.field_70329_l, (double)this.tileEntity.field_70330_m, (double)this.tileEntity.field_70327_n);
                volume = (float)Math.min(Math.max((double)masterVolume - distance * (double)0.08f * (double)masterVolume, 0.0) * (double)multiplier, 1.0);
                if (Mekanism.audioHandler.soundSystem != null) {
                    Mekanism.audioHandler.soundSystem.setVolume(this.identifier, volume);
                }
            }
        }
    }
}

