/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mekanism.api.Object3D;
import mekanism.client.IHasSound;
import mekanism.client.Sound;
import mekanism.common.IActiveState;
import mekanism.common.Mekanism;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkEvent;
import paulscode.sound.SoundSystem;

@SideOnly(value=Side.CLIENT)
public class SoundHandler {
    public SoundSystem soundSystem;
    public Map sounds = Collections.synchronizedMap(new HashMap());
    public float masterVolume = 0.0f;

    public SoundHandler() {
        this.soundSystem = SoundManager.field_77381_a;
        MinecraftForge.EVENT_BUS.register((Object)this);
        System.out.println("[Mekanism] Successfully set up SoundHandler.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick() {
        Map map = this.sounds;
        synchronized (map) {
            if (this.soundSystem == null) {
                this.soundSystem = SoundManager.field_77381_a;
            }
            if (this.soundSystem != null) {
                if (!Mekanism.proxy.isPaused()) {
                    ArrayList<Sound> soundsToRemove = new ArrayList<Sound>();
                    WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
                    for (Sound sound : this.sounds.values()) {
                        if (FMLClientHandler.instance().getClient().field_71439_g == null || world == null) continue;
                        if (!(sound.tileEntity instanceof IHasSound)) {
                            soundsToRemove.add(sound);
                            continue;
                        }
                        if (world.func_72796_p(sound.tileEntity.field_70329_l, sound.tileEntity.field_70330_m, sound.tileEntity.field_70327_n) != sound.tileEntity) {
                            soundsToRemove.add(sound);
                            continue;
                        }
                        if (!((IHasSound)sound.tileEntity).getSoundPath().equals(sound.soundPath)) {
                            soundsToRemove.add(sound);
                            continue;
                        }
                        if (sound.tileEntity instanceof IActiveState && ((IActiveState)sound.tileEntity).getActive() != sound.isPlaying) {
                            if (((IActiveState)sound.tileEntity).getActive()) {
                                sound.play();
                            } else {
                                sound.stopLoop();
                            }
                        }
                        if (!sound.isPlaying) continue;
                        sound.updateVolume((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
                    }
                    for (Sound sound : soundsToRemove) {
                        sound.remove();
                    }
                    this.masterVolume = FMLClientHandler.instance().getClient().field_71474_y.field_74340_b;
                } else {
                    for (Sound sound : this.sounds.values()) {
                        if (!sound.isPlaying) continue;
                        sound.stopLoop();
                    }
                }
            } else {
                Mekanism.proxy.unloadSoundHandler();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sound getFrom(TileEntity tileEntity) {
        Map map = this.sounds;
        synchronized (map) {
            return (Sound)this.sounds.get(tileEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(TileEntity tileEntity) {
        if (!(tileEntity instanceof IHasSound)) {
            return;
        }
        Map map = this.sounds;
        synchronized (map) {
            if (this.getFrom(tileEntity) == null) {
                new Sound(this.getIdentifier(), ((IHasSound)tileEntity).getSoundPath(), tileEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdentifier() {
        Map map = this.sounds;
        synchronized (map) {
            String toReturn = "Mekanism_" + this.sounds.size() + "_" + new Random().nextInt(10000);
            for (Sound sound : this.sounds.values()) {
                if (!sound.identifier.equals(toReturn)) continue;
                return this.getIdentifier();
            }
            return toReturn;
        }
    }

    public void quickPlay(String soundPath, World world, Object3D object) {
        URL url = this.getClass().getClassLoader().getResource("mods/mekanism/sound/" + soundPath);
        if (url == null) {
            System.out.println("[Mekanism] Invalid sound file: " + soundPath);
        }
        String s = this.soundSystem.quickPlay(false, url, soundPath, false, (float)object.xCoord, (float)object.yCoord, (float)object.zCoord, 0, 16.0f);
        this.soundSystem.setVolume(s, this.masterVolume);
    }

    @ForgeSubscribe
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getChunk() != null) {
            for (Object obj : event.getChunk().field_76648_i.values()) {
                TileEntity tileEntity;
                if (!(obj instanceof TileEntity) || !((tileEntity = (TileEntity)obj) instanceof IHasSound) || this.getFrom(tileEntity) == null || !this.sounds.containsKey(tileEntity)) continue;
                this.getFrom(tileEntity).remove();
            }
        }
    }
}

