/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Object3D;
import mekanism.client.ClientProxy;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.TileEntityControlPanel;
import mekanism.common.TileEntityDynamicTank;
import mekanism.common.TileEntityDynamicValve;
import mekanism.common.network.PacketTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class BlockBasic
extends Block {
    public Icon[] icons = new Icon[256];

    public BlockBasic(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(5.0f);
        this.func_71894_b(10.0f);
        this.func_71849_a(Mekanism.tabMekanism);
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        if (!world.field_72995_K && id == this.field_71990_ca && world.func_72796_p(x, y, z) instanceof TileEntityDynamicTank) {
            TileEntityDynamicTank dynamicTank = (TileEntityDynamicTank)world.func_72796_p(x, y, z);
            dynamicTank.update();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        this.icons[0] = register.func_94245_a("mekanism:OsmiumBlock");
        this.icons[1] = register.func_94245_a("mekanism:BronzeBlock");
        this.icons[2] = register.func_94245_a("mekanism:RefinedObsidian");
        this.icons[3] = register.func_94245_a("mekanism:CoalBlock");
        this.icons[4] = register.func_94245_a("mekanism:RefinedGlowstone");
        this.icons[5] = register.func_94245_a("mekanism:SteelBlock");
        this.icons[7] = register.func_94245_a("mekanism:TeleporterFrame");
        this.icons[8] = register.func_94245_a("mekanism:SteelCasing");
        this.icons[9] = register.func_94245_a("mekanism:DynamicTank");
        this.icons[10] = register.func_94245_a("mekanism:DynamicGlass");
        this.icons[11] = register.func_94245_a("mekanism:DynamicValve");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return this.icons[meta];
    }

    public int func_71899_b(int i) {
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int i, CreativeTabs creativetabs, List list) {
        list.add(new ItemStack(i, 1, 0));
        list.add(new ItemStack(i, 1, 1));
        list.add(new ItemStack(i, 1, 2));
        list.add(new ItemStack(i, 1, 3));
        list.add(new ItemStack(i, 1, 4));
        list.add(new ItemStack(i, 1, 5));
        list.add(new ItemStack(i, 1, 7));
        list.add(new ItemStack(i, 1, 8));
        list.add(new ItemStack(i, 1, 9));
        list.add(new ItemStack(i, 1, 10));
        list.add(new ItemStack(i, 1, 11));
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        TileEntityDynamicTank tileEntity;
        int meta = world.func_72805_g(x, y, z);
        if ((meta == 9 || meta == 10 || meta == 11) && (tileEntity = (TileEntityDynamicTank)world.func_72796_p(x, y, z)) != null && (!world.field_72995_K ? tileEntity.structure != null : tileEntity.clientHasStructure)) {
            return false;
        }
        return super.canCreatureSpawn(type, world, x, y, z);
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityplayer, int i1, float f1, float f2, float f3) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 2) {
            if (entityplayer.func_70093_af()) {
                entityplayer.openGui((Object)Mekanism.instance, 1, world, x, y, z);
                return true;
            }
        } else if (metadata == 6 && !entityplayer.func_70093_af()) {
            entityplayer.openGui((Object)Mekanism.instance, 9, world, x, y, z);
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (!(metadata != 9 && metadata != 10 && metadata != 11 || entityplayer.func_70093_af() || ((TileEntityDynamicTank)world.func_72796_p((int)x, (int)y, (int)z)).structure == null)) {
            TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)world.func_72796_p(x, y, z);
            if (!this.manageInventory(entityplayer, tileEntity)) {
                PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Object[0]);
                entityplayer.openGui((Object)Mekanism.instance, 18, world, x, y, z);
            } else {
                tileEntity.sendPacketToRenderer();
            }
            return true;
        }
        return false;
    }

    private boolean manageInventory(EntityPlayer player, TileEntityDynamicTank tileEntity) {
        ItemStack itemStack = player.func_71045_bC();
        if (itemStack != null && tileEntity.structure != null) {
            if (LiquidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
                ItemStack filled;
                if (tileEntity.structure.liquidStored != null && tileEntity.structure.liquidStored.amount >= 1000 && (filled = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)tileEntity.structure.liquidStored, (ItemStack)itemStack)) != null) {
                    if (itemStack.field_77994_a > 1) {
                        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                            if (player.field_71071_by.field_70462_a[i] == null) {
                                player.field_71071_by.field_70462_a[i] = filled;
                                --itemStack.field_77994_a;
                                tileEntity.structure.liquidStored.amount -= LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)filled).amount;
                                if (tileEntity.structure.liquidStored.amount == 0) {
                                    tileEntity.structure.liquidStored = null;
                                }
                                return true;
                            }
                            if (!player.field_71071_by.field_70462_a[i].func_77969_a(filled) || filled.func_77976_d() <= player.field_71071_by.field_70462_a[i].field_77994_a) continue;
                            ++player.field_71071_by.field_70462_a[i].field_77994_a;
                            --itemStack.field_77994_a;
                            tileEntity.structure.liquidStored.amount -= LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)filled).amount;
                            if (tileEntity.structure.liquidStored.amount == 0) {
                                tileEntity.structure.liquidStored = null;
                            }
                            return true;
                        }
                    } else if (itemStack.field_77994_a == 1) {
                        player.func_70062_b(0, filled);
                        tileEntity.structure.liquidStored.amount -= LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)filled).amount;
                        if (tileEntity.structure.liquidStored.amount == 0) {
                            tileEntity.structure.liquidStored = null;
                        }
                        return true;
                    }
                }
            } else if (LiquidContainerRegistry.isFilledContainer((ItemStack)itemStack)) {
                LiquidStack itemLiquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemStack);
                int max = tileEntity.structure.volume * 16000;
                if (tileEntity.structure.liquidStored == null || tileEntity.structure.liquidStored.isLiquidEqual(itemLiquid) && tileEntity.structure.liquidStored.amount + itemLiquid.amount <= max) {
                    if (LiquidContainerRegistry.isBucket((ItemStack)itemStack)) {
                        if (tileEntity.structure.liquidStored == null) {
                            tileEntity.structure.liquidStored = itemLiquid;
                        } else {
                            tileEntity.structure.liquidStored.amount += itemLiquid.amount;
                        }
                        player.func_70062_b(0, new ItemStack(Item.field_77788_aw));
                        return true;
                    }
                    --itemStack.field_77994_a;
                    if (itemStack.field_77994_a == 0) {
                        player.func_70062_b(0, null);
                    }
                    if (tileEntity.structure.liquidStored == null) {
                        tileEntity.structure.liquidStored = itemLiquid;
                    } else {
                        tileEntity.structure.liquidStored.amount += itemLiquid.amount;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return ClientProxy.BASIC_RENDER_ID;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        switch (metadata) {
            case 2: {
                return 8;
            }
            case 4: {
                return 15;
            }
            case 7: {
                return 12;
            }
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 6 || metadata == 9 || metadata == 10 || metadata == 11;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 6: {
                return new TileEntityControlPanel();
            }
            case 9: {
                return new TileEntityDynamicTank();
            }
            case 10: {
                return new TileEntityDynamicTank();
            }
            case 11: {
                return new TileEntityDynamicValve();
            }
        }
        return null;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving entityliving, ItemStack itemstack) {
        TileEntity tileEntity;
        world.func_72902_n(x, y, z);
        world.func_72969_x(x, y, z);
        if (world.func_72796_p(x, y, z) != null && !world.field_72995_K && (tileEntity = world.func_72796_p(x, y, z)) instanceof TileEntityDynamicTank) {
            ((TileEntityDynamicTank)tileEntity).update();
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(this.field_71990_ca, 1, world.func_72805_g(x, y, z));
    }
}

