/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mekanism.api.IEnergizedItem;
import mekanism.common.IEnergyCube;
import mekanism.common.ISustainedInventory;
import mekanism.common.ItemBlockEnergyCube;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.TileEntityBasicBlock;
import mekanism.common.TileEntityEnergyCube;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import universalelectricity.prefab.implement.IToolConfigurator;

public class BlockEnergyCube
extends BlockContainer {
    public Icon[][] icons = new Icon[256][256];

    public BlockEnergyCube(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(2.0f);
        this.func_71894_b(4.0f);
        this.func_71849_a(Mekanism.tabMekanism);
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        this.icons[0][0] = register.func_94245_a("mekanism:BasicEnergyCubeFront");
        this.icons[0][1] = register.func_94245_a("mekanism:BasicEnergyCubeSide");
        this.icons[1][0] = register.func_94245_a("mekanism:AdvancedEnergyCubeFront");
        this.icons[1][1] = register.func_94245_a("mekanism:AdvancedEnergyCubeSide");
        this.icons[2][0] = register.func_94245_a("mekanism:EliteEnergyCubeFront");
        this.icons[2][1] = register.func_94245_a("mekanism:EliteEnergyCubeSide");
        this.icons[3][0] = register.func_94245_a("mekanism:UltimateEnergyCubeFront");
        this.icons[3][1] = register.func_94245_a("mekanism:UltimateEnergyCubeSide");
    }

    public void func_71919_f() {
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (side == 3) {
            return this.icons[meta][0];
        }
        return this.icons[meta][1];
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving entityliving, ItemStack itemstack) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
        int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int height = Math.round(entityliving.field_70125_A);
        int change = 3;
        if (height >= 65) {
            change = 1;
        } else if (height <= -65) {
            change = 0;
        } else {
            switch (side) {
                case 0: {
                    change = 2;
                    break;
                }
                case 1: {
                    change = 5;
                    break;
                }
                case 2: {
                    change = 3;
                    break;
                }
                case 3: {
                    change = 4;
                }
            }
        }
        tileEntity.setFacing((short)change);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_72796_p(x, y, z);
        if (side == tileEntity.facing) {
            return this.icons[tileEntity.tier.ordinal()][0];
        }
        return this.icons[tileEntity.tier.ordinal()][1];
    }

    public int func_71925_a(Random random) {
        return 0;
    }

    public int func_71885_a(int i, Random random, int j) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int i, CreativeTabs creativetabs, List list) {
        for (Tier.EnergyCubeTier tier : Tier.EnergyCubeTier.values()) {
            ItemStack discharged = new ItemStack((Block)this);
            discharged.func_77964_b(100);
            ((ItemBlockEnergyCube)discharged.func_77973_b()).setEnergyCubeTier(discharged, tier);
            list.add(discharged);
            ItemStack charged = new ItemStack((Block)this);
            ((ItemBlockEnergyCube)charged.func_77973_b()).setEnergyCubeTier(charged, tier);
            ((ItemBlockEnergyCube)charged.func_77973_b()).setEnergy(charged, tier.MAX_ELECTRICITY);
            list.add(charged);
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityplayer, int i1, float f1, float f2, float f3) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_72796_p(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (entityplayer.func_71045_bC() != null) {
            Item tool = entityplayer.func_71045_bC().func_77973_b();
            if (tool instanceof IToolConfigurator) {
                if (((IToolConfigurator)tool).canWrench(entityplayer, x, y, z)) {
                    ((IToolConfigurator)tool).wrenchUsed(entityplayer, x, y, z);
                    int change = 0;
                    switch (tileEntity.facing) {
                        case 3: {
                            change = 5;
                            break;
                        }
                        case 5: {
                            change = 2;
                            break;
                        }
                        case 2: {
                            change = 4;
                            break;
                        }
                        case 4: {
                            change = 1;
                            break;
                        }
                        case 1: {
                            change = 0;
                            break;
                        }
                        case 0: {
                            change = 3;
                        }
                    }
                    tileEntity.setFacing((short)change);
                    world.func_72898_h(x, y, z, this.field_71990_ca);
                    return true;
                }
            } else if (tool instanceof IToolWrench && !tool.func_77658_a().contains("omniwrench") && ((IToolWrench)tool).canWrench(entityplayer, x, y, z)) {
                if (entityplayer.func_70093_af()) {
                    this.dismantleBlock(world, x, y, z, false);
                    return true;
                }
                ((IToolWrench)tool).wrenchUsed(entityplayer, x, y, z);
                int change = 0;
                switch (tileEntity.facing) {
                    case 3: {
                        change = 5;
                        break;
                    }
                    case 5: {
                        change = 2;
                        break;
                    }
                    case 2: {
                        change = 4;
                        break;
                    }
                    case 4: {
                        change = 1;
                        break;
                    }
                    case 1: {
                        change = 0;
                        break;
                    }
                    case 0: {
                        change = 3;
                    }
                }
                tileEntity.setFacing((short)change);
                world.func_72898_h(x, y, z, this.field_71990_ca);
                return true;
            }
        }
        if (tileEntity != null && !entityplayer.func_70093_af()) {
            entityplayer.openGui((Object)Mekanism.instance, 8, world, x, y, z);
            return true;
        }
        return false;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && this.canHarvestBlock(player, world.func_72805_g(x, y, z))) {
            TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_72796_p(x, y, z);
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_94571_i(x, y, z);
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityEnergyCube();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_72796_p(x, y, z);
        ItemStack itemStack = new ItemStack(Mekanism.EnergyCube);
        IEnergyCube energyCube = (IEnergyCube)itemStack.func_77973_b();
        energyCube.setEnergyCubeTier(itemStack, tileEntity.tier);
        IEnergizedItem energizedItem = (IEnergizedItem)itemStack.func_77973_b();
        energizedItem.setEnergy(itemStack, tileEntity.electricityStored);
        ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
        inventory.setInventory(tileEntity.getInventory(new Object[0]), itemStack);
        return itemStack;
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(null, world, x, y, z);
        world.func_94571_i(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public boolean func_96468_q_() {
        return true;
    }

    public int func_94328_b_(World world, int x, int y, int z, int par5) {
        TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_72796_p(x, y, z);
        return tileEntity.getRedstoneLevel();
    }
}

