/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mekanism.api.IEnergizedItem;
import mekanism.api.IUpgradeManagement;
import mekanism.api.Object3D;
import mekanism.client.ClientProxy;
import mekanism.common.IActiveState;
import mekanism.common.IBoundingBlock;
import mekanism.common.IElectricChest;
import mekanism.common.IFactory;
import mekanism.common.ISpecialBounds;
import mekanism.common.ISustainedInventory;
import mekanism.common.ISustainedTank;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.Tier;
import mekanism.common.TileEntityAdvancedFactory;
import mekanism.common.TileEntityBasicBlock;
import mekanism.common.TileEntityChargepad;
import mekanism.common.TileEntityCombiner;
import mekanism.common.TileEntityContainerBlock;
import mekanism.common.TileEntityCrusher;
import mekanism.common.TileEntityElectricBlock;
import mekanism.common.TileEntityElectricChest;
import mekanism.common.TileEntityElectricPump;
import mekanism.common.TileEntityEliteFactory;
import mekanism.common.TileEntityEnergizedSmelter;
import mekanism.common.TileEntityEnrichmentChamber;
import mekanism.common.TileEntityFactory;
import mekanism.common.TileEntityMetallurgicInfuser;
import mekanism.common.TileEntityOsmiumCompressor;
import mekanism.common.TileEntityPurificationChamber;
import mekanism.common.TileEntityTeleporter;
import mekanism.common.TileEntityTheoreticalElementizer;
import mekanism.common.network.PacketElectricChest;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.prefab.implement.IToolConfigurator;

public class BlockMachine
extends BlockContainer
implements ISpecialBounds {
    public Icon[][] icons = new Icon[256][256];
    public Random machineRand = new Random();

    public BlockMachine(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(3.5f);
        this.func_71894_b(8.0f);
        this.func_71849_a(Mekanism.tabMekanism);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        this.icons[0][0] = register.func_94245_a("mekanism:EnrichmentChamberFrontOff");
        this.icons[0][1] = register.func_94245_a("mekanism:EnrichmentChamberFrontOn");
        this.icons[0][2] = register.func_94245_a("mekanism:SteelCasing");
        this.icons[1][0] = register.func_94245_a("mekanism:OsmiumCompressorFrontOff");
        this.icons[1][1] = register.func_94245_a("mekanism:OsmiumCompressorFrontOn");
        this.icons[1][2] = register.func_94245_a("mekanism:SteelCasing");
        this.icons[2][0] = register.func_94245_a("mekanism:CombinerFrontOff");
        this.icons[2][1] = register.func_94245_a("mekanism:CombinerFrontOn");
        this.icons[2][2] = register.func_94245_a("mekanism:SteelCasing");
        this.icons[3][0] = register.func_94245_a("mekanism:CrusherFrontOff");
        this.icons[3][1] = register.func_94245_a("mekanism:CrusherFrontOn");
        this.icons[3][2] = register.func_94245_a("mekanism:SteelCasing");
        this.icons[5][0] = register.func_94245_a("mekanism:BasicFactoryFront");
        this.icons[5][1] = register.func_94245_a("mekanism:BasicFactorySide");
        this.icons[5][2] = register.func_94245_a("mekanism:BasicFactoryTop");
        this.icons[6][0] = register.func_94245_a("mekanism:AdvancedFactoryFront");
        this.icons[6][1] = register.func_94245_a("mekanism:AdvancedFactorySide");
        this.icons[6][2] = register.func_94245_a("mekanism:AdvancedFactoryTop");
        this.icons[7][0] = register.func_94245_a("mekanism:EliteFactoryFront");
        this.icons[7][1] = register.func_94245_a("mekanism:EliteFactorySide");
        this.icons[7][2] = register.func_94245_a("mekanism:EliteFactoryTop");
        this.icons[8][0] = register.func_94245_a("mekanism:MetallurgicInfuserFrontOff");
        this.icons[8][1] = register.func_94245_a("mekanism:MetallurgicInfuserFrontOn");
        this.icons[8][2] = register.func_94245_a("mekanism:MetallurgicInfuserSideOff");
        this.icons[8][3] = register.func_94245_a("mekanism:MetallurgicInfuserSideOn");
        this.icons[8][4] = register.func_94245_a("mekanism:MetallurgicInfuserTopOff");
        this.icons[8][5] = register.func_94245_a("mekanism:MetallurgicInfuserTopOn");
        this.icons[8][6] = register.func_94245_a("mekanism:MetallurgicInfuserBackOff");
        this.icons[8][7] = register.func_94245_a("mekanism:MetallurgicInfuserBackOn");
        this.icons[9][0] = register.func_94245_a("mekanism:PurificationChamberFrontOff");
        this.icons[9][1] = register.func_94245_a("mekanism:PurificationChamberFrontOn");
        this.icons[9][2] = register.func_94245_a("mekanism:SteelCasing");
        this.icons[10][0] = register.func_94245_a("mekanism:EnergizedSmelterFrontOff");
        this.icons[10][1] = register.func_94245_a("mekanism:EnergizedSmelterFrontOn");
        this.icons[10][2] = register.func_94245_a("mekanism:SteelCasing");
        this.icons[11][0] = register.func_94245_a("mekanism:Teleporter");
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving entityliving, ItemStack itemstack) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
        int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 3;
        switch (side) {
            case 0: {
                change = 2;
                break;
            }
            case 1: {
                change = 5;
                break;
            }
            case 2: {
                change = 3;
                break;
            }
            case 3: {
                change = 4;
            }
        }
        tileEntity.setFacing((short)change);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)((Object)tileEntity)).onPlace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random random) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
        if (MekanismUtils.isActive((IBlockAccess)world, x, y, z) && !(tileEntity instanceof TileEntityChargepad)) {
            float xRandom = (float)x + 0.5f;
            float yRandom = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float zRandom = (float)z + 0.5f;
            float iRandom = 0.52f;
            float jRandom = random.nextFloat() * 0.6f - 0.3f;
            if (tileEntity.facing == 4) {
                world.func_72869_a("smoke", (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
            } else if (tileEntity.facing == 5) {
                world.func_72869_a("smoke", (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
            } else if (tileEntity.facing == 2) {
                world.func_72869_a("smoke", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
            } else if (tileEntity.facing == 3) {
                world.func_72869_a("smoke", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof IActiveState && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).hasVisual()) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (meta == 0) {
            if (side == 3) {
                return this.icons[0][0];
            }
            return this.icons[0][2];
        }
        if (meta == 1) {
            if (side == 3) {
                return this.icons[1][0];
            }
            return this.icons[1][2];
        }
        if (meta == 2) {
            if (side == 3) {
                return this.icons[2][0];
            }
            return this.icons[2][2];
        }
        if (meta == 3) {
            if (side == 3) {
                return this.icons[3][0];
            }
            return this.icons[3][2];
        }
        if (meta == 5) {
            if (side == 3) {
                return this.icons[5][0];
            }
            if (side == 0 || side == 1) {
                return this.icons[5][2];
            }
            return this.icons[5][1];
        }
        if (meta == 6) {
            if (side == 3) {
                return this.icons[6][0];
            }
            if (side == 0 || side == 1) {
                return this.icons[6][2];
            }
            return this.icons[6][1];
        }
        if (meta == 7) {
            if (side == 3) {
                return this.icons[7][0];
            }
            if (side == 0 || side == 1) {
                return this.icons[7][2];
            }
            return this.icons[7][1];
        }
        if (meta == 8) {
            if (side == 0 || side == 1) {
                return this.icons[8][4];
            }
            if (side == 3) {
                return this.icons[8][0];
            }
            if (side == 2) {
                return this.icons[8][6];
            }
            return this.icons[8][2];
        }
        if (meta == 9) {
            if (side == 3) {
                return this.icons[9][0];
            }
            return this.icons[9][2];
        }
        if (meta == 10) {
            if (side == 3) {
                return this.icons[10][0];
            }
            return this.icons[10][2];
        }
        if (meta == 11) {
            return this.icons[11][0];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
        if (metadata == 0) {
            if (side == tileEntity.facing) {
                return MekanismUtils.isActive(world, x, y, z) ? this.icons[0][1] : this.icons[0][0];
            }
            return this.icons[0][2];
        }
        if (metadata == 1) {
            if (side == tileEntity.facing) {
                return MekanismUtils.isActive(world, x, y, z) ? this.icons[1][1] : this.icons[1][0];
            }
            return this.icons[1][2];
        }
        if (metadata == 2) {
            if (side == tileEntity.facing) {
                return MekanismUtils.isActive(world, x, y, z) ? this.icons[2][1] : this.icons[2][0];
            }
            return this.icons[2][2];
        }
        if (metadata == 3) {
            if (side == tileEntity.facing) {
                return MekanismUtils.isActive(world, x, y, z) ? this.icons[3][1] : this.icons[3][0];
            }
            return this.icons[3][2];
        }
        if (metadata == 5) {
            if (side == tileEntity.facing) {
                return this.icons[5][0];
            }
            if (side == 0 || side == 1) {
                return this.icons[5][2];
            }
            return this.icons[5][1];
        }
        if (metadata == 6) {
            if (side == tileEntity.facing) {
                return this.icons[6][0];
            }
            if (side == 0 || side == 1) {
                return this.icons[6][2];
            }
            return this.icons[6][1];
        }
        if (metadata == 7) {
            if (side == tileEntity.facing) {
                return this.icons[7][0];
            }
            if (side == 0 || side == 1) {
                return this.icons[7][2];
            }
            return this.icons[7][1];
        }
        if (metadata == 8) {
            if (side == 0 || side == 1) {
                return MekanismUtils.isActive(world, x, y, z) ? this.icons[8][5] : this.icons[8][4];
            }
            if (side == tileEntity.facing) {
                return MekanismUtils.isActive(world, x, y, z) ? this.icons[8][1] : this.icons[8][0];
            }
            if (side == ForgeDirection.getOrientation((int)tileEntity.facing).getOpposite().ordinal()) {
                return MekanismUtils.isActive(world, x, y, z) ? this.icons[8][7] : this.icons[8][6];
            }
            return MekanismUtils.isActive(world, x, y, z) ? this.icons[8][3] : this.icons[8][2];
        }
        if (metadata == 9) {
            if (side == tileEntity.facing) {
                return MekanismUtils.isActive(world, x, y, z) ? this.icons[9][1] : this.icons[9][0];
            }
            return this.icons[9][2];
        }
        if (metadata == 10) {
            if (side == tileEntity.facing) {
                return MekanismUtils.isActive(world, x, y, z) ? this.icons[10][1] : this.icons[10][0];
            }
            return this.icons[10][2];
        }
        if (metadata == 11) {
            return this.icons[11][0];
        }
        return null;
    }

    public int func_71899_b(int i) {
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int i, CreativeTabs creativetabs, List list) {
        list.add(new ItemStack(i, 1, 0));
        list.add(new ItemStack(i, 1, 1));
        list.add(new ItemStack(i, 1, 2));
        list.add(new ItemStack(i, 1, 3));
        if (Mekanism.extrasEnabled) {
            list.add(new ItemStack(i, 1, 4));
        }
        for (IFactory.RecipeType type : IFactory.RecipeType.values()) {
            for (Tier.FactoryTier tier : Tier.FactoryTier.values()) {
                ItemStack stack = new ItemStack(i, 1, 5 + tier.ordinal());
                ((IFactory)stack.func_77973_b()).setRecipeType(type.ordinal(), stack);
                list.add(stack);
            }
        }
        list.add(new ItemStack(i, 1, 8));
        list.add(new ItemStack(i, 1, 9));
        list.add(new ItemStack(i, 1, 10));
        list.add(new ItemStack(i, 1, 11));
        list.add(new ItemStack(i, 1, 12));
        list.add(new ItemStack(i, 1, 13));
        list.add(new ItemStack(i, 1, 14));
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityplayer, int facing, float playerX, float playerY, float playerZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (entityplayer.func_71045_bC() != null) {
            Item tool = entityplayer.func_71045_bC().func_77973_b();
            if (tool instanceof IToolConfigurator) {
                if (((IToolConfigurator)tool).canWrench(entityplayer, x, y, z)) {
                    ((IToolConfigurator)tool).wrenchUsed(entityplayer, x, y, z);
                    int change = 0;
                    switch (tileEntity.facing) {
                        case 3: {
                            change = 5;
                            break;
                        }
                        case 5: {
                            change = 2;
                            break;
                        }
                        case 2: {
                            change = 4;
                            break;
                        }
                        case 4: {
                            change = 3;
                        }
                    }
                    tileEntity.setFacing((short)change);
                    world.func_72898_h(x, y, z, this.field_71990_ca);
                    return true;
                }
            } else if (tool instanceof IToolWrench && !tool.func_77658_a().contains("omniwrench") && ((IToolWrench)tool).canWrench(entityplayer, x, y, z)) {
                if (entityplayer.func_70093_af() && metadata != 13) {
                    this.dismantleBlock(world, x, y, z, false);
                    return true;
                }
                ((IToolWrench)tool).wrenchUsed(entityplayer, x, y, z);
                int change = 0;
                switch (tileEntity.facing) {
                    case 3: {
                        change = 5;
                        break;
                    }
                    case 5: {
                        change = 2;
                        break;
                    }
                    case 2: {
                        change = 4;
                        break;
                    }
                    case 4: {
                        change = 3;
                    }
                }
                tileEntity.setFacing((short)change);
                world.func_72898_h(x, y, z, this.field_71990_ca);
                return true;
            }
        }
        if (tileEntity != null) {
            if (metadata == MachineType.TELEPORTER.meta) {
                if (entityplayer.func_70093_af()) {
                    entityplayer.openGui((Object)Mekanism.instance, 13, world, x, y, z);
                    return true;
                }
                TileEntityTeleporter teleporter = (TileEntityTeleporter)tileEntity;
                if (teleporter.canTeleport() == 1) {
                    teleporter.teleport();
                    return true;
                }
            } else if (metadata == MachineType.ELECTRIC_CHEST.meta) {
                TileEntityElectricChest electricChest = (TileEntityElectricChest)tileEntity;
                if (!entityplayer.func_70093_af()) {
                    if (electricChest.canAccess()) {
                        MekanismUtils.openElectricChestGui((EntityPlayerMP)entityplayer, electricChest, null, true);
                    } else if (!electricChest.authenticated) {
                        PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 2, 0, true, Object3D.get(electricChest)}), entityplayer);
                    } else {
                        PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 1, 0, true, Object3D.get(electricChest)}), entityplayer);
                    }
                    return true;
                }
            } else if (!entityplayer.func_70093_af() && MachineType.getFromMetadata((int)metadata).guiId != -1) {
                entityplayer.openGui((Object)Mekanism.instance, MachineType.getFromMetadata((int)metadata).guiId, world, x, y, z);
                return true;
            }
        }
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return MachineType.getFromMetadata(metadata).create();
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return ClientProxy.MACHINE_RENDER_ID;
    }

    public float func_71934_m(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) != 13) {
            return this.field_71989_cb;
        }
        TileEntityElectricChest tileEntity = (TileEntityElectricChest)world.func_72796_p(x, y, z);
        return tileEntity.canAccess() ? 3.5f : -1.0f;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && this.canHarvestBlock(player, world.func_72805_g(x, y, z))) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_94571_i(x, y, z);
    }

    public int func_71885_a(int i, Random random, int j) {
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
        ItemStack itemStack = new ItemStack(Mekanism.MachineBlock, 1, world.func_72805_g(x, y, z));
        if (((IUpgradeManagement)itemStack.func_77973_b()).supportsUpgrades(itemStack)) {
            IUpgradeManagement upgrade = (IUpgradeManagement)itemStack.func_77973_b();
            upgrade.setEnergyMultiplier(((IUpgradeManagement)((Object)tileEntity)).getEnergyMultiplier(new Object[0]), itemStack);
            upgrade.setSpeedMultiplier(((IUpgradeManagement)((Object)tileEntity)).getSpeedMultiplier(new Object[0]), itemStack);
        }
        if (tileEntity instanceof TileEntityElectricBlock) {
            IEnergizedItem energizedItem = (IEnergizedItem)itemStack.func_77973_b();
            energizedItem.setEnergy(itemStack, ((TileEntityElectricBlock)tileEntity).electricityStored);
        }
        if (tileEntity instanceof TileEntityContainerBlock && ((TileEntityContainerBlock)tileEntity).inventory.length > 0) {
            ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
            inventory.setInventory(((ISustainedInventory)((Object)tileEntity)).getInventory(new Object[0]), itemStack);
        }
        if (((ISustainedTank)itemStack.func_77973_b()).hasTank(itemStack) && tileEntity instanceof ISustainedTank && ((ISustainedTank)((Object)tileEntity)).getLiquidStack(new Object[0]) != null) {
            ((ISustainedTank)itemStack.func_77973_b()).setLiquidStack(((ISustainedTank)((Object)tileEntity)).getLiquidStack(new Object[0]), itemStack);
        }
        if (tileEntity instanceof TileEntityElectricChest) {
            IElectricChest electricChest = (IElectricChest)itemStack.func_77973_b();
            electricChest.setAuthenticated(itemStack, ((TileEntityElectricChest)tileEntity).authenticated);
            electricChest.setLocked(itemStack, ((TileEntityElectricChest)tileEntity).locked);
            electricChest.setPassword(itemStack, ((TileEntityElectricChest)tileEntity).password);
        }
        if (tileEntity instanceof TileEntityFactory) {
            IFactory factoryItem = (IFactory)itemStack.func_77973_b();
            factoryItem.setRecipeType(((TileEntityFactory)tileEntity).recipeType, itemStack);
        }
        return itemStack;
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(null, world, x, y, z);
        world.func_94571_i(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == MachineType.CHARGEPAD.meta) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.06f, 1.0f);
        } else {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        if (world.func_72796_p(x, y, z) instanceof TileEntityChargepad) {
            return null;
        }
        return super.func_71872_e(world, x, y, z);
    }

    @Override
    public void setRenderBounds(Block block, int metadata) {
    }

    @Override
    public boolean doDefaultBoundSetting(int metadata) {
        return false;
    }

    public static enum MachineType {
        ENRICHMENT_CHAMBER(0, 3, Mekanism.enrichmentChamberUsage * 400.0, TileEntityEnrichmentChamber.class, false),
        OSMIUM_COMPRESSOR(1, 4, Mekanism.osmiumCompressorUsage * 400.0, TileEntityOsmiumCompressor.class, false),
        COMBINER(2, 5, Mekanism.combinerUsage * 400.0, TileEntityCombiner.class, false),
        CRUSHER(3, 6, Mekanism.crusherUsage * 400.0, TileEntityCrusher.class, false),
        THEORETICAL_ELEMENTIZER(4, 7, Mekanism.theoreticalElementizerUsage * 400.0, TileEntityTheoreticalElementizer.class, true),
        BASIC_FACTORY(5, 11, Mekanism.factoryUsage * 3.0 * 400.0, TileEntityFactory.class, false),
        ADVANCED_FACTORY(6, 11, Mekanism.factoryUsage * 5.0 * 400.0, TileEntityAdvancedFactory.class, false),
        ELITE_FACTORY(7, 11, Mekanism.factoryUsage * 7.0 * 400.0, TileEntityEliteFactory.class, false),
        METALLURGIC_INFUSER(8, 12, Mekanism.metallurgicInfuserUsage * 400.0, TileEntityMetallurgicInfuser.class, true),
        PURIFICATION_CHAMBER(9, 15, Mekanism.purificationChamberUsage * 400.0, TileEntityPurificationChamber.class, false),
        ENERGIZED_SMELTER(10, 16, Mekanism.energizedSmelterUsage * 400.0, TileEntityEnergizedSmelter.class, false),
        TELEPORTER(11, 13, 5000000.0, TileEntityTeleporter.class, false),
        ELECTRIC_PUMP(12, 17, 10000.0, TileEntityElectricPump.class, true),
        ELECTRIC_CHEST(13, -1, 12000.0, TileEntityElectricChest.class, true),
        CHARGEPAD(14, -1, 9000.0, TileEntityChargepad.class, true);

        public int meta;
        public int guiId;
        public double baseEnergy;
        public Class tileEntityClass;
        public boolean hasModel;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private MachineType(double i, Class k, boolean bl) {
            void model;
            void tileClass;
            void j;
            this.meta = (int)i;
            this.guiId = j;
            this.baseEnergy = (double)k;
            this.tileEntityClass = tileClass;
            this.hasModel = model;
        }

        public static MachineType getFromMetadata(int meta) {
            return MachineType.values()[meta];
        }

        public TileEntity create() {
            try {
                return (TileEntity)this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                System.err.println("[Mekanism] Unable to indirectly create tile entity.");
                e.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return Integer.toString(this.meta);
        }
    }
}

