/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.power.IPowerReceptor;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import mekanism.api.ICableOutputter;
import mekanism.api.IStrictEnergyAcceptor;
import mekanism.api.Object3D;
import mekanism.common.EnergyNetwork;
import mekanism.common.IUniversalCable;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IConnectionProvider;

public final class CableUtils {
    public static TileEntity[] getConnectedEnergyAcceptors(TileEntity tileEntity) {
        TileEntity[] acceptors = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity acceptor = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!(acceptor instanceof IStrictEnergyAcceptor) && !(acceptor instanceof IEnergySink) && (!(acceptor instanceof IPowerReceptor) || acceptor instanceof IUniversalCable || !Mekanism.hooks.BuildCraftLoaded)) continue;
            acceptors[orientation.ordinal()] = acceptor;
        }
        return acceptors;
    }

    public static TileEntity[] getConnectedCables(TileEntity tileEntity) {
        TileEntity[] cables = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity cable = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!(cable instanceof IUniversalCable)) continue;
            cables[orientation.ordinal()] = cable;
        }
        return cables;
    }

    public static boolean[] getConnections(TileEntity tileEntity) {
        int side;
        boolean[] connectable = new boolean[]{false, false, false, false, false, false};
        TileEntity[] connectedAcceptors = CableUtils.getConnectedEnergyAcceptors(tileEntity);
        TileEntity[] connectedCables = CableUtils.getConnectedCables(tileEntity);
        TileEntity[] connectedOutputters = CableUtils.getConnectedOutputters(tileEntity);
        for (TileEntity tile : connectedAcceptors) {
            side = Arrays.asList(connectedAcceptors).indexOf(tile);
            if (!CableUtils.canConnectToAcceptor(ForgeDirection.getOrientation((int)side), tileEntity)) continue;
            connectable[side] = true;
        }
        for (TileEntity tile : connectedOutputters) {
            if (tile == null) continue;
            side = Arrays.asList(connectedOutputters).indexOf(tile);
            connectable[side] = true;
        }
        for (TileEntity tile : connectedCables) {
            if (tile == null) continue;
            side = Arrays.asList(connectedCables).indexOf(tile);
            connectable[side] = true;
        }
        return connectable;
    }

    public static TileEntity[] getConnectedOutputters(TileEntity tileEntity) {
        TileEntity[] outputters = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity outputter = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if ((!(outputter instanceof ICableOutputter) || !((ICableOutputter)outputter).canOutputTo(orientation.getOpposite())) && (!(outputter instanceof IEnergySource) || !((IEnergySource)outputter).emitsEnergyTo(tileEntity, MekanismUtils.toIC2Direction(orientation.getOpposite())))) continue;
            outputters[orientation.ordinal()] = outputter;
        }
        return outputters;
    }

    public static boolean canConnectToAcceptor(ForgeDirection side, TileEntity tile) {
        TileEntity tileEntity = Object3D.get(tile).getFromSide(side).getTileEntity((IBlockAccess)tile.field_70331_k);
        if (tileEntity instanceof IStrictEnergyAcceptor && ((IStrictEnergyAcceptor)tileEntity).canReceiveEnergy(side.getOpposite())) {
            return true;
        }
        if (tileEntity instanceof IConnectionProvider && ((IConnectionProvider)tileEntity).canConnect(side.getOpposite())) {
            return true;
        }
        if (tileEntity instanceof IEnergyAcceptor && ((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(tile, MekanismUtils.toIC2Direction(side).getInverse())) {
            return true;
        }
        if (tileEntity instanceof ICableOutputter && ((ICableOutputter)tileEntity).canOutputTo(side.getOpposite())) {
            return true;
        }
        return !(!(tileEntity instanceof IPowerReceptor) || tileEntity instanceof IUniversalCable || !Mekanism.hooks.BuildCraftLoaded || tileEntity instanceof IEnergyAcceptor && !((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(null, MekanismUtils.toIC2Direction(side).getInverse()) || tileEntity instanceof IEnergySource && !((IEnergySource)tileEntity).emitsEnergyTo(null, MekanismUtils.toIC2Direction(side).getInverse()));
    }

    public static double emitEnergyToNetwork(double amount, TileEntity sender, ForgeDirection facing) {
        TileEntity pointer = Object3D.get(sender).getFromSide(facing).getTileEntity((IBlockAccess)sender.field_70331_k);
        if (pointer instanceof IUniversalCable) {
            IUniversalCable cable = (IUniversalCable)pointer;
            ArrayList<TileEntity> ignored = new ArrayList<TileEntity>();
            ignored.add(sender);
            return cable.getNetwork().emit(amount, ignored);
        }
        return amount;
    }

    public static double emitEnergyFromAllSides(double amount, TileEntity pointer, ArrayList ignored) {
        if (pointer != null) {
            HashSet<EnergyNetwork> networks = new HashSet<EnergyNetwork>();
            double totalRemaining = 0.0;
            ignored.add(pointer);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity sideTile = Object3D.get(pointer).getFromSide(side).getTileEntity((IBlockAccess)pointer.field_70331_k);
                if (!(sideTile instanceof IUniversalCable) || ignored.contains(sideTile)) continue;
                networks.add(((IUniversalCable)sideTile).getNetwork());
            }
            if (networks.size() == 0) {
                return amount;
            }
            double remaining = amount % (double)networks.size();
            double splitEnergy = (amount - remaining) / (double)networks.size();
            for (EnergyNetwork network : networks) {
                totalRemaining += network.emit(splitEnergy + remaining, ignored);
                remaining = 0.0;
            }
            return totalRemaining;
        }
        return amount;
    }
}

