/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import mekanism.api.EnergizedItemManager;
import mekanism.api.IEnergizedItem;
import mekanism.common.Mekanism;
import mekanism.common.TileEntityElectricBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thermalexpansion.api.item.IChargeableItem;
import universalelectricity.core.item.ElectricItemHelper;
import universalelectricity.core.item.IItemElectric;

public final class ChargeUtils {
    public static void discharge(int slotID, TileEntityElectricBlock storer) {
        if (storer.inventory[slotID] != null && storer.getEnergy() < storer.getMaxEnergy()) {
            if (storer.inventory[slotID].func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() + EnergizedItemManager.discharge(storer.inventory[slotID], storer.getMaxEnergy() - storer.getEnergy()));
            } else if (storer.inventory[slotID].func_77973_b() instanceof IItemElectric) {
                storer.setEnergy(storer.getEnergy() + ElectricItemHelper.dechargeItem(storer.inventory[slotID], storer.getMaxEnergy() - storer.getEnergy(), storer.getVoltage()));
            } else if (Mekanism.hooks.IC2Loaded && storer.inventory[slotID].func_77973_b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)storer.inventory[slotID].func_77973_b();
                if (item.canProvideEnergy(storer.inventory[slotID])) {
                    double gain = (double)ElectricItem.manager.discharge(storer.inventory[slotID], (int)((storer.getMaxEnergy() - storer.getEnergy()) * Mekanism.TO_IC2), 3, false, false) * Mekanism.FROM_IC2;
                    storer.setEnergy(storer.getEnergy() + gain);
                }
            } else if (storer.inventory[slotID].func_77973_b() instanceof IChargeableItem) {
                ItemStack itemStack = storer.inventory[slotID];
                IChargeableItem item = (IChargeableItem)storer.inventory[slotID].func_77973_b();
                float itemEnergy = (float)Math.min(Math.sqrt(item.getMaxEnergyStored(itemStack)), (double)item.getEnergyStored(itemStack));
                float toTransfer = (float)Math.min((double)itemEnergy, (storer.getMaxEnergy() - storer.getEnergy()) * Mekanism.TO_BC);
                item.transferEnergy(itemStack, toTransfer, true);
                storer.setEnergy(storer.getEnergy() + (double)toTransfer * Mekanism.FROM_BC);
            } else if (storer.inventory[slotID].field_77993_c == Item.field_77767_aC.field_77779_bT && storer.getEnergy() + Mekanism.ENERGY_PER_REDSTONE <= storer.getMaxEnergy()) {
                storer.setEnergy(storer.getEnergy() + Mekanism.ENERGY_PER_REDSTONE);
                --storer.inventory[slotID].field_77994_a;
                if (storer.inventory[slotID].field_77994_a <= 0) {
                    storer.inventory[slotID] = null;
                }
            }
        }
    }

    public static void charge(int slotID, TileEntityElectricBlock storer) {
        if (storer.inventory[slotID] != null && storer.getEnergy() > 0.0) {
            if (storer.inventory[slotID].func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() - EnergizedItemManager.charge(storer.inventory[slotID], storer.getEnergy()));
            } else if (storer.inventory[slotID].func_77973_b() instanceof IItemElectric) {
                storer.setEnergy(storer.getEnergy() - ElectricItemHelper.chargeItem(storer.inventory[slotID], storer.getEnergy(), storer.getVoltage()));
            } else if (Mekanism.hooks.IC2Loaded && storer.inventory[slotID].func_77973_b() instanceof IElectricItem) {
                double sent = (double)ElectricItem.manager.charge(storer.inventory[slotID], (int)(storer.getEnergy() * Mekanism.TO_IC2), 3, false, false) * Mekanism.FROM_IC2;
                storer.setEnergy(storer.getEnergy() - sent);
            } else if (storer.inventory[slotID].func_77973_b() instanceof IChargeableItem) {
                ItemStack itemStack = storer.inventory[slotID];
                IChargeableItem item = (IChargeableItem)storer.inventory[slotID].func_77973_b();
                float itemEnergy = (float)Math.min(Math.sqrt(item.getMaxEnergyStored(itemStack)), (double)(item.getMaxEnergyStored(itemStack) - item.getEnergyStored(itemStack)));
                float toTransfer = (float)Math.min((double)itemEnergy, storer.getEnergy() * Mekanism.TO_BC);
                item.receiveEnergy(itemStack, toTransfer, true);
                storer.setEnergy(storer.getEnergy() - (double)toTransfer * Mekanism.FROM_BC);
            }
        }
    }
}

