/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import mekanism.api.Object3D;
import mekanism.common.SynchronizedTankData;
import mekanism.common.TileEntityDynamicTank;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class DynamicLiquidTank
implements ILiquidTank {
    public TileEntityDynamicTank dynamicTank;

    public DynamicLiquidTank(TileEntityDynamicTank tileEntity) {
        this.dynamicTank = tileEntity;
    }

    public LiquidStack getLiquid() {
        return this.dynamicTank.structure != null ? this.dynamicTank.structure.liquidStored : null;
    }

    public int getCapacity() {
        return this.dynamicTank.structure != null ? this.dynamicTank.structure.volume * 16000 : 0;
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (this.dynamicTank.structure != null && !this.dynamicTank.field_70331_k.field_72995_K) {
            if (resource == null || resource.itemID <= 0) {
                return 0;
            }
            if (this.dynamicTank.structure.liquidStored == null || this.dynamicTank.structure.liquidStored.itemID <= 0) {
                if (resource.amount <= this.getCapacity()) {
                    if (doFill) {
                        this.dynamicTank.structure.liquidStored = resource.copy();
                    }
                    if (resource.amount > 0 && doFill) {
                        this.updateValveData(true);
                        this.dynamicTank.sendPacketToRenderer();
                        this.updateValveData(false);
                    }
                    return resource.amount;
                }
                if (doFill) {
                    this.dynamicTank.structure.liquidStored = resource.copy();
                    this.dynamicTank.structure.liquidStored.amount = this.getCapacity();
                }
                if (this.getCapacity() > 0 && doFill) {
                    this.updateValveData(true);
                    this.dynamicTank.sendPacketToRenderer();
                    this.updateValveData(false);
                }
                return this.getCapacity();
            }
            if (!this.dynamicTank.structure.liquidStored.isLiquidEqual(resource)) {
                return 0;
            }
            int space = this.getCapacity() - this.dynamicTank.structure.liquidStored.amount;
            if (resource.amount <= space) {
                if (doFill) {
                    this.dynamicTank.structure.liquidStored.amount += resource.amount;
                }
                if (resource.amount > 0 && doFill) {
                    this.updateValveData(true);
                    this.dynamicTank.sendPacketToRenderer();
                    this.updateValveData(false);
                }
                return resource.amount;
            }
            if (doFill) {
                this.dynamicTank.structure.liquidStored.amount = this.getCapacity();
            }
            if (space > 0 && doFill) {
                this.updateValveData(true);
                this.dynamicTank.sendPacketToRenderer();
                this.updateValveData(false);
            }
            return space;
        }
        return 0;
    }

    public void updateValveData(boolean value) {
        if (this.dynamicTank.structure != null) {
            for (SynchronizedTankData.ValveData data : this.dynamicTank.structure.valves) {
                if (!data.location.equals(Object3D.get(this.dynamicTank))) continue;
                data.serverLiquid = value;
            }
        }
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.dynamicTank.structure != null && !this.dynamicTank.field_70331_k.field_72995_K) {
            if (this.dynamicTank.structure.liquidStored == null || this.dynamicTank.structure.liquidStored.itemID <= 0) {
                return null;
            }
            if (this.dynamicTank.structure.liquidStored.amount <= 0) {
                return null;
            }
            int used = maxDrain;
            if (this.dynamicTank.structure.liquidStored.amount < used) {
                used = this.dynamicTank.structure.liquidStored.amount;
            }
            if (doDrain) {
                this.dynamicTank.structure.liquidStored.amount -= used;
            }
            LiquidStack drained = new LiquidStack(this.dynamicTank.structure.liquidStored.itemID, used, this.dynamicTank.structure.liquidStored.itemMeta);
            if (this.dynamicTank.structure.liquidStored.amount <= 0) {
                this.dynamicTank.structure.liquidStored = null;
            }
            if (drained.amount > 0 && doDrain) {
                this.dynamicTank.sendPacketToRenderer();
            }
            return drained;
        }
        return null;
    }

    public int getTankPressure() {
        return 0;
    }
}

