/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.power.IPowerReceptor;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.IStrictEnergyAcceptor;
import mekanism.api.Object3D;
import mekanism.common.CableUtils;
import mekanism.common.EnergyNetworkRegistry;
import mekanism.common.IUniversalCable;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkEvent;

public class EnergyNetwork {
    public HashSet cables = new HashSet();
    public Set possibleAcceptors = new HashSet();
    public Map acceptorDirections = new HashMap();
    private double joulesTransmitted = 0.0;
    private double joulesLastTick = 0.0;
    private int ticksSinceCreate = 0;
    private boolean fixed = false;

    public EnergyNetwork(IUniversalCable ... varCables) {
        this.cables.addAll(Arrays.asList(varCables));
        EnergyNetworkRegistry.getInstance().registerNetwork(this);
    }

    public EnergyNetwork(Set networks) {
        for (EnergyNetwork net : networks) {
            if (net == null) continue;
            this.addAllCables(net.cables);
            net.deregister();
        }
        this.refresh();
        EnergyNetworkRegistry.getInstance().registerNetwork(this);
    }

    public double getEnergyNeeded(ArrayList ignored) {
        double totalNeeded = 0.0;
        for (TileEntity acceptor : this.getEnergyAcceptors()) {
            if (ignored.contains(acceptor)) continue;
            if (acceptor instanceof IStrictEnergyAcceptor) {
                totalNeeded += ((IStrictEnergyAcceptor)acceptor).getMaxEnergy() - ((IStrictEnergyAcceptor)acceptor).getEnergy();
                continue;
            }
            if (acceptor instanceof IEnergySink) {
                totalNeeded += Math.min((double)((IEnergySink)acceptor).demandsEnergy() * Mekanism.FROM_IC2, (double)((IEnergySink)acceptor).getMaxSafeInput() * Mekanism.FROM_IC2);
                continue;
            }
            if (!(acceptor instanceof IPowerReceptor) || !Mekanism.hooks.BuildCraftLoaded) continue;
            totalNeeded += (double)((IPowerReceptor)acceptor).powerRequest(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite()) * Mekanism.FROM_BC;
        }
        return totalNeeded;
    }

    public double emit(double energyToSend, ArrayList ignored) {
        double energyAvailable = energyToSend;
        List<Object> availableAcceptors = Arrays.asList(this.getEnergyAcceptors().toArray());
        Collections.shuffle(availableAcceptors);
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            double remaining = energyToSend % (double)divider;
            double sending = (energyToSend - remaining) / (double)divider;
            for (Object obj : availableAcceptors) {
                if (!(obj instanceof TileEntity) || ignored.contains(obj)) continue;
                TileEntity acceptor = (TileEntity)obj;
                double currentSending = sending + remaining;
                remaining = 0.0;
                if (acceptor instanceof IStrictEnergyAcceptor) {
                    energyToSend -= currentSending - ((IStrictEnergyAcceptor)acceptor).transferEnergyToAcceptor(currentSending);
                    continue;
                }
                if (acceptor instanceof IEnergySink) {
                    double toSend = Math.min(currentSending, (double)((IEnergySink)acceptor).getMaxSafeInput() * Mekanism.FROM_IC2);
                    energyToSend -= toSend - (double)((IEnergySink)acceptor).injectEnergy(MekanismUtils.toIC2Direction(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite()), (int)(toSend * Mekanism.TO_IC2)) * Mekanism.FROM_IC2;
                    continue;
                }
                if (!(acceptor instanceof IPowerReceptor) || !Mekanism.hooks.BuildCraftLoaded) continue;
                IPowerReceptor receptor = (IPowerReceptor)acceptor;
                double electricityNeeded = (double)Math.min((float)receptor.powerRequest(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite()), (float)receptor.getPowerProvider().getMaxEnergyStored() - receptor.getPowerProvider().getEnergyStored()) * Mekanism.FROM_BC;
                float transferEnergy = (float)Math.min(electricityNeeded, currentSending);
                receptor.getPowerProvider().receiveEnergy((float)((double)transferEnergy * Mekanism.TO_BC), ((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite());
                energyToSend -= (double)transferEnergy;
            }
            double sent = energyAvailable - energyToSend;
            this.joulesTransmitted += sent;
        }
        return energyToSend;
    }

    public Set getEnergyAcceptors() {
        HashSet<TileEntity> toReturn = new HashSet<TileEntity>();
        for (TileEntity acceptor : this.possibleAcceptors) {
            if (acceptor instanceof IStrictEnergyAcceptor) {
                if (!((IStrictEnergyAcceptor)acceptor).canReceiveEnergy(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite()) || !(((IStrictEnergyAcceptor)acceptor).getMaxEnergy() - ((IStrictEnergyAcceptor)acceptor).getEnergy() > 0.0)) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (acceptor instanceof IEnergySink) {
                if (!((IEnergySink)acceptor).acceptsEnergyFrom(null, MekanismUtils.toIC2Direction((ForgeDirection)this.acceptorDirections.get(acceptor)).getInverse()) || !(Math.min((double)((IEnergySink)acceptor).demandsEnergy() * Mekanism.FROM_IC2, (double)((IEnergySink)acceptor).getMaxSafeInput() * Mekanism.FROM_IC2) > 0.0)) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (!(acceptor instanceof IPowerReceptor) || !Mekanism.hooks.BuildCraftLoaded || ((IPowerReceptor)acceptor).getPowerProvider() == null || !((double)((IPowerReceptor)acceptor).powerRequest(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite()) * Mekanism.FROM_BC > 0.0)) continue;
            toReturn.add(acceptor);
        }
        return toReturn;
    }

    public void refresh() {
        Set iterCables = (Set)this.cables.clone();
        Iterator it = iterCables.iterator();
        this.possibleAcceptors.clear();
        this.acceptorDirections.clear();
        while (it.hasNext()) {
            IUniversalCable conductor = (IUniversalCable)it.next();
            if (conductor == null || ((TileEntity)conductor).func_70320_p()) {
                it.remove();
                this.cables.remove(conductor);
                continue;
            }
            conductor.setNetwork(this);
        }
        for (IUniversalCable cable : iterCables) {
            TileEntity[] acceptors;
            for (TileEntity acceptor : acceptors = CableUtils.getConnectedEnergyAcceptors((TileEntity)cable)) {
                if (acceptor == null || acceptor instanceof IUniversalCable) continue;
                this.possibleAcceptors.add(acceptor);
                this.acceptorDirections.put(acceptor, ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)));
            }
        }
    }

    public void merge(EnergyNetwork network) {
        if (network != null && network != this) {
            HashSet<EnergyNetwork> networks = new HashSet<EnergyNetwork>();
            networks.add(this);
            networks.add(network);
            EnergyNetwork newNetwork = new EnergyNetwork(networks);
            newNetwork.refresh();
        }
    }

    public void addAllCables(Set newCables) {
        this.cables.addAll(newCables);
    }

    public void split(IUniversalCable splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.removeCable(splitPoint);
            TileEntity[] connectedBlocks = new TileEntity[6];
            boolean[] dealtWith = new boolean[]{false, false, false, false, false, false};
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity sideTile = Object3D.get((TileEntity)splitPoint).getFromSide(direction).getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                if (sideTile == null) continue;
                connectedBlocks[Arrays.asList(ForgeDirection.values()).indexOf((Object)direction)] = sideTile;
            }
            for (int countOne = 0; countOne < connectedBlocks.length; ++countOne) {
                TileEntity connectedBlockA = connectedBlocks[countOne];
                if (!(connectedBlockA instanceof IUniversalCable) || dealtWith[countOne]) continue;
                NetworkFinder finder = new NetworkFinder(((TileEntity)splitPoint).field_70331_k, Object3D.get(connectedBlockA), Object3D.get((TileEntity)splitPoint));
                List partNetwork = finder.exploreNetwork();
                for (int countTwo = countOne + 1; countTwo < connectedBlocks.length; ++countTwo) {
                    TileEntity connectedBlockB = connectedBlocks[countTwo];
                    if (!(connectedBlockB instanceof IUniversalCable) || dealtWith[countTwo] || !partNetwork.contains(Object3D.get(connectedBlockB))) continue;
                    dealtWith[countTwo] = true;
                }
                EnergyNetwork newNetwork = new EnergyNetwork(new IUniversalCable[0]);
                for (Object3D node : finder.iterated) {
                    TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                    if (!(nodeTile instanceof IUniversalCable) || nodeTile == splitPoint) continue;
                    newNetwork.cables.add((IUniversalCable)nodeTile);
                }
                newNetwork.refresh();
            }
            this.deregister();
        }
    }

    public void fixMessedUpNetwork(IUniversalCable cable) {
        System.out.println("Fixing Network");
        if (cable instanceof TileEntity) {
            NetworkFinder finder = new NetworkFinder(((TileEntity)cable).func_70314_l(), Object3D.get((TileEntity)cable), null);
            List partNetwork = finder.exploreNetwork();
            HashSet<IUniversalCable> newCables = new HashSet<IUniversalCable>();
            for (Object3D node : partNetwork) {
                TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)cable).field_70331_k);
                if (!(nodeTile instanceof IUniversalCable)) continue;
                ((IUniversalCable)nodeTile).removeFromNetwork();
                newCables.add((IUniversalCable)nodeTile);
            }
            EnergyNetwork newNetwork = new EnergyNetwork(newCables.toArray(new IUniversalCable[0]));
            newNetwork.refresh();
            newNetwork.fixed = true;
            this.deregister();
        }
    }

    public void removeCable(IUniversalCable cable) {
        this.cables.remove(cable);
        if (this.cables.size() == 0) {
            this.deregister();
        }
    }

    public void deregister() {
        this.cables.clear();
        EnergyNetworkRegistry.getInstance().removeNetwork(this);
    }

    public String toString() {
        return "[EnergyNetwork] " + this.cables.size() + " cables, " + this.possibleAcceptors.size() + " acceptors.";
    }

    public void tick() {
        this.clearJoulesTransmitted();
        if (!this.fixed) {
            ++this.ticksSinceCreate;
            if (this.ticksSinceCreate > 1200) {
                this.ticksSinceCreate = 0;
                this.fixMessedUpNetwork(this.cables.toArray(new IUniversalCable[0])[0]);
            }
        }
    }

    public void clearJoulesTransmitted() {
        this.joulesLastTick = this.joulesTransmitted;
        this.joulesTransmitted = 0.0;
    }

    public double getPower() {
        return this.joulesLastTick * 20.0;
    }

    public static class NetworkLoader {
        @ForgeSubscribe
        public void onChunkLoad(ChunkEvent.Load event) {
            if (event.getChunk() != null) {
                for (Object obj : event.getChunk().field_76648_i.values()) {
                    TileEntity tileEntity;
                    if (!(obj instanceof TileEntity) || !((tileEntity = (TileEntity)obj) instanceof IUniversalCable)) continue;
                    ((IUniversalCable)tileEntity).refreshNetwork();
                }
            }
        }
    }

    public static class NetworkFinder {
        public World worldObj;
        public Object3D start;
        public List iterated = new ArrayList();
        public List toIgnore = new ArrayList();

        public NetworkFinder(World world, Object3D location, Object3D ... ignore) {
            this.worldObj = world;
            this.start = location;
            if (ignore != null) {
                this.toIgnore = Arrays.asList(ignore);
            }
        }

        public void loopAll(Object3D location) {
            if (location.getTileEntity((IBlockAccess)this.worldObj) instanceof IUniversalCable) {
                this.iterated.add(location);
            }
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity;
                Object3D obj = location.getFromSide(direction);
                if (this.iterated.contains(obj) || this.toIgnore.contains(obj) || !((tileEntity = obj.getTileEntity((IBlockAccess)this.worldObj)) instanceof IUniversalCable)) continue;
                this.loopAll(obj);
            }
        }

        public List exploreNetwork() {
            this.loopAll(this.start);
            return this.iterated;
        }
    }
}

