/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import mekanism.common.EnergyNetwork;

public class EnergyNetworkRegistry
implements ITickHandler {
    private static EnergyNetworkRegistry INSTANCE = new EnergyNetworkRegistry();
    private HashSet networks = new HashSet();

    public EnergyNetworkRegistry() {
        TickRegistry.registerTickHandler((ITickHandler)this, (Side)Side.SERVER);
    }

    public static EnergyNetworkRegistry getInstance() {
        return INSTANCE;
    }

    public void registerNetwork(EnergyNetwork network) {
        this.networks.add(network);
    }

    public void removeNetwork(EnergyNetwork network) {
        if (this.networks.contains(network)) {
            this.networks.remove(network);
        }
    }

    public void pruneEmptyNetworks() {
        for (EnergyNetwork e : this.networks) {
            if (e.cables.size() != 0) continue;
            this.removeNetwork(e);
        }
    }

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        Set iterNetworks = (Set)this.networks.clone();
        for (EnergyNetwork net : iterNetworks) {
            if (!this.networks.contains(net)) continue;
            net.tick();
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.SERVER);
    }

    public String getLabel() {
        return "Mekanism Energy Networks";
    }

    public String toString() {
        return this.networks.toString();
    }
}

