/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ICustomElectricItem;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.IEnergizedItem;
import mekanism.api.Object3D;
import mekanism.common.IEnergyCube;
import mekanism.common.ISustainedInventory;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.Tier;
import mekanism.common.TileEntityEnergyCube;
import mekanism.common.network.PacketTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import thermalexpansion.api.item.IChargeableItem;
import universalelectricity.core.electricity.ElectricityDisplay;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.IItemElectric;

public class ItemBlockEnergyCube
extends ItemBlock
implements IEnergizedItem,
IItemElectric,
IEnergyCube,
ICustomElectricItem,
ISustainedInventory,
IChargeableItem {
    public Block metaBlock;

    public ItemBlockEnergyCube(int id, Block block) {
        super(id);
        this.metaBlock = block;
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77637_a(Mekanism.tabMekanism);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        if (!Keyboard.isKeyDown((int)42)) {
            list.add("Hold " + (Object)((Object)EnumColor.AQUA) + "shift" + (Object)((Object)EnumColor.GREY) + " for more details.");
        } else {
            list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + "Stored Energy: " + (Object)((Object)EnumColor.GREY) + ElectricityDisplay.getDisplayShort(this.getJoules(itemstack), ElectricityDisplay.ElectricUnit.JOULES));
            list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + "Voltage: " + (Object)((Object)EnumColor.GREY) + this.getVoltage(itemstack) + "v");
            list.add((Object)((Object)EnumColor.AQUA) + "Inventory: " + (Object)((Object)EnumColor.GREY) + (this.getInventory(itemstack) != null && this.getInventory((Object[])new Object[]{itemstack}).field_74747_a != null && !this.getInventory((Object[])new Object[]{itemstack}).field_74747_a.isEmpty()));
        }
    }

    public ItemStack getUnchargedItem(Tier.EnergyCubeTier tier) {
        ItemStack charged = new ItemStack((Item)this);
        this.setEnergyCubeTier(charged, tier);
        charged.func_77964_b(100);
        return charged;
    }

    @Override
    public double getJoules(ItemStack itemStack) {
        return this.getEnergy(itemStack);
    }

    @Override
    public void setJoules(double wattHours, ItemStack itemStack) {
        this.setEnergy(itemStack, wattHours);
    }

    @Override
    public double getMaxJoules(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack);
    }

    @Override
    public double getVoltage(ItemStack itemStack) {
        return this.getEnergyCubeTier((ItemStack)itemStack).VOLTAGE;
    }

    @Override
    public ElectricityPack onReceive(ElectricityPack electricityPack, ItemStack itemStack) {
        double rejectedElectricity = Math.max(this.getJoules(itemStack) + electricityPack.getWatts() - this.getMaxJoules(itemStack), 0.0);
        double joulesToStore = electricityPack.getWatts() - rejectedElectricity;
        this.setJoules(this.getJoules(itemStack) + joulesToStore, itemStack);
        return ElectricityPack.getFromWatts(joulesToStore, this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack onProvide(ElectricityPack electricityPack, ItemStack itemStack) {
        double electricityToUse = Math.min(this.getJoules(itemStack), electricityPack.getWatts());
        this.setJoules(this.getJoules(itemStack) - electricityToUse, itemStack);
        return ElectricityPack.getFromWatts(electricityToUse, this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack getReceiveRequest(ItemStack itemStack) {
        return ElectricityPack.getFromWatts(Math.min(this.getMaxJoules(itemStack) - this.getJoules(itemStack), this.getTransferRate(itemStack)), this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack getProvideRequest(ItemStack itemStack) {
        return ElectricityPack.getFromWatts(Math.min(this.getJoules(itemStack), this.getTransferRate(itemStack)), this.getVoltage(itemStack));
    }

    public double getTransferRate(ItemStack itemStack) {
        return this.getMaxTransfer(itemStack);
    }

    public String func_77667_c(ItemStack itemstack) {
        return this.func_77658_a() + "." + this.getEnergyCubeTier((ItemStack)itemstack).name;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (place) {
            TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_72796_p(x, y, z);
            tileEntity.tier = ((IEnergyCube)stack.func_77973_b()).getEnergyCubeTier(stack);
            tileEntity.electricityStored = this.getJoules(stack);
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            if (tileEntity.powerProvider != null) {
                tileEntity.powerProvider.configure(0, 0, 100, 0, (int)(tileEntity.tier.MAX_ELECTRICITY * Mekanism.TO_BC));
            }
            if (!world.field_72995_K) {
                PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Object[0]);
            }
        }
        return place;
    }

    @Override
    public Tier.EnergyCubeTier getEnergyCubeTier(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return Tier.EnergyCubeTier.BASIC;
        }
        if (itemstack.field_77990_d.func_74779_i("tier") == null) {
            return Tier.EnergyCubeTier.BASIC;
        }
        return Tier.EnergyCubeTier.getFromName(itemstack.field_77990_d.func_74779_i("tier"));
    }

    @Override
    public void setEnergyCubeTier(ItemStack itemstack, Tier.EnergyCubeTier tier) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.field_77990_d.func_74778_a("tier", tier.name);
    }

    @Override
    public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double energyNeeded = this.getMaxEnergy(itemStack) - this.getEnergy(itemStack);
        double energyToStore = Math.min(Math.min((double)amount * Mekanism.FROM_IC2, this.getMaxEnergy(itemStack) * 0.01), energyNeeded);
        if (!simulate) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) + energyToStore);
        }
        return (int)(energyToStore * Mekanism.TO_IC2);
    }

    @Override
    public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double energyWanted = (double)amount * Mekanism.FROM_IC2;
        double energyToGive = Math.min(Math.min(energyWanted, this.getMaxEnergy(itemStack) * 0.01), this.getJoules(itemStack));
        if (!simulate) {
            this.setJoules(this.getJoules(itemStack) - energyToGive, itemStack);
        }
        return (int)(energyToGive * Mekanism.TO_IC2);
    }

    @Override
    public boolean canUse(ItemStack itemStack, int amount) {
        return this.getJoules(itemStack) >= (double)amount * Mekanism.FROM_IC2;
    }

    @Override
    public boolean canShowChargeToolTip(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Override
    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack itemStack) {
        return 0;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 3;
    }

    @Override
    public int getTransferLimit(ItemStack itemStack) {
        return 0;
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_74761_m("Items");
        }
        return null;
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0;
        }
        double electricityStored = itemStack.field_77990_d.func_74769_h("electricity");
        itemStack.func_77964_b((int)Math.max(1.0, Math.abs(electricityStored / this.getMaxEnergy(itemStack) * 100.0 - 100.0)));
        return electricityStored;
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxJoules(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
        itemStack.func_77964_b((int)Math.max(1.0, Math.abs(electricityStored / this.getMaxEnergy(itemStack) * 100.0 - 100.0)));
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.getEnergyCubeTier((ItemStack)itemStack).MAX_ELECTRICITY;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    @Override
    public float receiveEnergy(ItemStack theItem, float energy, boolean doReceive) {
        double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
        double toReceive = Math.min((double)energy * Mekanism.FROM_BC, energyNeeded);
        if (doReceive) {
            this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
        }
        return (float)(toReceive * Mekanism.TO_BC);
    }

    @Override
    public float transferEnergy(ItemStack theItem, float energy, boolean doTransfer) {
        double energyRemaining = this.getEnergy(theItem);
        double toSend = Math.min((double)energy * Mekanism.FROM_BC, energyRemaining);
        if (doTransfer) {
            this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
        }
        return (float)(toSend * Mekanism.TO_BC);
    }

    @Override
    public float getEnergyStored(ItemStack theItem) {
        return (float)(this.getEnergy(theItem) * Mekanism.TO_BC);
    }

    @Override
    public float getMaxEnergyStored(ItemStack theItem) {
        return (float)(this.getMaxEnergy(theItem) * Mekanism.TO_BC);
    }

    @Override
    public boolean isMetadataSpecific() {
        return false;
    }
}

