/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ICustomElectricItem;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.IEnergizedItem;
import mekanism.api.IUpgradeManagement;
import mekanism.common.BlockMachine;
import mekanism.common.IElectricChest;
import mekanism.common.IFactory;
import mekanism.common.ISustainedInventory;
import mekanism.common.ISustainedTank;
import mekanism.common.InventoryElectricChest;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.TileEntityElectricBlock;
import mekanism.common.TileEntityElectricChest;
import mekanism.common.TileEntityFactory;
import mekanism.common.network.PacketElectricChest;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.input.Keyboard;
import thermalexpansion.api.item.IChargeableItem;
import universalelectricity.core.electricity.ElectricityDisplay;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.IItemElectric;

public class ItemBlockMachine
extends ItemBlock
implements IEnergizedItem,
IItemElectric,
ICustomElectricItem,
IUpgradeManagement,
IFactory,
ISustainedInventory,
ISustainedTank,
IElectricChest,
IChargeableItem {
    public Block metaBlock;

    public ItemBlockMachine(int id, Block block) {
        super(id);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public String func_77667_c(ItemStack itemstack) {
        String name = "";
        switch (itemstack.func_77960_j()) {
            case 0: {
                name = "EnrichmentChamber";
                break;
            }
            case 1: {
                name = "OsmiumCompressor";
                break;
            }
            case 2: {
                name = "Combiner";
                break;
            }
            case 3: {
                name = "Crusher";
                break;
            }
            case 4: {
                name = "TheoreticalElementizer";
                break;
            }
            case 5: {
                name = "BasicFactory";
                break;
            }
            case 6: {
                name = "AdvancedFactory";
                break;
            }
            case 7: {
                name = "EliteFactory";
                break;
            }
            case 8: {
                name = "MetallurgicInfuser";
                break;
            }
            case 9: {
                name = "PurificationChamber";
                break;
            }
            case 10: {
                name = "EnergizedSmelter";
                break;
            }
            case 11: {
                name = "Teleporter";
                break;
            }
            case 12: {
                name = "ElectricPump";
                break;
            }
            case 13: {
                name = "ElectricChest";
                break;
            }
            case 14: {
                name = "Chargepad";
                break;
            }
            default: {
                name = "Unknown";
            }
        }
        return this.func_77658_a() + "." + name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        if (!Keyboard.isKeyDown((int)42)) {
            list.add("Hold " + (Object)((Object)EnumColor.AQUA) + "shift" + (Object)((Object)EnumColor.GREY) + " for more details.");
        } else {
            if (this.isFactory(itemstack)) {
                list.add((Object)((Object)EnumColor.INDIGO) + "Recipe Type: " + (Object)((Object)EnumColor.GREY) + IFactory.RecipeType.values()[this.getRecipeType(itemstack)].getName());
            }
            if (this.isElectricChest(itemstack)) {
                list.add((Object)((Object)EnumColor.INDIGO) + "Authenticated: " + (Object)((Object)EnumColor.GREY) + this.getAuthenticated(itemstack));
                list.add((Object)((Object)EnumColor.INDIGO) + "Locked: " + (Object)((Object)EnumColor.GREY) + this.getLocked(itemstack));
            }
            list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + "Stored Energy: " + (Object)((Object)EnumColor.GREY) + ElectricityDisplay.getDisplayShort(this.getJoules(itemstack), ElectricityDisplay.ElectricUnit.JOULES));
            list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + "Voltage: " + (Object)((Object)EnumColor.GREY) + this.getVoltage(itemstack) + "v");
            if (this.hasTank(itemstack) && this.getLiquidStack(itemstack) != null) {
                list.add((Object)((Object)EnumColor.PINK) + LiquidDictionary.findLiquidName((LiquidStack)this.getLiquidStack(itemstack)) + ": " + (Object)((Object)EnumColor.GREY) + this.getLiquidStack((Object[])new Object[]{itemstack}).amount + "mB");
            }
            if (this.supportsUpgrades(itemstack)) {
                list.add((Object)((Object)EnumColor.PURPLE) + "Energy: " + (Object)((Object)EnumColor.GREY) + "x" + (this.getEnergyMultiplier(itemstack) + 1));
                list.add((Object)((Object)EnumColor.PURPLE) + "Speed: " + (Object)((Object)EnumColor.GREY) + "x" + (this.getSpeedMultiplier(itemstack) + 1));
            }
            if (itemstack.func_77960_j() != 14) {
                list.add((Object)((Object)EnumColor.AQUA) + "Inventory: " + (Object)((Object)EnumColor.GREY) + (this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
            }
        }
    }

    @Override
    public double getJoules(ItemStack itemStack) {
        return this.getEnergy(itemStack);
    }

    @Override
    public void setJoules(double wattHours, ItemStack itemStack) {
        this.setEnergy(itemStack, wattHours);
    }

    @Override
    public double getMaxJoules(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack);
    }

    @Override
    public double getVoltage(ItemStack itemStack) {
        return 120.0;
    }

    @Override
    public ElectricityPack onReceive(ElectricityPack electricityPack, ItemStack itemStack) {
        double rejectedElectricity = Math.max(this.getJoules(itemStack) + electricityPack.getWatts() - this.getMaxJoules(itemStack), 0.0);
        double joulesToStore = electricityPack.getWatts() - rejectedElectricity;
        this.setJoules(this.getJoules(itemStack) + joulesToStore, itemStack);
        return ElectricityPack.getFromWatts(joulesToStore, this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack onProvide(ElectricityPack electricityPack, ItemStack itemStack) {
        return new ElectricityPack();
    }

    @Override
    public ElectricityPack getReceiveRequest(ItemStack itemStack) {
        return ElectricityPack.getFromWatts(Math.min(this.getMaxJoules(itemStack) - this.getJoules(itemStack), this.getTransferRate(itemStack)), this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack getProvideRequest(ItemStack itemStack) {
        return new ElectricityPack();
    }

    public double getTransferRate(ItemStack itemStack) {
        return this.getMaxTransfer(itemStack);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (place) {
            TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_72796_p(x, y, z);
            if (tileEntity instanceof IUpgradeManagement) {
                ((IUpgradeManagement)((Object)tileEntity)).setEnergyMultiplier(this.getEnergyMultiplier(stack), new Object[0]);
                ((IUpgradeManagement)((Object)tileEntity)).setSpeedMultiplier(this.getSpeedMultiplier(stack), new Object[0]);
            }
            if (tileEntity instanceof TileEntityFactory) {
                ((TileEntityFactory)tileEntity).recipeType = this.getRecipeType(stack);
            }
            if (tileEntity instanceof ISustainedTank && this.hasTank(stack) && this.getLiquidStack(stack) != null) {
                ((ISustainedTank)((Object)tileEntity)).setLiquidStack(this.getLiquidStack(stack), new Object[0]);
            }
            if (tileEntity instanceof TileEntityElectricChest) {
                ((TileEntityElectricChest)tileEntity).authenticated = this.getAuthenticated(stack);
                ((TileEntityElectricChest)tileEntity).locked = this.getLocked(stack);
                ((TileEntityElectricChest)tileEntity).password = this.getPassword(stack);
            }
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            tileEntity.electricityStored = this.getJoules(stack);
        }
        return place;
    }

    @Override
    public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double energyNeeded = this.getMaxEnergy(itemStack) - this.getEnergy(itemStack);
        double energyToStore = Math.min(Math.min((double)amount * Mekanism.FROM_IC2, this.getMaxEnergy(itemStack) * 0.01), energyNeeded);
        if (!simulate) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) + energyToStore);
        }
        return (int)(energyToStore * Mekanism.TO_IC2);
    }

    @Override
    public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canUse(ItemStack itemStack, int amount) {
        return this.getJoules(itemStack) >= (double)amount * Mekanism.FROM_IC2;
    }

    @Override
    public boolean canShowChargeToolTip(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack itemStack) {
        return 0;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 3;
    }

    @Override
    public int getTransferLimit(ItemStack itemStack) {
        return 0;
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (this.isElectricChest(itemstack)) {
            this.setPrevLidAngle(itemstack, this.getLidAngle(itemstack));
            float increment = 0.1f;
            if (!this.getOpen(itemstack) && this.getLidAngle(itemstack) > 0.0f || this.getOpen(itemstack) && this.getLidAngle(itemstack) < 1.0f) {
                float angle = this.getLidAngle(itemstack);
                if (this.getOpen(itemstack)) {
                    this.setLidAngle(itemstack, this.getLidAngle(itemstack) + increment);
                } else {
                    this.setLidAngle(itemstack, this.getLidAngle(itemstack) - increment);
                }
                if (this.getLidAngle(itemstack) > 1.0f) {
                    this.setLidAngle(itemstack, 1.0f);
                }
                float split = 0.5f;
                if (this.getLidAngle(itemstack) < 0.0f) {
                    this.setLidAngle(itemstack, 0.0f);
                }
            }
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        this.func_77663_a(entityItem.func_92059_d(), null, (Entity)entityItem, 0, false);
        return false;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return 0;
            }
            return itemStack.field_77990_d.func_74762_e("energyMultiplier");
        }
        return 0;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74768_a("energyMultiplier", multiplier);
        }
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return 0;
            }
            return itemStack.field_77990_d.func_74762_e("speedMultiplier");
        }
        return 0;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74768_a("speedMultiplier", multiplier);
        }
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        return data[0] instanceof ItemStack && ((ItemStack)data[0]).func_77960_j() != 11 && ((ItemStack)data[0]).func_77960_j() != 12 && ((ItemStack)data[0]).func_77960_j() != 13 && ((ItemStack)data[0]).func_77960_j() != 14;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.field_72995_K && this.isElectricChest(itemstack)) {
            if (!this.getAuthenticated(itemstack)) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 2, 0, false}), entityplayer);
            } else if (this.getLocked(itemstack) && this.getJoules(itemstack) > 0.0) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 1, 0, false}), entityplayer);
            } else {
                InventoryElectricChest inventory = new InventoryElectricChest(entityplayer);
                MekanismUtils.openElectricChestGui((EntityPlayerMP)entityplayer, null, (IInventory)inventory, false);
            }
        }
        return itemstack;
    }

    @Override
    public int getRecipeType(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0;
        }
        return itemStack.field_77990_d.func_74762_e("recipeType");
    }

    @Override
    public void setRecipeType(int type, ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74768_a("recipeType", type);
    }

    @Override
    public boolean isFactory(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ItemBlockMachine && itemStack.func_77960_j() >= 5 && itemStack.func_77960_j() <= 7;
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_74761_m("Items");
        }
        return null;
    }

    @Override
    public void setLiquidStack(LiquidStack liquidStack, Object ... data) {
        if (liquidStack == null || liquidStack.amount == 0 || liquidStack.itemID == 0) {
            return;
        }
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("liquidTank", (NBTBase)liquidStack.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public LiquidStack getLiquidStack(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            if (itemStack.field_77990_d.func_74764_b("liquidTank")) {
                return LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("liquidTank"));
            }
        }
        return null;
    }

    @Override
    public boolean hasTank(Object ... data) {
        return data[0] instanceof ItemStack && ((ItemStack)data[0]).func_77973_b() instanceof ISustainedTank && ((ItemStack)data[0]).func_77960_j() == 12;
    }

    @Override
    public void setAuthenticated(ItemStack itemStack, boolean auth) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("authenticated", auth);
    }

    @Override
    public boolean getAuthenticated(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n("authenticated");
    }

    @Override
    public boolean isElectricChest(ItemStack itemStack) {
        return itemStack.func_77960_j() == 13;
    }

    @Override
    public void setPassword(ItemStack itemStack, String pass) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74778_a("password", pass);
    }

    @Override
    public String getPassword(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return "";
        }
        return itemStack.field_77990_d.func_74779_i("password");
    }

    @Override
    public void setLocked(ItemStack itemStack, boolean locked) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("locked", locked);
    }

    @Override
    public boolean getLocked(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n("locked");
    }

    @Override
    public void setOpen(ItemStack itemStack, boolean open) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("open", open);
    }

    @Override
    public boolean getOpen(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n("open");
    }

    @Override
    public void setLidAngle(ItemStack itemStack, float lidAngle) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74776_a("lidAngle", lidAngle);
    }

    @Override
    public float getLidAngle(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0f;
        }
        return itemStack.field_77990_d.func_74760_g("lidAngle");
    }

    @Override
    public void setPrevLidAngle(ItemStack itemStack, float prevLidAngle) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74776_a("prevLidAngle", prevLidAngle);
    }

    @Override
    public float getPrevLidAngle(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0f;
        }
        return itemStack.field_77990_d.func_74760_g("prevLidAngle");
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0;
        }
        return itemStack.field_77990_d.func_74769_h("electricity");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxJoules(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return MekanismUtils.getEnergy(this.getEnergyMultiplier(itemStack), BlockMachine.MachineType.getFromMetadata((int)itemStack.func_77960_j()).baseEnergy);
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Override
    public float receiveEnergy(ItemStack theItem, float energy, boolean doReceive) {
        double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
        double toReceive = Math.min((double)energy * Mekanism.FROM_BC, energyNeeded);
        if (doReceive) {
            this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
        }
        return (float)(toReceive * Mekanism.TO_BC);
    }

    @Override
    public float transferEnergy(ItemStack theItem, float energy, boolean doTransfer) {
        return 0.0f;
    }

    @Override
    public float getEnergyStored(ItemStack theItem) {
        return (float)(this.getEnergy(theItem) * Mekanism.TO_BC);
    }

    @Override
    public float getMaxEnergyStored(ItemStack theItem) {
        return (float)(this.getMaxEnergy(theItem) * Mekanism.TO_BC);
    }

    @Override
    public boolean isMetadataSpecific() {
        return true;
    }
}

