/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.Object3D;
import mekanism.api.SideData;
import mekanism.common.IUniversalCable;
import mekanism.common.ItemEnergized;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.TileEntityBasicBlock;
import mekanism.common.TileEntityContainerBlock;
import mekanism.common.TileEntityElectricChest;
import mekanism.common.TileEntityElectricPump;
import mekanism.common.TileEntityMechanicalPipe;
import mekanism.common.network.PacketTileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityPack;

public class ItemConfigurator
extends ItemEnergized {
    public final int ENERGY_PER_CONFIGURE = 400;
    public final int ENERGY_PER_ITEM_DUMP = 8;

    public ItemConfigurator(int id) {
        super(id, 60000.0, 120.0);
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        super.func_77624_a(itemstack, entityplayer, list, flag);
        list.add((Object)((Object)EnumColor.PINK) + "State: " + (Object)((Object)EnumColor.GREY) + this.getState(this.getState(itemstack)));
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tileEntity;
            if (player.func_70093_af()) {
                if (world.func_72796_p(x, y, z) instanceof TileEntityMechanicalPipe) {
                    TileEntityMechanicalPipe tileEntity2 = (TileEntityMechanicalPipe)world.func_72796_p(x, y, z);
                    tileEntity2.isActive = !tileEntity2.isActive;
                    PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(tileEntity2), tileEntity2.getNetworkedData(new ArrayList())), new Object[0]);
                    return true;
                }
                if (world.func_72796_p(x, y, z) instanceof TileEntityElectricPump) {
                    TileEntityElectricPump tileEntity3 = (TileEntityElectricPump)world.func_72796_p(x, y, z);
                    tileEntity3.recurringNodes.clear();
                    tileEntity3.cleaningNodes.clear();
                    player.func_70006_a((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + "Reset Electric Pump calculation.");
                    return true;
                }
            } else if (world.func_72796_p(x, y, z) instanceof IUniversalCable) {
                ((IUniversalCable)world.func_72796_p(x, y, z)).fixNetwork();
            }
            if (this.getState(stack) == 0) {
                if (world.func_72796_p(x, y, z) instanceof IConfigurable) {
                    IConfigurable config = (IConfigurable)world.func_72796_p(x, y, z);
                    if (!player.func_70093_af()) {
                        player.func_70006_a((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " Current color: " + ((SideData)config.getSideData().get((int)config.getConfiguration()[MekanismUtils.getBaseOrientation((int)side, (int)config.getOrientation())])).color.getName());
                        return true;
                    }
                    if (this.getEnergy(stack) >= 400.0) {
                        this.setEnergy(stack, this.getEnergy(stack) - 400.0);
                        MekanismUtils.incrementOutput(config, MekanismUtils.getBaseOrientation(side, config.getOrientation()));
                        player.func_70006_a((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " Color bumped to: " + ((SideData)config.getSideData().get((int)config.getConfiguration()[MekanismUtils.getBaseOrientation((int)side, (int)config.getOrientation())])).color.getName());
                        if (config instanceof TileEntityBasicBlock) {
                            TileEntityBasicBlock tileEntity4 = (TileEntityBasicBlock)((Object)config);
                            PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(tileEntity4), tileEntity4.getNetworkedData(new ArrayList())), Object3D.get(tileEntity4), 50.0);
                        }
                        return true;
                    }
                }
            } else if (this.getState(stack) == 1) {
                if (world.func_72796_p(x, y, z) instanceof TileEntityContainerBlock) {
                    int itemAmount = 0;
                    Random random = new Random();
                    TileEntityContainerBlock tileEntity5 = (TileEntityContainerBlock)world.func_72796_p(x, y, z);
                    if (!(tileEntity5 instanceof TileEntityElectricChest) || ((TileEntityElectricChest)tileEntity5).canAccess()) {
                        for (int i = 0; i < tileEntity5.func_70302_i_(); ++i) {
                            ItemStack slotStack = tileEntity5.func_70301_a(i);
                            itemAmount += slotStack != null ? slotStack.field_77994_a : 0;
                            if (slotStack == null) continue;
                            float xRandom = random.nextFloat() * 0.8f + 0.1f;
                            float yRandom = random.nextFloat() * 0.8f + 0.1f;
                            float zRandom = random.nextFloat() * 0.8f + 0.1f;
                            while (slotStack.field_77994_a > 0) {
                                int j = random.nextInt(21) + 10;
                                if (j > slotStack.field_77994_a) {
                                    j = slotStack.field_77994_a;
                                }
                                slotStack.field_77994_a -= j;
                                EntityItem item = new EntityItem(world, (double)((float)x + xRandom), (double)((float)y + yRandom), (double)((float)z + zRandom), new ItemStack(slotStack.field_77993_c, j, slotStack.func_77960_j()));
                                if (slotStack.func_77942_o()) {
                                    item.func_92059_d().func_77982_d((NBTTagCompound)slotStack.func_77978_p().func_74737_b());
                                }
                                float k = 0.05f;
                                item.field_70159_w = random.nextGaussian() * (double)k;
                                item.field_70181_x = random.nextGaussian() * (double)k + (double)0.2f;
                                item.field_70179_y = random.nextGaussian() * (double)k;
                                world.func_72838_d((Entity)item);
                            }
                        }
                        tileEntity5.inventory = new ItemStack[tileEntity5.func_70302_i_()];
                        this.onProvide(new ElectricityPack(8 * itemAmount / 120, 120.0), stack);
                        return true;
                    }
                    player.func_71035_c((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + "You are not authenticated on this chest.");
                    return true;
                }
            } else if (this.getState(stack) == 2 && (tileEntity = world.func_72796_p(x, y, z)) instanceof TileEntityBasicBlock) {
                TileEntityBasicBlock basicBlock = (TileEntityBasicBlock)tileEntity;
                int newSide = basicBlock.facing;
                newSide = !player.func_70093_af() ? side : ForgeDirection.OPPOSITES[side];
                if (basicBlock.canSetFacing(newSide)) {
                    basicBlock.setFacing((short)newSide);
                    world.func_72908_a((double)x, (double)y, (double)z, "random.click", 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    public String getState(int state) {
        switch (state) {
            case 0: {
                return "modify";
            }
            case 1: {
                return "empty";
            }
            case 2: {
                return "wrench";
            }
        }
        return "unknown";
    }

    public EnumColor getColor(int state) {
        switch (state) {
            case 0: {
                return EnumColor.BRIGHT_GREEN;
            }
            case 1: {
                return EnumColor.AQUA;
            }
            case 2: {
                return EnumColor.YELLOW;
            }
        }
        return EnumColor.GREY;
    }

    public void setState(ItemStack itemstack, byte state) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.field_77990_d.func_74774_a("state", state);
    }

    public byte getState(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return 0;
        }
        byte state = 0;
        if (itemstack.field_77990_d.func_74781_a("state") != null) {
            state = itemstack.field_77990_d.func_74771_c("state");
        }
        return state;
    }

    @Override
    public ElectricityPack getProvideRequest(ItemStack itemStack) {
        return new ElectricityPack();
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }
}

