/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import ic2.api.item.ICustomElectricItem;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.IEnergizedItem;
import mekanism.common.ItemMekanism;
import mekanism.common.Mekanism;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thermalexpansion.api.item.IChargeableItem;
import universalelectricity.core.electricity.ElectricityDisplay;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.IItemElectric;

public class ItemEnergized
extends ItemMekanism
implements IEnergizedItem,
IItemElectric,
ICustomElectricItem,
IChargeableItem {
    public double MAX_ELECTRICITY;
    public double VOLTAGE;

    public ItemEnergized(int id, double maxElectricity, double voltage) {
        super(id);
        this.MAX_ELECTRICITY = maxElectricity;
        this.VOLTAGE = voltage;
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add((Object)((Object)EnumColor.AQUA) + "Stored Energy: " + (Object)((Object)EnumColor.GREY) + ElectricityDisplay.getDisplayShort(this.getJoules(itemstack), ElectricityDisplay.ElectricUnit.JOULES));
        list.add((Object)((Object)EnumColor.AQUA) + "Voltage: " + (Object)((Object)EnumColor.GREY) + this.getVoltage(itemstack) + "v");
    }

    public void func_77622_d(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        itemstack = this.getUnchargedItem();
    }

    public ItemStack getUnchargedItem() {
        ItemStack charged = new ItemStack((Item)this);
        charged.func_77964_b(100);
        return charged;
    }

    public void func_77633_a(int i, CreativeTabs tabs, List list) {
        ItemStack discharged = new ItemStack((Item)this);
        discharged.func_77964_b(100);
        list.add(discharged);
        ItemStack charged = new ItemStack((Item)this);
        this.setJoules(((IItemElectric)charged.func_77973_b()).getMaxJoules(charged), charged);
        list.add(charged);
    }

    @Override
    public double getJoules(ItemStack itemStack) {
        return this.getEnergy(itemStack);
    }

    @Override
    public void setJoules(double wattHours, ItemStack itemStack) {
        this.setEnergy(itemStack, wattHours);
    }

    @Override
    public double getMaxJoules(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack);
    }

    @Override
    public double getVoltage(ItemStack itemStack) {
        return this.VOLTAGE;
    }

    @Override
    public ElectricityPack onReceive(ElectricityPack electricityPack, ItemStack itemStack) {
        double rejectedElectricity = Math.max(this.getJoules(itemStack) + electricityPack.getWatts() - this.getMaxJoules(itemStack), 0.0);
        double joulesToStore = electricityPack.getWatts() - rejectedElectricity;
        this.setJoules(this.getJoules(itemStack) + joulesToStore, itemStack);
        return ElectricityPack.getFromWatts(joulesToStore, this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack onProvide(ElectricityPack electricityPack, ItemStack itemStack) {
        double electricityToUse = Math.min(this.getJoules(itemStack), electricityPack.getWatts());
        this.setJoules(this.getJoules(itemStack) - electricityToUse, itemStack);
        return ElectricityPack.getFromWatts(electricityToUse, this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack getReceiveRequest(ItemStack itemStack) {
        return ElectricityPack.getFromWatts(Math.min(this.getMaxJoules(itemStack) - this.getJoules(itemStack), this.getTransferRate(itemStack)), this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack getProvideRequest(ItemStack itemStack) {
        return ElectricityPack.getFromWatts(Math.min(this.getJoules(itemStack), this.getTransferRate(itemStack)), this.getVoltage(itemStack));
    }

    public double getTransferRate(ItemStack itemStack) {
        return this.getMaxTransfer(itemStack);
    }

    @Override
    public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double energyNeeded = this.getMaxEnergy(itemStack) - this.getEnergy(itemStack);
        double energyToStore = Math.min(Math.min((double)amount * Mekanism.FROM_IC2, this.getMaxEnergy(itemStack) * 0.01), energyNeeded);
        if (!simulate) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) + energyToStore);
        }
        return (int)(energyToStore * Mekanism.TO_IC2);
    }

    @Override
    public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double energyWanted = (double)amount * Mekanism.FROM_IC2;
        double energyToGive = Math.min(Math.min(energyWanted, this.getMaxEnergy(itemStack) * 0.01), this.getJoules(itemStack));
        if (!simulate) {
            this.setJoules(this.getJoules(itemStack) - energyToGive, itemStack);
        }
        return (int)(energyToGive * Mekanism.TO_IC2);
    }

    @Override
    public boolean canUse(ItemStack itemStack, int amount) {
        return this.getJoules(itemStack) >= (double)amount * Mekanism.FROM_IC2;
    }

    @Override
    public boolean canShowChargeToolTip(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return this.canSend(itemStack);
    }

    @Override
    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack itemStack) {
        return 0;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 3;
    }

    @Override
    public int getTransferLimit(ItemStack itemStack) {
        return 0;
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0;
        }
        double electricityStored = itemStack.field_77990_d.func_74769_h("electricity");
        itemStack.func_77964_b((int)Math.max(1.0, Math.abs(electricityStored / this.getMaxEnergy(itemStack) * 100.0 - 100.0)));
        return electricityStored;
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxJoules(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
        itemStack.func_77964_b((int)Math.max(1.0, Math.abs(electricityStored / this.getMaxEnergy(itemStack) * 100.0 - 100.0)));
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.MAX_ELECTRICITY;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    @Override
    public float receiveEnergy(ItemStack theItem, float energy, boolean doReceive) {
        double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
        double toReceive = Math.min((double)energy * Mekanism.FROM_BC, energyNeeded);
        if (doReceive) {
            this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
        }
        return (float)(toReceive * Mekanism.TO_BC);
    }

    @Override
    public float transferEnergy(ItemStack theItem, float energy, boolean doTransfer) {
        double energyRemaining = this.getEnergy(theItem);
        double toSend = Math.min((double)energy * Mekanism.FROM_BC, energyRemaining);
        if (doTransfer) {
            this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
        }
        return (float)(toSend * Mekanism.TO_BC);
    }

    @Override
    public float getEnergyStored(ItemStack theItem) {
        return (float)(this.getEnergy(theItem) * Mekanism.TO_BC);
    }

    @Override
    public float getMaxEnergyStored(ItemStack theItem) {
        return (float)(this.getMaxEnergy(theItem) * Mekanism.TO_BC);
    }

    @Override
    public boolean isMetadataSpecific() {
        return false;
    }
}

