/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.List;
import mekanism.api.EnumGas;
import mekanism.api.IStorageTank;
import mekanism.common.ItemMekanism;
import mekanism.common.Mekanism;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemStorageTank
extends ItemMekanism
implements IStorageTank {
    public int MAX_GAS;
    public int TRANSFER_RATE;

    public ItemStorageTank(int id, int maxGas, int transferRate) {
        super(id);
        this.MAX_GAS = maxGas;
        this.TRANSFER_RATE = transferRate;
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        int gas = this.getGas(this.getGasType(itemstack), itemstack);
        if (this.getGasType(itemstack) == EnumGas.NONE) {
            list.add("No gas stored.");
        } else {
            list.add("Stored " + this.getGasType((ItemStack)itemstack).name + ": " + gas);
        }
    }

    public void func_77622_d(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        itemstack = this.getEmptyItem();
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (this.getGasType(itemstack) != EnumGas.NONE && this.getGas(this.getGasType(itemstack), itemstack) == 0) {
            this.setGasType(itemstack, EnumGas.NONE);
        }
    }

    @Override
    public int getGas(EnumGas type, Object ... data) {
        ItemStack itemstack;
        if (data[0] instanceof ItemStack && (this.getGasType(itemstack = (ItemStack)data[0]) == type || type == EnumGas.NONE)) {
            if (itemstack.field_77990_d == null) {
                return 0;
            }
            int stored = 0;
            if (itemstack.field_77990_d.func_74781_a("gas") != null) {
                stored = itemstack.field_77990_d.func_74762_e("gas");
            }
            itemstack.func_77964_b((int)Math.abs((float)stored / (float)this.MAX_GAS * 100.0f - 100.0f));
            return stored;
        }
        return 0;
    }

    @Override
    public void setGas(EnumGas type, int amount, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemstack = (ItemStack)data[0];
            if (itemstack.field_77990_d == null) {
                itemstack.func_77982_d(new NBTTagCompound());
            }
            if (this.getGasType(itemstack) == EnumGas.NONE) {
                this.setGasType(itemstack, type);
            }
            if (this.getGasType(itemstack) == type) {
                int stored = Math.max(Math.min(amount, this.MAX_GAS), 0);
                itemstack.field_77990_d.func_74768_a("gas", stored);
                itemstack.func_77964_b((int)Math.abs((float)stored / (float)this.MAX_GAS * 100.0f - 100.0f));
            }
            if (this.getGas(this.getGasType(itemstack), itemstack) == 0) {
                this.setGasType(itemstack, EnumGas.NONE);
            }
        }
    }

    public ItemStack getEmptyItem() {
        ItemStack empty = new ItemStack((Item)this);
        this.setGasType(empty, EnumGas.NONE);
        empty.func_77964_b(100);
        return empty;
    }

    public void func_77633_a(int i, CreativeTabs tabs, List list) {
        ItemStack empty = new ItemStack((Item)this);
        this.setGasType(empty, EnumGas.NONE);
        empty.func_77964_b(100);
        list.add(empty);
        for (EnumGas type : EnumGas.values()) {
            if (type == EnumGas.NONE) continue;
            ItemStack filled = new ItemStack((Item)this);
            this.setGasType(filled, type);
            this.setGas(type, ((IStorageTank)filled.func_77973_b()).getMaxGas(type, filled), filled);
            list.add(filled);
        }
    }

    @Override
    public int getMaxGas(EnumGas type, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            IStorageTank tank = (IStorageTank)itemStack.func_77973_b();
            if (this.getGasType(itemStack) == EnumGas.NONE || this.getGasType(itemStack) == type || type == EnumGas.NONE) {
                return this.MAX_GAS;
            }
        }
        return 0;
    }

    @Override
    public int getRate() {
        return this.TRANSFER_RATE;
    }

    @Override
    public int addGas(ItemStack itemstack, EnumGas type, int amount) {
        if (this.getGasType(itemstack) == type || this.getGasType(itemstack) == EnumGas.NONE) {
            int rejects = Math.max(this.getGas(this.getGasType(itemstack), itemstack) + amount - this.MAX_GAS, 0);
            this.setGas(type, this.getGas(type, itemstack) + amount - rejects, itemstack);
            return rejects;
        }
        return amount;
    }

    @Override
    public int removeGas(ItemStack itemstack, EnumGas type, int amount) {
        if (this.getGasType(itemstack) == type) {
            int gasToUse = Math.min(this.getGas(type, itemstack), amount);
            this.setGas(type, this.getGas(type, itemstack) - gasToUse, itemstack);
            return gasToUse;
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, EnumGas type) {
        return this.getGasType(itemstack) == type || this.getGasType(itemstack) == EnumGas.NONE;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, EnumGas type) {
        return this.getGasType(itemstack) == type;
    }

    @Override
    public EnumGas getGasType(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return EnumGas.NONE;
        }
        if (itemstack.field_77990_d.func_74779_i("type") == null) {
            return EnumGas.NONE;
        }
        return EnumGas.getFromName(itemstack.field_77990_d.func_74779_i("gasType"));
    }

    @Override
    public void setGasType(ItemStack itemstack, EnumGas type) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.field_77990_d.func_74778_a("gasType", type.name);
    }
}

