/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import mekanism.common.Mekanism;
import mekanism.common.TileEntityElectricBlock;
import net.minecraftforge.common.ForgeDirection;

public class LinkedPowerProvider
extends PowerProvider {
    public TileEntityElectricBlock tileEntity;

    public LinkedPowerProvider(TileEntityElectricBlock tile) {
        this.tileEntity = tile;
    }

    @Override
    public boolean update(IPowerReceptor receptor) {
        return true;
    }

    @Override
    public float useEnergy(float min, float max, boolean doUse) {
        float result = 0.0f;
        if (this.tileEntity.electricityStored * Mekanism.TO_BC >= (double)min) {
            if (this.tileEntity.electricityStored * Mekanism.TO_BC <= (double)max) {
                result = (float)(this.tileEntity.electricityStored * Mekanism.TO_BC);
                if (doUse) {
                    this.tileEntity.electricityStored = 0.0;
                }
            } else {
                result = max;
                if (doUse) {
                    this.tileEntity.electricityStored -= (double)max * Mekanism.FROM_BC;
                }
            }
        }
        return result;
    }

    @Override
    public void receiveEnergy(float quantity, ForgeDirection from) {
        this.tileEntity.setEnergy(this.tileEntity.electricityStored + (double)quantity * Mekanism.FROM_BC);
    }
}

