/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Object3D;
import mekanism.common.IMechanicalPipe;
import mekanism.common.PipeUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidNetwork {
    public Set pipes = new HashSet();
    public Set possibleAcceptors = new HashSet();
    public Map acceptorDirections = new HashMap();

    public LiquidNetwork(IMechanicalPipe ... varPipes) {
        this.pipes.addAll(Arrays.asList(varPipes));
    }

    public int emit(LiquidStack liquidToSend, boolean doTransfer, TileEntity emitter) {
        List<Object> availableAcceptors = Arrays.asList(this.getLiquidAcceptors(liquidToSend).toArray());
        Collections.shuffle(availableAcceptors);
        int liquidSent = 0;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = liquidToSend.amount % divider;
            int sending = (liquidToSend.amount - remaining) / divider;
            for (Object obj : availableAcceptors) {
                if (!(obj instanceof ITankContainer) || obj == emitter) continue;
                ITankContainer acceptor = (ITankContainer)obj;
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                liquidSent += acceptor.fill((ForgeDirection)this.acceptorDirections.get(acceptor), new LiquidStack(liquidToSend.itemID, currentSending, liquidToSend.itemMeta), doTransfer);
            }
        }
        if (doTransfer && liquidSent > 0 && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            LiquidStack sendStack = liquidToSend.copy();
            sendStack.amount = liquidSent;
            MinecraftForge.EVENT_BUS.post((Event)new LiquidTransferEvent(this, sendStack));
        }
        return liquidSent;
    }

    public Set getLiquidAcceptors(LiquidStack liquidToSend) {
        HashSet<ITankContainer> toReturn = new HashSet<ITankContainer>();
        for (ITankContainer acceptor : this.possibleAcceptors) {
            if (acceptor.fill(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite(), liquidToSend, false) <= 0) continue;
            toReturn.add(acceptor);
        }
        return toReturn;
    }

    public void refresh() {
        Iterator it = this.pipes.iterator();
        this.possibleAcceptors.clear();
        this.acceptorDirections.clear();
        while (it.hasNext()) {
            IMechanicalPipe conductor = (IMechanicalPipe)it.next();
            if (conductor == null) {
                it.remove();
                continue;
            }
            if (((TileEntity)conductor).func_70320_p()) {
                it.remove();
                continue;
            }
            conductor.setNetwork(this);
        }
        for (IMechanicalPipe pipe : this.pipes) {
            ITankContainer[] acceptors;
            for (ITankContainer acceptor : acceptors = PipeUtils.getConnectedAcceptors((TileEntity)pipe)) {
                if (acceptor == null || acceptor instanceof IMechanicalPipe) continue;
                this.possibleAcceptors.add(acceptor);
                this.acceptorDirections.put(acceptor, ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)));
            }
        }
    }

    public void merge(LiquidNetwork network) {
        if (network != null && network != this) {
            LiquidNetwork newNetwork = new LiquidNetwork(new IMechanicalPipe[0]);
            newNetwork.pipes.addAll(this.pipes);
            newNetwork.pipes.addAll(network.pipes);
            newNetwork.refresh();
        }
    }

    public void split(IMechanicalPipe splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.pipes.remove(splitPoint);
            TileEntity[] connectedBlocks = new TileEntity[6];
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity sideTile = Object3D.get((TileEntity)splitPoint).getFromSide(direction).getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                if (sideTile == null) continue;
                connectedBlocks[Arrays.asList(ForgeDirection.values()).indexOf((Object)direction)] = sideTile;
            }
            for (int countOne = 0; countOne < connectedBlocks.length; ++countOne) {
                TileEntity connectedBlockA = connectedBlocks[countOne];
                if (!(connectedBlockA instanceof IMechanicalPipe)) continue;
                for (int countTwo = 0; countTwo < connectedBlocks.length; ++countTwo) {
                    TileEntity connectedBlockB = connectedBlocks[countTwo];
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof IMechanicalPipe)) continue;
                    NetworkFinder finder = new NetworkFinder(((TileEntity)splitPoint).field_70331_k, Object3D.get(connectedBlockB), Object3D.get((TileEntity)splitPoint));
                    if (finder.foundTarget(Object3D.get(connectedBlockA))) {
                        for (Object3D node : finder.iterated) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                            if (!(nodeTile instanceof IMechanicalPipe) || nodeTile == splitPoint) continue;
                            ((IMechanicalPipe)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    LiquidNetwork newNetwork = new LiquidNetwork(new IMechanicalPipe[0]);
                    for (Object3D node : finder.iterated) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                        if (!(nodeTile instanceof IMechanicalPipe) || nodeTile == splitPoint) continue;
                        newNetwork.pipes.add((IMechanicalPipe)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    public String toString() {
        return "[LiquidNetwork] " + this.pipes.size() + " pipes, " + this.possibleAcceptors.size() + " acceptors.";
    }

    public static class NetworkLoader {
        @ForgeSubscribe
        public void onChunkLoad(ChunkEvent.Load event) {
            if (event.getChunk() != null) {
                for (Object obj : event.getChunk().field_76648_i.values()) {
                    TileEntity tileEntity;
                    if (!(obj instanceof TileEntity) || !((tileEntity = (TileEntity)obj) instanceof IMechanicalPipe)) continue;
                    ((IMechanicalPipe)tileEntity).refreshNetwork();
                }
            }
        }
    }

    public static class LiquidTransferEvent
    extends Event {
        public final LiquidNetwork liquidNetwork;
        public final LiquidStack liquidSent;

        public LiquidTransferEvent(LiquidNetwork network, LiquidStack liquid) {
            this.liquidNetwork = network;
            this.liquidSent = liquid;
        }
    }

    public static class NetworkFinder {
        public World worldObj;
        public Object3D start;
        public List iterated = new ArrayList();
        public List toIgnore = new ArrayList();

        public NetworkFinder(World world, Object3D target, Object3D ... ignore) {
            this.worldObj = world;
            this.start = target;
            if (ignore != null) {
                this.toIgnore = Arrays.asList(ignore);
            }
        }

        public void loopThrough(Object3D location) {
            this.iterated.add(location);
            if (this.iterated.contains(this.start)) {
                return;
            }
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity;
                Object3D obj = location.getFromSide(direction);
                if (this.iterated.contains(obj) || this.toIgnore.contains(obj) || !((tileEntity = obj.getTileEntity((IBlockAccess)this.worldObj)) instanceof IMechanicalPipe)) continue;
                this.loopThrough(obj);
            }
        }

        public boolean foundTarget(Object3D start) {
            this.loopThrough(start);
            return this.iterated.contains(start);
        }
    }
}

