/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.Loader;
import ic2.api.recipe.Recipes;
import java.util.Map;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.RecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thermalexpansion.api.crafting.CraftingManagers;
import thermalexpansion.api.crafting.IPulverizerRecipe;
import universalelectricity.prefab.RecipeHelper;

public final class MekanismHooks {
    private Class BasicComponents;
    private Class BuildCraftEnergy;
    private Class ForestryItem;
    public int ForestryBiofuelID = 5013;
    public ItemStack ForestryBiofuelBucket;
    public boolean IC2Loaded = false;
    public boolean RailcraftLoaded = false;
    public boolean BasicComponentsLoaded = false;
    public boolean BuildCraftLoaded = false;
    public boolean ForestryLoaded = false;
    public boolean TELoaded = false;
    public boolean MetallurgyCoreLoaded = false;
    public boolean MetallurgyBaseLoaded = false;

    public void hook() {
        if (Loader.isModLoaded((String)"IC2")) {
            this.IC2Loaded = true;
        }
        if (Loader.isModLoaded((String)"Railcraft")) {
            this.RailcraftLoaded = true;
        }
        if (Loader.isModLoaded((String)"BasicComponents")) {
            this.BasicComponentsLoaded = true;
        }
        if (Loader.isModLoaded((String)"BuildCraft|Energy")) {
            this.BuildCraftLoaded = true;
        }
        if (Loader.isModLoaded((String)"Forestry")) {
            this.ForestryLoaded = true;
        }
        if (Loader.isModLoaded((String)"ThermalExpansion")) {
            this.TELoaded = true;
        }
        if (Loader.isModLoaded((String)"Metallurgy3Core")) {
            this.MetallurgyCoreLoaded = true;
            if (Loader.isModLoaded((String)"Metallurgy3Base")) {
                this.MetallurgyBaseLoaded = true;
            }
        }
        if (this.IC2Loaded) {
            Recipes.macerator.addRecipe(new ItemStack(Mekanism.OreBlock, 1, 0), new ItemStack(Mekanism.Dust, 2, 2));
            Recipes.macerator.addRecipe(new ItemStack(Mekanism.Ingot, 1, 1), new ItemStack(Mekanism.Dust, 1, 2));
            Recipes.macerator.addRecipe(new ItemStack(Mekanism.Ingot, 1, 0), new ItemStack(Mekanism.Dust, 1, 3));
            Recipes.macerator.addRecipe(new ItemStack(Mekanism.Ingot, 1, 3), new ItemStack(Item.field_77751_aT));
            Recipes.macerator.addRecipe(new ItemStack(Mekanism.Ingot, 1, 4), new ItemStack(Mekanism.Dust, 1, 5));
            Recipes.macerator.addRecipe(new ItemStack(Mekanism.Clump, 1, 0), new ItemStack(Mekanism.DirtyDust, 1, 0));
            Recipes.macerator.addRecipe(new ItemStack(Mekanism.Clump, 1, 1), new ItemStack(Mekanism.DirtyDust, 1, 1));
            Recipes.macerator.addRecipe(new ItemStack(Mekanism.Clump, 1, 2), new ItemStack(Mekanism.DirtyDust, 1, 2));
            Recipes.macerator.addRecipe(new ItemStack(Mekanism.Clump, 1, 3), new ItemStack(Mekanism.DirtyDust, 1, 3));
            Recipes.macerator.addRecipe(new ItemStack(Mekanism.Clump, 1, 4), new ItemStack(Mekanism.DirtyDust, 1, 4));
            Recipes.macerator.addRecipe(new ItemStack(Mekanism.Clump, 1, 5), new ItemStack(Mekanism.DirtyDust, 1, 5));
            for (Map.Entry entry : Recipes.macerator.getRecipes().entrySet()) {
                if (MekanismUtils.getName((ItemStack)entry.getKey()).startsWith("ore")) {
                    if (RecipeHandler.Recipe.ENRICHMENT_CHAMBER.containsRecipe((ItemStack)entry.getKey())) continue;
                    RecipeHandler.addEnrichmentChamberRecipe((ItemStack)entry.getKey(), (ItemStack)entry.getValue());
                    continue;
                }
                if (!MekanismUtils.getName((ItemStack)entry.getKey()).startsWith("ingot") || RecipeHandler.Recipe.CRUSHER.containsRecipe((ItemStack)entry.getKey())) continue;
                RecipeHandler.addCrusherRecipe((ItemStack)entry.getKey(), (ItemStack)entry.getValue());
            }
            Recipes.matterAmplifier.addRecipe(new ItemStack(Mekanism.EnrichedAlloy), 50000);
            System.out.println("[Mekanism] Hooked into IC2 successfully.");
        }
        if (this.BasicComponentsLoaded) {
            if (Mekanism.disableBCSteelCrafting) {
                RecipeHelper.removeRecipes(this.getBasicComponentsItem("itemSteelDust"));
                RecipeHelper.removeRecipes(this.getBasicComponentsItem("itemSteelIngot"));
            }
            if (Mekanism.disableBCBronzeCrafting) {
                RecipeHelper.removeRecipes(this.getBasicComponentsItem("itemBronzeDust"));
                RecipeHelper.removeRecipes(this.getBasicComponentsItem("itemBronzeIngot"));
            }
            System.out.println("[Mekanism] Hooked into BasicComponents successfully.");
        }
        if (this.BuildCraftLoaded) {
            System.out.println("[Mekanism] Hooked into BuildCraft successfully.");
        }
        if (this.ForestryLoaded) {
            this.ForestryBiofuelID = this.getForestryItem((String)"liquidBiofuel").field_77993_c;
            this.ForestryBiofuelBucket = this.getForestryItem("bucketBiofuel");
            System.out.println("[Mekanism] Hooked into Forestry successfully.");
        }
        if (this.TELoaded) {
            for (IPulverizerRecipe recipe : CraftingManagers.pulverizerManager.getRecipeList()) {
                if (recipe.getSecondaryOutput() != null) continue;
                if (MekanismUtils.getName(recipe.getInput()).startsWith("ore")) {
                    if (RecipeHandler.Recipe.ENRICHMENT_CHAMBER.containsRecipe(recipe.getInput())) continue;
                    RecipeHandler.addEnrichmentChamberRecipe(recipe.getInput(), recipe.getPrimaryOutput());
                    continue;
                }
                if (!MekanismUtils.getName(recipe.getInput()).startsWith("ingot") || RecipeHandler.Recipe.CRUSHER.containsRecipe(recipe.getInput())) continue;
                RecipeHandler.addCrusherRecipe(recipe.getInput(), recipe.getPrimaryOutput());
            }
        }
    }

    public ItemStack getBuildCraftItem(String name) {
        try {
            Object ret;
            if (this.BuildCraftEnergy == null) {
                this.BuildCraftEnergy = Class.forName("buildcraft.BuildCraftEnergy");
            }
            if (this.BuildCraftEnergy == null) {
                this.BuildCraftEnergy = Class.forName("net.minecraft.src.buildcraft.BuildCraftEnergy");
            }
            if ((ret = this.BuildCraftEnergy.getField(name).get(null)) instanceof Item) {
                return new ItemStack((Item)ret);
            }
            if (ret instanceof Block) {
                return new ItemStack((Block)ret);
            }
            throw new Exception("not instanceof ItemStack");
        }
        catch (Exception e) {
            System.out.println("[Mekanism] Unable to retrieve BuildCraft item " + name + ".");
            return null;
        }
    }

    public ItemStack getForestryItem(String name) {
        try {
            Object ret;
            if (this.ForestryItem == null) {
                this.ForestryItem = Class.forName("forestry.core.config.ForestryItem");
            }
            if (this.ForestryItem == null) {
                this.ForestryItem = Class.forName("net.minecraft.src.forestry.core.config.ForestryItem");
            }
            if ((ret = this.ForestryItem.getField(name).get(null)) instanceof Item) {
                return new ItemStack((Item)ret);
            }
            if (ret instanceof Block) {
                return new ItemStack((Block)ret);
            }
            throw new Exception("not instanceof ItemStack");
        }
        catch (Exception e) {
            System.out.println("[Mekanism] Unable to retrieve Forestry item " + name + ".");
            return null;
        }
    }

    public ItemStack getBasicComponentsItem(String name) {
        try {
            Object ret;
            if (this.BasicComponents == null) {
                this.BasicComponents = Class.forName("basiccomponents.common.BasicComponents");
            }
            if (this.BasicComponents == null) {
                this.BasicComponents = Class.forName("net.minecraft.src.basiccomponents.common.BasicComponents");
            }
            if ((ret = this.BasicComponents.getField(name).get(null)) instanceof Item) {
                return new ItemStack((Item)ret);
            }
            if (ret instanceof Block) {
                return new ItemStack((Block)ret);
            }
            throw new Exception("not instanceof ItemStack");
        }
        catch (Exception e) {
            System.out.println("[Mekanism] Unable to retrieve Basic Components item " + name + ".");
            return null;
        }
    }
}

