/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.server.FMLServerHandler;
import ic2.api.Direction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.Object3D;
import mekanism.common.ContainerElectricChest;
import mekanism.common.DynamicTankCache;
import mekanism.common.IActiveState;
import mekanism.common.IFactory;
import mekanism.common.IModule;
import mekanism.common.ItemBlockEnergyCube;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.Teleporter;
import mekanism.common.Tier;
import mekanism.common.TileEntityBoundingBlock;
import mekanism.common.TileEntityDynamicTank;
import mekanism.common.TileEntityElectricChest;
import mekanism.common.Version;
import mekanism.common.network.PacketElectricChest;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet3Chat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquid;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public final class MekanismUtils {
    public static boolean checkForUpdates(EntityPlayer entityplayer) {
        if (Mekanism.updateNotifications && Mekanism.latestVersionNumber != null && Mekanism.recentNews != null) {
            if (!Mekanism.latestVersionNumber.equals("null")) {
                ArrayList<IModule> list = new ArrayList<IModule>();
                for (IModule module : Mekanism.modulesLoaded) {
                    if (Version.get(Mekanism.latestVersionNumber).comparedState(module.getVersion()) != 1) continue;
                    list.add(module);
                }
                if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == 1 || !list.isEmpty()) {
                    entityplayer.func_71035_c((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " -------------");
                    entityplayer.func_71035_c((Object)((Object)EnumColor.GREY) + " Using outdated version on one or more modules.");
                    if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == 1) {
                        entityplayer.func_71035_c((Object)((Object)EnumColor.INDIGO) + " Mekanism: " + (Object)((Object)EnumColor.DARK_RED) + Mekanism.versionNumber);
                    }
                    for (IModule module : list) {
                        entityplayer.func_71035_c((Object)((Object)EnumColor.INDIGO) + " Mekanism" + module.getName() + ": " + (Object)((Object)EnumColor.DARK_RED) + module.getVersion());
                    }
                    entityplayer.func_71035_c((Object)((Object)EnumColor.GREY) + " Consider updating to version " + (Object)((Object)EnumColor.DARK_GREY) + Mekanism.latestVersionNumber);
                    entityplayer.func_71035_c((Object)((Object)EnumColor.GREY) + " New features: " + (Object)((Object)EnumColor.INDIGO) + Mekanism.recentNews);
                    entityplayer.func_71035_c((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------");
                    return true;
                }
                if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == -1) {
                    entityplayer.func_71035_c((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + "Using developer build " + (Object)((Object)EnumColor.DARK_GREY) + Mekanism.versionNumber);
                    return true;
                }
            } else {
                System.out.println("[Mekanism] Minecraft is in offline mode, could not check for updates.");
            }
        }
        return false;
    }

    public static String getLatestVersion() {
        String[] text = MekanismUtils.getHTML("http://dl.dropbox.com/u/90411166/Mod%20Versions/Mekanism.txt").split(":");
        if (!(text[0].contains("UTF-8") || text[0].contains("HTML") || text[0].contains("http"))) {
            return text[0];
        }
        return "null";
    }

    public static String getRecentNews() {
        String[] text = MekanismUtils.getHTML("http://dl.dropbox.com/u/90411166/Mod%20Versions/Mekanism.txt").split(":");
        if (!(text.length <= 1 || text[1].contains("UTF-8") || text[1].contains("HTML") || text[1].contains("http"))) {
            return text[1];
        }
        return "null";
    }

    public static String getHTML(String urlToRead) {
        StringBuilder sb = new StringBuilder();
        String result = "";
        try {
            String line;
            URL url = new URL(urlToRead);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result = result + line;
                sb.append(line);
            }
            rd.close();
        }
        catch (Exception e) {
            result = "null";
            System.err.println("[Mekanism] An error occured while connecting to URL '" + urlToRead + ".'");
        }
        return result;
    }

    public static void sendChatMessageToPlayer(String playerUsername, String msg) {
        EntityPlayerMP player = FMLServerHandler.instance().getServer().func_71203_ab().func_72361_f(playerUsername);
        Packet3Chat chatPacket = new Packet3Chat(msg);
        if (player != null) {
            player.field_71135_a.func_72567_b((Packet)chatPacket);
        }
    }

    public static Object3D getClosestCoords(Teleporter.Code teleCode, EntityPlayer player) {
        if (((ArrayList)Mekanism.teleporters.get(teleCode)).size() == 1) {
            return (Object3D)((ArrayList)Mekanism.teleporters.get(teleCode)).get(0);
        }
        int dimensionId = player.field_70170_p.field_73011_w.field_76574_g;
        Object3D coords0 = (Object3D)((ArrayList)Mekanism.teleporters.get(teleCode)).get(0);
        Object3D coords1 = (Object3D)((ArrayList)Mekanism.teleporters.get(teleCode)).get(1);
        int distance0 = (int)player.func_70011_f((double)coords0.xCoord, (double)coords0.yCoord, (double)coords0.zCoord);
        int distance1 = (int)player.func_70011_f((double)coords1.xCoord, (double)coords1.yCoord, (double)coords1.zCoord);
        if (dimensionId == coords0.dimensionId && dimensionId != coords1.dimensionId) {
            return coords0;
        }
        if (dimensionId == coords1.dimensionId && dimensionId != coords0.dimensionId) {
            return coords1;
        }
        if (dimensionId == coords0.dimensionId && dimensionId == coords1.dimensionId) {
            if (distance0 < distance1) {
                return coords0;
            }
            if (distance0 > distance1) {
                return coords1;
            }
        } else if (dimensionId != coords0.dimensionId && dimensionId != coords1.dimensionId) {
            if (distance0 < distance1) {
                return coords0;
            }
            if (distance0 > distance1) {
                return coords1;
            }
        }
        return null;
    }

    public static void sendChatMessageToAllPlayers(String msg) {
        PacketDispatcher.sendPacketToAllPlayers((Packet)new Packet3Chat(msg));
    }

    public static boolean noUpdates() {
        if (Mekanism.latestVersionNumber.contains("null")) {
            return true;
        }
        if (Mekanism.versionNumber.comparedState(Version.get(Mekanism.latestVersionNumber)) == -1) {
            return false;
        }
        for (IModule module : Mekanism.modulesLoaded) {
            if (module.getVersion().comparedState(Version.get(Mekanism.latestVersionNumber)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isOffline() {
        try {
            new URL("http://www.apple.com").openConnection().connect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void setHourForward(World world, int paramInt) {
        long l1 = world.func_72820_D() / 24000L * 24000L;
        long l2 = l1 + 24000L + (long)(paramInt * 1000);
        world.func_72877_b(l2);
    }

    public static void doFakeEntityExplosion(EntityPlayer entityplayer) {
        World world = entityplayer.field_70170_p;
        world.func_72869_a("hugeexplosion", entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, 0.0, 0.0, 0.0);
        world.func_72956_a((Entity)entityplayer, "random.explode", 1.0f, 1.0f);
    }

    public static void doFakeBlockExplosion(World world, int x, int y, int z) {
        world.func_72869_a("hugeexplosion", (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        world.func_72980_b((double)x, (double)y, (double)z, "random.explode", 1.0f, 1.0f, true);
    }

    public static ItemStack size(ItemStack itemstack, int size) {
        ItemStack newStack = itemstack.func_77946_l();
        newStack.field_77994_a = size;
        return newStack;
    }

    public static void addRecipe(ItemStack output, Object[] params) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(output, params));
    }

    public static ItemStack getEnergyCube(Tier.EnergyCubeTier tier) {
        ItemStack itemstack = ((ItemBlockEnergyCube)new ItemStack(Mekanism.EnergyCube).func_77973_b()).getUnchargedItem(tier);
        return itemstack;
    }

    public static ItemStack getFactory(Tier.FactoryTier tier, IFactory.RecipeType type) {
        ItemStack itemstack = new ItemStack(Mekanism.MachineBlock, 1, 5 + tier.ordinal());
        ((IFactory)itemstack.func_77973_b()).setRecipeType(type.ordinal(), itemstack);
        return itemstack;
    }

    public static boolean isActive(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity != null && tileEntity instanceof IActiveState) {
            return ((IActiveState)tileEntity).getActive();
        }
        return false;
    }

    public static ForgeDirection getLeft(int orientation) {
        switch (orientation) {
            case 2: {
                return ForgeDirection.EAST;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
            case 4: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.NORTH;
    }

    public static ForgeDirection getRight(int orientation) {
        return MekanismUtils.getLeft(orientation).getOpposite();
    }

    public static boolean oreDictCheck(ItemStack check, String oreDict) {
        boolean hasResource = false;
        for (ItemStack ore : OreDictionary.getOres((String)oreDict)) {
            if (!ore.func_77969_a(check)) continue;
            hasResource = true;
        }
        return hasResource;
    }

    public static int getBaseOrientation(int side, int blockFacing) {
        if (blockFacing == 3 || side == 1 || side == 0) {
            if (side == 2 || side == 3) {
                return ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
            }
            return side;
        }
        if (blockFacing == 2) {
            if (side == 2 || side == 3) {
                return side;
            }
            return ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
        }
        if (blockFacing == 4) {
            return MekanismUtils.getRight(side).ordinal();
        }
        if (blockFacing == 5) {
            return MekanismUtils.getLeft(side).ordinal();
        }
        return side;
    }

    public static void incrementOutput(IConfigurable config, int side) {
        int max = config.getSideData().size() - 1;
        int current = config.getSideData().indexOf(config.getSideData().get(config.getConfiguration()[side]));
        if (current < max) {
            config.getConfiguration()[side] = (byte)(current + 1);
        } else if (current == max) {
            config.getConfiguration()[side] = 0;
        }
    }

    public static int getTicks(int speedUpgrade, int def) {
        return (int)((double)def * Math.pow(10.0, (double)(-speedUpgrade) / 9.0));
    }

    public static int getEnergyPerTick(int speedUpgrade, int energyUpgrade, int def) {
        return (int)((double)def * Math.pow(10.0, (double)(speedUpgrade - energyUpgrade) / 9.0));
    }

    public static double getEnergyPerTick(int speedUpgrade, int energyUpgrade, double def) {
        return def * Math.pow(10.0, (double)(speedUpgrade - energyUpgrade) / 9.0);
    }

    public static double getEnergy(int energyUpgrade, double def) {
        return (int)(def * Math.pow(10.0, (double)energyUpgrade / 9.0));
    }

    public static void makeBoundingBlock(World world, int x, int y, int z, Object3D orig) {
        world.func_94575_c(x, y, z, Mekanism.BoundingBlock.field_71990_ca);
        if (!world.field_72995_K) {
            ((TileEntityBoundingBlock)world.func_72796_p(x, y, z)).setMainLocation(orig.xCoord, orig.yCoord, orig.zCoord);
        }
    }

    public static void updateBlock(World world, int x, int y, int z) {
        if (world.func_72796_p(x, y, z) instanceof IActiveState && !((IActiveState)world.func_72796_p(x, y, z)).hasVisual()) {
            return;
        }
        world.func_72902_n(x, y, z);
        world.func_72969_x(x, y, z);
    }

    public static Direction toIC2Direction(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return Direction.YN;
            }
            case UP: {
                return Direction.YP;
            }
            case NORTH: {
                return Direction.ZN;
            }
            case SOUTH: {
                return Direction.ZP;
            }
            case WEST: {
                return Direction.XN;
            }
        }
        return Direction.XP;
    }

    public static boolean isLiquid(World world, int x, int y, int z) {
        return MekanismUtils.getLiquid(world, x, y, z) != null;
    }

    public static LiquidStack getLiquid(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == 0) {
            return null;
        }
        if ((id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca) && meta == 0) {
            return new LiquidStack(Block.field_71943_B.field_71990_ca, 1000, 0);
        }
        if ((id == Block.field_71938_D.field_71990_ca || id == Block.field_71944_C.field_71990_ca) && meta == 0) {
            return new LiquidStack(Block.field_71938_D.field_71990_ca, 1000, 0);
        }
        if (Block.field_71973_m[id] instanceof ILiquid) {
            ILiquid liquid = (ILiquid)Block.field_71973_m[id];
            if (liquid.isMetaSensitive()) {
                return new LiquidStack(liquid.stillLiquidId(), 1000, liquid.stillLiquidMeta());
            }
            if (meta == 0) {
                return new LiquidStack(liquid.stillLiquidId(), 1000, 0);
            }
        }
        return null;
    }

    public static int getLiquidId(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == 0) {
            return 0;
        }
        if (id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca) {
            return Block.field_71943_B.field_71990_ca;
        }
        if (id == Block.field_71938_D.field_71990_ca || id == Block.field_71944_C.field_71990_ca) {
            return Block.field_71938_D.field_71990_ca;
        }
        if (Block.field_71973_m[id] instanceof ILiquid) {
            ILiquid liquid = (ILiquid)Block.field_71973_m[id];
            return liquid.stillLiquidId();
        }
        return 0;
    }

    public static boolean isDeadLiquid(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == 0) {
            return false;
        }
        if ((id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca) && meta != 0) {
            return true;
        }
        if ((id == Block.field_71938_D.field_71990_ca || id == Block.field_71944_C.field_71990_ca) && meta != 0) {
            return true;
        }
        if (Block.field_71973_m[id] instanceof ILiquid) {
            ILiquid liquid = (ILiquid)Block.field_71973_m[id];
            if (liquid.isMetaSensitive()) {
                return liquid.stillLiquidMeta() != meta || liquid.stillLiquidId() != id;
            }
            if (meta != 0) {
                return true;
            }
        }
        return false;
    }

    public static void openElectricChestGui(EntityPlayerMP player, TileEntityElectricChest tileEntity, IInventory inventory, boolean isBlock) {
        player.func_71117_bO();
        player.func_71128_l();
        int id = player.field_71139_cq;
        if (isBlock) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 0, id, true, Object3D.get(tileEntity)}), player);
        } else {
            PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 0, id, false}), player);
        }
        player.field_71070_bA = new ContainerElectricChest(player.field_71071_by, tileEntity, inventory, isBlock);
        player.field_71070_bA.field_75152_c = id;
        player.field_71070_bA.func_75132_a((ICrafting)player);
    }

    public static DynamicTankCache pullInventory(World world, int id) {
        DynamicTankCache toReturn = (DynamicTankCache)Mekanism.dynamicInventories.get(id);
        for (Object3D obj : ((DynamicTankCache)Mekanism.dynamicInventories.get((Object)Integer.valueOf((int)id))).locations) {
            TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)obj.getTileEntity((IBlockAccess)world);
            if (tileEntity == null) continue;
            tileEntity.cachedLiquid = null;
            tileEntity.inventory = new ItemStack[2];
            tileEntity.inventoryID = -1;
        }
        Mekanism.dynamicInventories.remove(id);
        return toReturn;
    }

    public static void updateCache(int inventoryID, LiquidStack liquid, ItemStack[] inventory, TileEntityDynamicTank tileEntity) {
        if (!Mekanism.dynamicInventories.containsKey(inventoryID)) {
            DynamicTankCache cache = new DynamicTankCache();
            cache.inventory = inventory;
            cache.liquid = liquid;
            cache.locations.add(Object3D.get(tileEntity));
            Mekanism.dynamicInventories.put(inventoryID, cache);
            return;
        }
        ((DynamicTankCache)Mekanism.dynamicInventories.get((Object)Integer.valueOf((int)inventoryID))).inventory = inventory;
        ((DynamicTankCache)Mekanism.dynamicInventories.get((Object)Integer.valueOf((int)inventoryID))).liquid = liquid;
        ((DynamicTankCache)Mekanism.dynamicInventories.get((Object)Integer.valueOf((int)inventoryID))).locations.add(Object3D.get(tileEntity));
    }

    public static int getUniqueInventoryID() {
        int id = 0;
        for (Integer i : Mekanism.dynamicInventories.keySet()) {
            if (id != i) continue;
            ++id;
        }
        return id;
    }

    public static String getName(ItemStack itemStack) {
        return OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack));
    }
}

