/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.Arrays;
import mekanism.api.Object3D;
import mekanism.common.IMechanicalPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public final class PipeUtils {
    public static TileEntity[] getConnectedPipes(TileEntity tileEntity) {
        TileEntity[] pipes = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity pipe = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!(pipe instanceof IMechanicalPipe)) continue;
            pipes[orientation.ordinal()] = pipe;
        }
        return pipes;
    }

    public static boolean[] getConnections(TileEntity tileEntity) {
        int side;
        ITankContainer[] connectedAcceptors;
        boolean[] connectable = new boolean[]{false, false, false, false, false, false};
        TileEntity[] connectedPipes = PipeUtils.getConnectedPipes(tileEntity);
        for (ITankContainer iTankContainer : connectedAcceptors = PipeUtils.getConnectedAcceptors(tileEntity)) {
            if (iTankContainer == null) continue;
            side = Arrays.asList(connectedAcceptors).indexOf(iTankContainer);
            if (iTankContainer.getTanks(ForgeDirection.getOrientation((int)side).getOpposite()) != null && iTankContainer.getTanks(ForgeDirection.getOrientation((int)side).getOpposite()).length != 0) {
                connectable[side] = true;
                continue;
            }
            if (iTankContainer.getTank(ForgeDirection.getOrientation((int)side).getOpposite(), new LiquidStack(-1, 1000)) == null) continue;
            connectable[side] = true;
        }
        for (ITankContainer iTankContainer : connectedPipes) {
            if (iTankContainer == null) continue;
            side = Arrays.asList(connectedPipes).indexOf(iTankContainer);
            connectable[side] = true;
        }
        return connectable;
    }

    public static ITankContainer[] getConnectedAcceptors(TileEntity tileEntity) {
        ITankContainer[] acceptors = new ITankContainer[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity acceptor = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!(acceptor instanceof ITankContainer) || acceptor instanceof IMechanicalPipe) continue;
            acceptors[orientation.ordinal()] = (ITankContainer)acceptor;
        }
        return acceptors;
    }
}

