/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import mekanism.api.IConfigurable;
import mekanism.api.IStrictEnergyAcceptor;
import mekanism.api.IUpgradeManagement;
import mekanism.api.Object3D;
import mekanism.api.SideData;
import mekanism.client.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IElectricMachine;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.TileEntityElectricBlock;
import mekanism.common.network.PacketTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileEntityBasicMachine
extends TileEntityElectricBlock
implements IElectricMachine,
IEnergySink,
IPeripheral,
IActiveState,
IConfigurable,
IUpgradeManagement,
IHasSound,
IStrictEnergyAcceptor {
    public byte[] sideConfig;
    public ArrayList sideOutputs = new ArrayList();
    public String soundURL;
    public double ENERGY_PER_TICK;
    public int operatingTicks = 0;
    public int TICKS_REQUIRED;
    public int speedMultiplier;
    public int energyMultiplier;
    public int UPGRADE_TICKS_REQUIRED = 40;
    public int upgradeTicks;
    public boolean isActive;
    public boolean prevActive;
    public String guiTexturePath;

    public TileEntityBasicMachine(String soundPath, String name, String path, double perTick, int ticksRequired, double maxEnergy) {
        super(name, maxEnergy);
        this.ENERGY_PER_TICK = perTick;
        this.TICKS_REQUIRED = ticksRequired;
        this.soundURL = soundPath;
        this.guiTexturePath = path;
        this.isActive = false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.registerSound(this);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.isActive = nbtTags.func_74767_n("isActive");
        this.speedMultiplier = nbtTags.func_74762_e("speedMultiplier");
        this.energyMultiplier = nbtTags.func_74762_e("energyMultiplier");
        this.upgradeTicks = nbtTags.func_74762_e("upgradeTicks");
        if (nbtTags.func_74764_b("sideDataStored")) {
            for (int i = 0; i < 6; ++i) {
                this.sideConfig[i] = nbtTags.func_74771_c("config" + i);
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("speedMultiplier", this.speedMultiplier);
        nbtTags.func_74768_a("energyMultiplier", this.energyMultiplier);
        nbtTags.func_74768_a("upgradeTicks", this.upgradeTicks);
        nbtTags.func_74757_a("sideDataStored", true);
        for (int i = 0; i < 6; ++i) {
            nbtTags.func_74774_a("config" + i, this.sideConfig[i]);
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.operatingTicks = dataStream.readInt();
        this.isActive = dataStream.readBoolean();
        this.speedMultiplier = dataStream.readInt();
        this.energyMultiplier = dataStream.readInt();
        this.upgradeTicks = dataStream.readInt();
        for (int i = 0; i < 6; ++i) {
            this.sideConfig[i] = dataStream.readByte();
        }
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.operatingTicks);
        data.add(this.isActive);
        data.add(this.speedMultiplier);
        data.add(this.energyMultiplier);
        data.add(this.upgradeTicks);
        data.add(this.sideConfig);
        return data;
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.unregisterSound(this);
        }
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public int demandsEnergy() {
        return (int)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenEnergy = (double)i * Mekanism.FROM_IC2;
        double rejects = 0.0;
        double neededEnergy = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
        if (givenEnergy <= neededEnergy) {
            this.electricityStored += givenEnergy;
        } else if (givenEnergy > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = givenEnergy - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotStart;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotAmount;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY));
    }

    public int getScaledProgress(int i) {
        return this.operatingTicks * i / MekanismUtils.getTicks(this.speedMultiplier, this.TICKS_REQUIRED);
    }

    public int getScaledUpgradeProgress(int i) {
        return this.upgradeTicks * i / this.UPGRADE_TICKS_REQUIRED;
    }

    @Override
    public double getMaxEnergy() {
        return MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY);
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.prevActive != active) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
        }
        this.prevActive = active;
    }

    @Override
    public double transferEnergyToAcceptor(double amount) {
        double rejects = 0.0;
        double neededElectricity = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
        if (amount <= neededElectricity) {
            this.electricityStored += amount;
        } else {
            this.electricityStored += neededElectricity;
            rejects = amount - neededElectricity;
        }
        return rejects;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return true;
    }

    @Override
    public String getType() {
        return this.func_70303_b();
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public int[] func_94128_d(int side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side, (int)this.facing)])).availableSlots;
    }

    @Override
    public int powerRequest(ForgeDirection side) {
        return (int)Math.min((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_BC, 100.0);
    }

    @Override
    public ArrayList getSideData() {
        return this.sideOutputs;
    }

    @Override
    public byte[] getConfiguration() {
        return this.sideConfig;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.energyMultiplier = multiplier;
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.speedMultiplier = multiplier;
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        return true;
    }

    @Override
    public String getSoundPath() {
        return this.soundURL;
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean hasVisual() {
        return true;
    }
}

