/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import mekanism.api.EnergizedItemManager;
import mekanism.api.IEnergizedItem;
import mekanism.api.IStrictEnergyAcceptor;
import mekanism.api.Object3D;
import mekanism.client.IHasSound;
import mekanism.common.EntityRobit;
import mekanism.common.IActiveState;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.TileEntityElectricBlock;
import mekanism.common.network.PacketTileEntity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.api.item.IChargeableItem;
import universalelectricity.core.item.ElectricItemHelper;
import universalelectricity.core.item.IItemElectric;

public class TileEntityChargepad
extends TileEntityElectricBlock
implements IActiveState,
IEnergySink,
IStrictEnergyAcceptor,
IHasSound {
    public boolean isActive;
    public boolean prevActive;
    public Random random = new Random();

    public TileEntityChargepad() {
        super("Chargepad", 9000.0);
        this.inventory = new ItemStack[0];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            this.isActive = false;
            List entities = this.field_70331_k.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)((double)this.field_70330_m + 0.2), (double)(this.field_70327_n + 1)));
            block0: for (EntityLiving entity : entities) {
                if (entity instanceof EntityPlayer || entity instanceof EntityRobit) {
                    this.isActive = true;
                }
                if (!(this.electricityStored > 0.0)) continue;
                if (entity instanceof EntityRobit) {
                    EntityRobit robit = (EntityRobit)entity;
                    double canGive = Math.min(this.electricityStored, 1000.0);
                    double toGive = Math.min(robit.MAX_ELECTRICITY - robit.getEnergy(), canGive);
                    robit.setEnergy(robit.getEnergy() + toGive);
                    this.setEnergy(this.electricityStored - toGive);
                    continue;
                }
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)entity;
                double prevEnergy = this.getEnergy();
                for (ItemStack itemstack : player.field_71071_by.field_70460_b) {
                    this.chargeItemStack(itemstack);
                    if (prevEnergy != this.getEnergy()) break;
                }
                for (ItemStack itemstack : player.field_71071_by.field_70462_a) {
                    this.chargeItemStack(itemstack);
                    if (prevEnergy != this.getEnergy()) continue block0;
                }
            }
            if (this.prevActive != this.isActive) {
                this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.1, (double)this.field_70327_n + 0.5, "random.click", 0.3f, this.isActive ? 0.6f : 0.5f);
                this.setActive(this.isActive);
            }
        } else {
            Mekanism.proxy.registerSound(this);
            if (this.isActive) {
                this.field_70331_k.func_72869_a("reddust", (double)this.field_70329_l + this.random.nextDouble(), (double)this.field_70330_m + 0.15, (double)this.field_70327_n + this.random.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void chargeItemStack(ItemStack itemstack) {
        if (itemstack != null) {
            if (itemstack.func_77973_b() instanceof IEnergizedItem) {
                this.setEnergy(this.getEnergy() - EnergizedItemManager.charge(itemstack, this.getEnergy()));
            } else if (itemstack.func_77973_b() instanceof IItemElectric) {
                this.setEnergy(this.getEnergy() - ElectricItemHelper.chargeItem(itemstack, this.getEnergy(), this.getVoltage()));
            } else if (Mekanism.hooks.IC2Loaded && itemstack.func_77973_b() instanceof IElectricItem) {
                double sent = (double)ElectricItem.manager.charge(itemstack, (int)(this.getEnergy() * Mekanism.TO_IC2), 3, false, false) * Mekanism.FROM_IC2;
                this.setEnergy(this.getEnergy() - sent);
            } else if (itemstack.func_77973_b() instanceof IChargeableItem) {
                IChargeableItem item = (IChargeableItem)itemstack.func_77973_b();
                float itemEnergy = (float)Math.min(Math.sqrt(item.getMaxEnergyStored(itemstack)), (double)(item.getMaxEnergyStored(itemstack) - item.getEnergyStored(itemstack)));
                float toTransfer = (float)Math.min((double)itemEnergy, this.getEnergy() * Mekanism.TO_BC);
                item.receiveEnergy(itemstack, toTransfer, true);
                this.setEnergy(this.getEnergy() - (double)toTransfer * Mekanism.FROM_BC);
            }
        }
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.unregisterSound(this);
        }
    }

    @Override
    protected EnumSet getConsumingSides() {
        return EnumSet.of(ForgeDirection.DOWN, ForgeDirection.getOrientation((int)this.facing));
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.prevActive != active) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
        }
        this.prevActive = active;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.isActive = dataStream.readBoolean();
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        return data;
    }

    @Override
    public double transferEnergyToAcceptor(double amount) {
        double rejects = 0.0;
        double neededElectricity = this.MAX_ELECTRICITY - this.electricityStored;
        if (amount <= neededElectricity) {
            this.electricityStored += amount;
        } else {
            this.electricityStored += neededElectricity;
            rejects = amount - neededElectricity;
        }
        return rejects;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return side == ForgeDirection.DOWN || side == ForgeDirection.getOrientation((int)this.facing).getOpposite();
    }

    @Override
    public int demandsEnergy() {
        return (int)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double rejects = 0.0;
        double neededEnergy = this.MAX_ELECTRICITY - this.electricityStored;
        if ((double)i <= neededEnergy) {
            this.electricityStored += (double)i;
        } else if ((double)i > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = (double)i - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return direction.toForgeDirection() == ForgeDirection.DOWN || direction.toForgeDirection() == ForgeDirection.getOrientation((int)this.facing).getOpposite();
    }

    @Override
    public String getSoundPath() {
        return "Chargepad.ogg";
    }

    @Override
    public float getVolumeMultiplier() {
        return 0.7f;
    }

    @Override
    public boolean hasVisual() {
        return true;
    }
}

