/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Object3D;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.SynchronizedTankData;
import mekanism.common.TankUpdateProtocol;
import mekanism.common.TileEntityContainerBlock;
import mekanism.common.network.PacketTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class TileEntityDynamicTank
extends TileEntityContainerBlock {
    public int inventoryID = -1;
    public SynchronizedTankData structure;
    public boolean sendStructure;
    public boolean prevStructure;
    public boolean clientHasStructure;
    public LiquidStack cachedLiquid;
    public Map valveViewing = new HashMap();
    public int clientCapacity;
    public boolean isRendering;

    public TileEntityDynamicTank() {
        this("Dynamic Tank");
    }

    public TileEntityDynamicTank(String name) {
        super(name);
        this.inventory = new ItemStack[2];
    }

    public void update() {
        if (!this.field_70331_k.field_72995_K && this.structure == null || !this.structure.didTick) {
            new TankUpdateProtocol(this).updateTanks();
            if (this.structure != null) {
                this.structure.didTick = true;
            }
        }
    }

    @Override
    public void onUpdate() {
        if (this.field_70331_k.field_72995_K) {
            if (this.structure == null) {
                this.structure = new SynchronizedTankData();
            }
            if (this.structure != null && this.clientHasStructure && this.isRendering) {
                for (SynchronizedTankData.ValveData data : this.valveViewing.keySet()) {
                    if ((Integer)this.valveViewing.get(data) <= 0) continue;
                    this.valveViewing.put(data, (Integer)this.valveViewing.get(data) - 1);
                }
                if (!this.prevStructure) {
                    Mekanism.proxy.doTankAnimation(this);
                }
            }
            this.prevStructure = this.clientHasStructure;
            if (!this.clientHasStructure || !this.isRendering) {
                for (SynchronizedTankData.ValveData data : this.valveViewing.keySet()) {
                    TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)data.location.getTileEntity((IBlockAccess)this.field_70331_k);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = false;
                }
                this.valveViewing.clear();
            }
        }
        if (this.playersUsing.size() > 0 && (this.field_70331_k.field_72995_K && !this.clientHasStructure || !this.field_70331_k.field_72995_K && this.structure == null)) {
            for (EntityPlayer player : this.playersUsing) {
                player.func_71053_j();
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.structure == null) {
                this.isRendering = false;
            }
            if (this.inventoryID != -1 && this.structure == null) {
                MekanismUtils.updateCache(this.inventoryID, this.cachedLiquid, this.inventory, this);
            }
            if (this.structure == null && this.packetTick == 5) {
                this.update();
            }
            if (this.structure != null && this.isRendering && this.packetTick % 20 == 0) {
                this.sendStructure = true;
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), Object3D.get(this), 50.0);
            }
            if (this.prevStructure != (this.structure != null)) {
                if (this.structure != null && !this.structure.hasRenderer) {
                    this.structure.hasRenderer = true;
                    this.isRendering = true;
                    this.sendStructure = true;
                }
                PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            }
            boolean bl = this.prevStructure = this.structure != null;
            if (this.structure != null) {
                this.structure.didTick = false;
                if (this.inventoryID != -1) {
                    MekanismUtils.updateCache(this.inventoryID, this.structure.liquidStored, this.structure.inventory, this);
                    this.cachedLiquid = this.structure.liquidStored;
                    this.inventory = this.structure.inventory;
                }
                this.manageInventory();
            }
        }
    }

    @Override
    public void func_70312_q() {
        this.field_70328_o = false;
    }

    public void manageInventory() {
        int max = this.structure.volume * 16000;
        if (this.structure.inventory[0] != null) {
            if (LiquidContainerRegistry.isEmptyContainer((ItemStack)this.structure.inventory[0])) {
                ItemStack filled;
                if (this.structure.liquidStored != null && this.structure.liquidStored.amount >= 1000 && (filled = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)this.structure.liquidStored, (ItemStack)this.structure.inventory[0])) != null && (this.structure.inventory[1] == null || this.structure.inventory[1].func_77969_a(filled) && this.structure.inventory[1].field_77994_a + 1 <= filled.func_77976_d())) {
                    --this.structure.inventory[0].field_77994_a;
                    if (this.structure.inventory[0].field_77994_a <= 0) {
                        this.structure.inventory[0] = null;
                    }
                    if (this.structure.inventory[1] == null) {
                        this.structure.inventory[1] = filled;
                    } else {
                        ++this.structure.inventory[1].field_77994_a;
                    }
                    this.structure.liquidStored.amount -= LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)filled).amount;
                    if (this.structure.liquidStored.amount == 0) {
                        this.structure.liquidStored = null;
                    }
                    PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
                }
            } else if (LiquidContainerRegistry.isFilledContainer((ItemStack)this.structure.inventory[0])) {
                LiquidStack itemLiquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)this.structure.inventory[0]);
                if (this.structure.liquidStored == null && itemLiquid.amount <= max || this.structure.liquidStored.amount + itemLiquid.amount <= max) {
                    if (this.structure.liquidStored != null && !this.structure.liquidStored.isLiquidEqual(itemLiquid)) {
                        return;
                    }
                    ItemStack bucket = LiquidContainerRegistry.isBucket((ItemStack)this.structure.inventory[0]) ? new ItemStack(Item.field_77788_aw) : null;
                    boolean filled = false;
                    if (bucket != null) {
                        if (this.structure.inventory[1] == null || this.structure.inventory[1].func_77969_a(bucket) && this.structure.inventory[1].field_77994_a + 1 <= bucket.func_77976_d()) {
                            this.structure.inventory[0] = null;
                            if (this.structure.inventory[1] == null) {
                                this.structure.inventory[1] = bucket;
                            } else {
                                ++this.structure.inventory[1].field_77994_a;
                            }
                            filled = true;
                        }
                    } else {
                        --this.structure.inventory[0].field_77994_a;
                        if (this.structure.inventory[0].field_77994_a == 0) {
                            this.structure.inventory[0] = null;
                        }
                        filled = true;
                    }
                    if (filled) {
                        if (this.structure.liquidStored == null) {
                            this.structure.liquidStored = itemLiquid.copy();
                        } else {
                            this.structure.liquidStored.amount += itemLiquid.amount;
                        }
                    }
                    PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
                }
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isRendering);
        data.add(this.structure != null);
        data.add(this.structure != null ? this.structure.volume * 16000 : 0);
        if (this.structure != null && this.structure.liquidStored != null) {
            data.add(1);
            data.add(this.structure.liquidStored.itemID);
            data.add(this.structure.liquidStored.amount);
            data.add(this.structure.liquidStored.itemMeta);
        } else {
            data.add(0);
        }
        if (this.structure != null && this.isRendering) {
            if (this.sendStructure) {
                this.sendStructure = false;
                data.add(true);
                data.add(this.structure.volHeight);
                data.add(this.structure.volWidth);
                data.add(this.structure.volLength);
                data.add(this.structure.renderLocation.xCoord);
                data.add(this.structure.renderLocation.yCoord);
                data.add(this.structure.renderLocation.zCoord);
            } else {
                data.add(false);
            }
            data.add(this.structure.valves.size());
            for (SynchronizedTankData.ValveData valveData : this.structure.valves) {
                data.add(valveData.location.xCoord);
                data.add(valveData.location.yCoord);
                data.add(valveData.location.zCoord);
                data.add(valveData.side.ordinal());
                data.add(valveData.serverLiquid);
            }
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        if (this.structure == null) {
            this.structure = new SynchronizedTankData();
        }
        this.isRendering = dataStream.readBoolean();
        this.clientHasStructure = dataStream.readBoolean();
        this.clientCapacity = dataStream.readInt();
        this.structure.liquidStored = dataStream.readInt() == 1 ? new LiquidStack(dataStream.readInt(), dataStream.readInt(), dataStream.readInt()) : null;
        if (this.clientHasStructure && this.isRendering) {
            if (dataStream.readBoolean()) {
                this.structure.volHeight = dataStream.readInt();
                this.structure.volWidth = dataStream.readInt();
                this.structure.volLength = dataStream.readInt();
                this.structure.renderLocation = new Object3D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            }
            int size = dataStream.readInt();
            for (int i = 0; i < size; ++i) {
                SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
                data.location = new Object3D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
                data.side = ForgeDirection.getOrientation((int)dataStream.readInt());
                int viewingTicks = 0;
                if (dataStream.readBoolean()) {
                    viewingTicks = 30;
                }
                if (viewingTicks == 0 && this.valveViewing.containsKey(data) && (Integer)this.valveViewing.get(data) > 0) continue;
                this.valveViewing.put(data, viewingTicks);
                TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)data.location.getTileEntity((IBlockAccess)this.field_70331_k);
                if (tileEntity == null) continue;
                tileEntity.clientHasStructure = true;
            }
        }
    }

    public void sendPacketToRenderer() {
        if (this.structure != null) {
            for (Object3D obj : this.structure.locations) {
                TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)obj.getTileEntity((IBlockAccess)this.field_70331_k);
                if (tileEntity == null || !tileEntity.isRendering) continue;
                PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Object[0]);
            }
        }
    }

    public int getScaledLiquidLevel(int i) {
        if (this.clientCapacity == 0 || this.structure.liquidStored == null) {
            return 0;
        }
        return this.structure.liquidStored.amount * i / this.clientCapacity;
    }

    @Override
    public ItemStack func_70301_a(int slotID) {
        return this.structure != null ? this.structure.inventory[slotID] : null;
    }

    @Override
    public void func_70299_a(int slotID, ItemStack itemstack) {
        if (this.structure != null) {
            this.structure.inventory[slotID] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        if (this.structure == null) {
            this.inventoryID = nbtTags.func_74762_e("inventoryID");
            if (this.inventoryID != -1 && nbtTags.func_74764_b("cachedLiquid")) {
                this.cachedLiquid = LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cachedLiquid"));
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("inventoryID", this.inventoryID);
        if (this.cachedLiquid != null) {
            nbtTags.func_74782_a("cachedLiquid", (NBTBase)this.cachedLiquid.writeToNBT(new NBTTagCompound()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

