/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import com.google.common.io.ByteArrayDataInput;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IWrenchable;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.IStrictEnergyStorage;
import mekanism.common.ITileNetwork;
import mekanism.common.LinkedPowerProvider;
import mekanism.common.Mekanism;
import mekanism.common.TileEntityContainerBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.IElectricityStorage;
import universalelectricity.core.block.IVoltage;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;

public abstract class TileEntityElectricBlock
extends TileEntityContainerBlock
implements IWrenchable,
ITileNetwork,
IPowerReceptor,
IEnergyTile,
IElectricityStorage,
IVoltage,
IConnector,
IStrictEnergyStorage {
    public double electricityStored;
    public double MAX_ELECTRICITY;
    public IPowerProvider powerProvider;

    public TileEntityElectricBlock(String name, double maxEnergy) {
        super(name);
        this.MAX_ELECTRICITY = maxEnergy;
        this.powerProvider = new LinkedPowerProvider(this);
        this.powerProvider.configure(0, 0, 100, 0, (int)(maxEnergy * Mekanism.TO_BC));
    }

    @Override
    public void onUpdate() {
        if (!this.initialized && this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
            if (Mekanism.hooks.IC2Loaded) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
            this.initialized = true;
        }
        if (!this.field_70331_k.field_72995_K) {
            ElectricityPack electricityPack = ElectricityNetworkHelper.consumeFromMultipleSides(this, this.getConsumingSides(), this.getRequest());
            this.setEnergy(this.getEnergy() + electricityPack.getWatts());
        }
    }

    protected EnumSet getConsumingSides() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return true;
    }

    public ElectricityPack getRequest() {
        return new ElectricityPack((this.getMaxEnergy() - this.getEnergy()) / this.getVoltage(), this.getVoltage());
    }

    @Override
    public double getEnergy() {
        return this.electricityStored;
    }

    @Override
    public void setEnergy(double energy) {
        this.electricityStored = Math.max(Math.min(energy, this.getMaxEnergy()), 0.0);
    }

    @Override
    public double getMaxEnergy() {
        return this.MAX_ELECTRICITY;
    }

    @Override
    public double getMaxJoules() {
        return this.getMaxEnergy();
    }

    @Override
    public double getJoules() {
        return this.getEnergy();
    }

    @Override
    public void setJoules(double joules) {
        this.setEnergy(joules);
    }

    @Override
    public double getVoltage() {
        return 120.0;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.electricityStored = dataStream.readDouble();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.electricityStored);
        return data;
    }

    public void func_70313_j() {
        ElectricityNetworkHelper.invalidate(this);
        if (this.initialized && !this.field_70331_k.field_72995_K && Mekanism.hooks.IC2Loaded) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        super.func_70313_j();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.electricityStored = nbtTags.func_74769_h("electricityStored");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74780_a("electricityStored", this.electricityStored);
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.initialized;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest(ForgeDirection side) {
        return (int)Math.min((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_BC, 100.0);
    }

    @Override
    public void doWork() {
    }
}

