/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import mekanism.common.ChargeUtils;
import mekanism.common.TileEntityElectricBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.item.IItemElectric;

public class TileEntityElectricChest
extends TileEntityElectricBlock {
    public String password = "";
    public boolean authenticated = false;
    public boolean locked = false;
    public float lidAngle;
    public float prevLidAngle;

    public TileEntityElectricChest() {
        super("Electric Chest", 12000.0);
        this.inventory = new ItemStack[55];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.prevLidAngle = this.lidAngle;
        float increment = 0.1f;
        if (this.playersUsing.size() > 0 && this.lidAngle == 0.0f) {
            this.field_70331_k.func_72908_a((double)((float)this.field_70329_l + 0.5f), (double)this.field_70330_m + 0.5, (double)((float)this.field_70327_n + 0.5f), "random.chestopen", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.playersUsing.size() == 0 && this.lidAngle > 0.0f || this.playersUsing.size() > 0 && this.lidAngle < 1.0f) {
            float split;
            float angle = this.lidAngle;
            this.lidAngle = this.playersUsing.size() > 0 ? (this.lidAngle += increment) : (this.lidAngle -= increment);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (split = 0.5f) && angle >= split) {
                this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "random.chestclosed", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        ChargeUtils.discharge(54, this);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.authenticated = nbtTags.func_74767_n("authenticated");
        this.locked = nbtTags.func_74767_n("locked");
        this.password = nbtTags.func_74779_i("password");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("authenticated", this.authenticated);
        nbtTags.func_74757_a("locked", this.locked);
        nbtTags.func_74778_a("password", this.password);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.authenticated = dataStream.readBoolean();
        this.locked = dataStream.readBoolean();
        this.password = dataStream.readUTF();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.authenticated);
        data.add(this.locked);
        data.add(this.password);
        return data;
    }

    public boolean canAccess() {
        return this.authenticated && (this.getEnergy() == 0.0 || !this.locked);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 54) {
            return itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest((ItemStack)itemstack).amperes != 0.0 || itemstack.field_77993_c == Item.field_77767_aC.field_77779_bT;
        }
        return true;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / this.MAX_ELECTRICITY);
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 0) {
            return new int[]{54};
        }
        int[] ret = new int[55];
        for (int i = 0; i <= ret.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 54) {
            return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0 || itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0);
        }
        return true;
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return 54;
        }
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return 1;
        }
        return 54;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }
}

