/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import dan200.computer.api.IComputerAccess;
import ic2.api.item.IElectricItem;
import mekanism.api.EnumColor;
import mekanism.api.SideData;
import mekanism.common.ChargeUtils;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.RecipeHandler;
import mekanism.common.TileEntityBasicMachine;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import universalelectricity.core.item.IItemElectric;

public abstract class TileEntityElectricMachine
extends TileEntityBasicMachine {
    public TileEntityElectricMachine(String soundPath, String name, String path, double perTick, int ticksRequired, double maxEnergy) {
        super(soundPath, name, path, perTick, ticksRequired, maxEnergy);
        this.sideOutputs.add(new SideData(EnumColor.GREY, 0, 0, new int[0]));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, 0, 1, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, 1, 1, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, 2, 1, new int[]{2}));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, 3, 1, new int[]{3}));
        this.sideConfig = new byte[]{2, 1, 0, 0, 4, 3};
        this.inventory = new ItemStack[4];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            ChargeUtils.discharge(1, this);
            if (this.inventory[3] != null) {
                if (this.inventory[3].func_77969_a(new ItemStack(Mekanism.EnergyUpgrade)) && this.energyMultiplier < 8) {
                    if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                        ++this.upgradeTicks;
                    } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                        this.upgradeTicks = 0;
                        ++this.energyMultiplier;
                        --this.inventory[3].field_77994_a;
                        if (this.inventory[3].field_77994_a == 0) {
                            this.inventory[3] = null;
                        }
                    }
                } else if (this.inventory[3].func_77969_a(new ItemStack(Mekanism.SpeedUpgrade)) && this.speedMultiplier < 8) {
                    if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                        ++this.upgradeTicks;
                    } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                        this.upgradeTicks = 0;
                        ++this.speedMultiplier;
                        --this.inventory[3].field_77994_a;
                        if (this.inventory[3].field_77994_a == 0) {
                            this.inventory[3] = null;
                        }
                    }
                } else {
                    this.upgradeTicks = 0;
                }
            } else {
                this.upgradeTicks = 0;
            }
            if (this.electricityStored >= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK)) {
                if (this.canOperate() && this.operatingTicks + 1 < MekanismUtils.getTicks(this.speedMultiplier, this.TICKS_REQUIRED)) {
                    ++this.operatingTicks;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK);
                } else if (this.canOperate() && this.operatingTicks + 1 >= MekanismUtils.getTicks(this.speedMultiplier, this.TICKS_REQUIRED)) {
                    this.operate();
                    this.operatingTicks = 0;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK);
                }
            }
            if (!this.canOperate()) {
                this.operatingTicks = 0;
            }
            if (this.canOperate() && this.electricityStored >= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK)) {
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 2) {
            return false;
        }
        if (slotID == 3) {
            return itemstack.field_77993_c == Mekanism.SpeedUpgrade.field_77779_bT || itemstack.field_77993_c == Mekanism.EnergyUpgrade.field_77779_bT;
        }
        if (slotID == 0) {
            return RecipeHandler.getOutput(itemstack, false, this.getRecipes()) != null;
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest((ItemStack)itemstack).amperes != 0.0 || itemstack.field_77993_c == Item.field_77767_aC.field_77779_bT;
        }
        return true;
    }

    @Override
    public void operate() {
        ItemStack itemstack = RecipeHandler.getOutput(this.inventory[0], true, this.getRecipes());
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[2] == null) {
            this.inventory[2] = itemstack;
        } else {
            this.inventory[2].field_77994_a += itemstack.field_77994_a;
        }
    }

    @Override
    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemStack itemstack = RecipeHandler.getOutput(this.inventory[0], false, this.getRecipes());
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemstack)) {
            return false;
        }
        return this.inventory[2].field_77994_a + itemstack.field_77994_a <= this.inventory[2].func_77976_d();
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0 || itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0);
        }
        return slotID == 2;
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.isActive};
            }
            case 3: {
                return new Object[]{this.facing};
            }
            case 4: {
                return new Object[]{this.canOperate()};
            }
            case 5: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)};
            }
            case 6: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }
}

