/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.IStrictEnergyAcceptor;
import mekanism.api.Object3D;
import mekanism.common.ChargeUtils;
import mekanism.common.ISustainedTank;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.TileEntityElectricBlock;
import mekanism.common.network.PacketTileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import universalelectricity.core.item.IItemElectric;

public class TileEntityElectricPump
extends TileEntityElectricBlock
implements ITankContainer,
ISustainedTank,
IEnergySink,
IStrictEnergyAcceptor {
    public LiquidTank liquidTank;
    public Set recurringNodes = new HashSet();
    public Set cleaningNodes = new HashSet();

    public TileEntityElectricPump() {
        super("Electric Pump", 10000.0);
        this.liquidTank = new LiquidTank(10000);
        this.inventory = new ItemStack[3];
    }

    @Override
    public void onUpdate() {
        ItemStack tempStack;
        ChargeUtils.discharge(2, this);
        if (this.inventory[0] != null && this.liquidTank.getLiquid() != null && this.liquidTank.getLiquid().amount >= 1000 && LiquidContainerRegistry.isEmptyContainer((ItemStack)this.inventory[0]) && (tempStack = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)this.liquidTank.getLiquid(), (ItemStack)this.inventory[0])) != null) {
            if (this.inventory[1] == null) {
                this.liquidTank.drain(1000, true);
                this.inventory[1] = tempStack;
                --this.inventory[0].field_77994_a;
                if (this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
            } else if (tempStack.func_77969_a(this.inventory[1]) && tempStack.func_77976_d() > this.inventory[1].field_77994_a) {
                this.liquidTank.drain(1000, true);
                ++this.inventory[1].field_77994_a;
                --this.inventory[0].field_77994_a;
                if (this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
            }
        }
        if (!this.field_70331_k.field_72995_K && this.field_70331_k.func_72820_D() % 20L == 0L && this.electricityStored >= 100.0 && (this.liquidTank.getLiquid() == null || this.liquidTank.getLiquid().amount + 1000 <= 10000)) {
            if (this.suck(true)) {
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), Object3D.get(this), 50.0);
            }
            this.clean(true);
        }
        super.onUpdate();
        if (this.liquidTank.getLiquid() != null) {
            for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = Object3D.get(this).getFromSide(orientation).getTileEntity((IBlockAccess)this.field_70331_k);
                if (!(tileEntity instanceof ITankContainer)) continue;
                this.liquidTank.drain(((ITankContainer)tileEntity).fill(orientation.getOpposite(), this.liquidTank.getLiquid(), true), true);
                if (this.liquidTank.getLiquid() == null || this.liquidTank.getLiquid().amount <= 0) break;
            }
        }
    }

    public boolean suck(boolean take) {
        List<Object3D> tempPumpList = Arrays.asList(this.recurringNodes.toArray(new Object3D[this.recurringNodes.size()]));
        Collections.shuffle(tempPumpList);
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            Object3D wrapper = Object3D.get(this).getFromSide(orientation);
            if (!MekanismUtils.isLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) || this.liquidTank.getLiquid() != null && !MekanismUtils.getLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord).isLiquidEqual(this.liquidTank.getLiquid())) continue;
            if (take) {
                this.setEnergy(this.electricityStored - 100.0);
                this.recurringNodes.add(new Object3D(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord));
                this.liquidTank.fill(MekanismUtils.getLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord), true);
                this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
            }
            return true;
        }
        for (Object3D wrapper : this.cleaningNodes) {
            if (!MekanismUtils.isLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) || this.liquidTank.getLiquid() == null || !MekanismUtils.getLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord).isLiquidEqual(this.liquidTank.getLiquid())) continue;
            if (take) {
                this.setEnergy(this.electricityStored - 100.0);
                this.liquidTank.fill(MekanismUtils.getLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord), true);
                this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
            }
            return true;
        }
        for (Object3D wrapper : tempPumpList) {
            if (MekanismUtils.isLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) && (this.liquidTank.getLiquid() == null || MekanismUtils.getLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord).isLiquidEqual(this.liquidTank.getLiquid()))) {
                if (take) {
                    this.setEnergy(this.electricityStored - 100.0);
                    this.liquidTank.fill(MekanismUtils.getLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord), true);
                    this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
                }
                return true;
            }
            for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
                Object3D side = wrapper.getFromSide(orientation);
                if (Object3D.get(this).distanceTo(side) > 80 || !MekanismUtils.isLiquid(this.field_70331_k, side.xCoord, side.yCoord, side.zCoord) || this.liquidTank.getLiquid() != null && !MekanismUtils.getLiquid(this.field_70331_k, side.xCoord, side.yCoord, side.zCoord).isLiquidEqual(this.liquidTank.getLiquid())) continue;
                if (take) {
                    this.setEnergy(this.electricityStored - 100.0);
                    this.recurringNodes.add(side);
                    this.liquidTank.fill(MekanismUtils.getLiquid(this.field_70331_k, side.xCoord, side.yCoord, side.zCoord), true);
                    this.field_70331_k.func_94571_i(side.xCoord, side.yCoord, side.zCoord);
                }
                return true;
            }
            this.cleaningNodes.add(wrapper);
            this.recurringNodes.remove(wrapper);
        }
        return false;
    }

    public boolean clean(boolean take) {
        boolean took = false;
        if (!this.field_70331_k.field_72995_K) {
            for (Object3D wrapper : this.cleaningNodes) {
                if (!MekanismUtils.isDeadLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) || this.liquidTank.getLiquid() == null || MekanismUtils.getLiquidId(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) != this.liquidTank.getLiquid().itemID) continue;
                took = true;
                if (!take) continue;
                this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
            }
            for (Object3D wrapper : this.recurringNodes) {
                if (!MekanismUtils.isDeadLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) || this.liquidTank.getLiquid() == null || MekanismUtils.getLiquidId(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) != this.liquidTank.getLiquid().itemID) continue;
                took = true;
                if (!take) continue;
                this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
            }
            for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
                Object3D wrapper = Object3D.get(this).getFromSide(orientation);
                if (!MekanismUtils.isDeadLiquid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) || this.liquidTank.getLiquid() == null || MekanismUtils.getLiquidId(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) != this.liquidTank.getLiquid().itemID) continue;
                took = true;
                if (!take) continue;
                this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
            }
        }
        return took;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        if (dataStream.readInt() == 1) {
            this.liquidTank.setLiquid(new LiquidStack(dataStream.readInt(), dataStream.readInt(), dataStream.readInt()));
        } else {
            this.liquidTank.setLiquid(null);
        }
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.liquidTank.getLiquid() != null) {
            data.add(1);
            data.add(this.liquidTank.getLiquid().itemID);
            data.add(this.liquidTank.getLiquid().amount);
            data.add(this.liquidTank.getLiquid().itemMeta);
        } else {
            data.add(0);
        }
        return data;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / this.MAX_ELECTRICITY);
    }

    public int getScaledLiquidLevel(int i) {
        return this.liquidTank.getLiquid() != null ? this.liquidTank.getLiquid().amount * i / 10000 : 0;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        if (this.liquidTank.getLiquid() != null) {
            nbtTags.func_74782_a("liquidTank", (NBTBase)this.liquidTank.writeToNBT(new NBTTagCompound()));
        }
        NBTTagList recurringList = new NBTTagList();
        for (Object3D wrapper : this.recurringNodes) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            wrapper.write(tagCompound);
            recurringList.func_74742_a((NBTBase)tagCompound);
        }
        if (!recurringList.field_74747_a.isEmpty()) {
            nbtTags.func_74782_a("recurringNodes", (NBTBase)recurringList);
        }
        NBTTagList cleaningList = new NBTTagList();
        for (Object3D wrapper : this.cleaningNodes) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            wrapper.write(tagCompound);
            cleaningList.func_74742_a((NBTBase)tagCompound);
        }
        if (!cleaningList.field_74747_a.isEmpty()) {
            nbtTags.func_74782_a("cleaningNodes", (NBTBase)cleaningList);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        int i;
        NBTTagList tagList;
        super.func_70307_a(nbtTags);
        if (nbtTags.func_74764_b("liquidTank")) {
            this.liquidTank.readFromNBT(nbtTags.func_74775_l("liquidTank"));
        }
        if (nbtTags.func_74764_b("recurringNodes")) {
            tagList = nbtTags.func_74761_m("recurringNodes");
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                this.recurringNodes.add(Object3D.read((NBTTagCompound)tagList.func_74743_b(i)));
            }
        }
        if (nbtTags.func_74764_b("cleaningNodes")) {
            tagList = nbtTags.func_74761_m("cleaningNodes");
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                this.cleaningNodes.add(Object3D.read((NBTTagCompound)tagList.func_74743_b(i)));
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 1) {
            return false;
        }
        if (slotID == 0) {
            return LiquidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        if (slotID == 2) {
            return itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest((ItemStack)itemstack).amperes != 0.0 || itemstack.field_77993_c == Item.field_77767_aC.field_77779_bT;
        }
        return true;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 2) {
            return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0 || itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0);
        }
        return slotID == 1;
    }

    @Override
    public double transferEnergyToAcceptor(double amount) {
        double rejects = 0.0;
        double neededElectricity = this.MAX_ELECTRICITY - this.electricityStored;
        if (amount <= neededElectricity) {
            this.electricityStored += amount;
        } else {
            this.electricityStored += neededElectricity;
            rejects = amount - neededElectricity;
        }
        return rejects;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return true;
    }

    @Override
    public int demandsEnergy() {
        return (int)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double rejects = 0.0;
        double neededEnergy = this.MAX_ELECTRICITY - this.electricityStored;
        if ((double)i <= neededEnergy) {
            this.electricityStored += (double)i;
        } else if ((double)i > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = (double)i - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return direction.toForgeDirection() != ForgeDirection.getOrientation((int)this.facing);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{0};
        }
        if (side == 0) {
            return new int[]{1};
        }
        return new int[]{2};
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (tankIndex == 0) {
            return this.liquidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.liquidTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.liquidTank;
    }

    @Override
    public void setLiquidStack(LiquidStack liquidStack, Object ... data) {
        this.liquidTank.setLiquid(liquidStack);
    }

    @Override
    public LiquidStack getLiquidStack(Object ... data) {
        return this.liquidTank.getLiquid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }
}

