/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IEnergyStorage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import mekanism.api.ICableOutputter;
import mekanism.api.IStrictEnergyAcceptor;
import mekanism.api.Object3D;
import mekanism.common.CableUtils;
import mekanism.common.ChargeUtils;
import mekanism.common.IUniversalCable;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.Tier;
import mekanism.common.TileEntityElectricBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IElectricityStorage;
import universalelectricity.core.block.IVoltage;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.IElectricityNetwork;
import universalelectricity.core.item.IItemElectric;

public class TileEntityEnergyCube
extends TileEntityElectricBlock
implements IEnergySink,
IEnergySource,
IEnergyStorage,
IPowerReceptor,
IElectricityStorage,
IVoltage,
IPeripheral,
ICableOutputter,
IStrictEnergyAcceptor {
    public Tier.EnergyCubeTier tier = Tier.EnergyCubeTier.BASIC;
    public int currentRedstoneLevel;

    public TileEntityEnergyCube() {
        super("Energy Cube", 0.0);
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        ChargeUtils.charge(0, this);
        ChargeUtils.discharge(1, this);
        if (!this.field_70331_k.field_72995_K) {
            TileEntity tileEntity = Object3D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
            if (this.electricityStored > 0.0) {
                if (tileEntity instanceof IUniversalCable) {
                    this.setEnergy(this.electricityStored - (Math.min(this.electricityStored, this.tier.OUTPUT) - CableUtils.emitEnergyToNetwork(Math.min(this.electricityStored, this.tier.OUTPUT), this, ForgeDirection.getOrientation((int)this.facing))));
                    return;
                }
                if ((tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergyAcceptor) && Mekanism.hooks.IC2Loaded) {
                    if (this.electricityStored >= this.tier.OUTPUT) {
                        EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, (int)(this.tier.OUTPUT * Mekanism.TO_IC2));
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        this.setEnergy(this.electricityStored - (this.tier.OUTPUT - (double)event.amount * Mekanism.FROM_IC2));
                    }
                } else if (this.isPowerReceptor(tileEntity) && Mekanism.hooks.BuildCraftLoaded) {
                    IPowerReceptor receptor = (IPowerReceptor)tileEntity;
                    double electricityNeeded = (double)Math.min((float)receptor.powerRequest(ForgeDirection.getOrientation((int)this.facing).getOpposite()), (float)receptor.getPowerProvider().getMaxEnergyStored() - receptor.getPowerProvider().getEnergyStored()) * Mekanism.FROM_BC;
                    float transferEnergy = (float)Math.min(this.electricityStored, Math.min(electricityNeeded, this.tier.OUTPUT));
                    receptor.getPowerProvider().receiveEnergy((float)((double)transferEnergy * Mekanism.TO_BC), ForgeDirection.getOrientation((int)this.facing).getOpposite());
                    this.setEnergy(this.electricityStored - (double)transferEnergy);
                }
            }
            if (tileEntity instanceof IConductor) {
                ForgeDirection outputDirection = ForgeDirection.getOrientation((int)this.facing);
                ArrayList<IElectricityNetwork> inputNetworks = new ArrayList<IElectricityNetwork>();
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    IElectricityNetwork network;
                    if (direction == outputDirection || (network = ElectricityNetworkHelper.getNetworkFromTileEntity(Object3D.get(this).getFromSide(direction).getTileEntity((IBlockAccess)this.field_70331_k), direction)) == null) continue;
                    inputNetworks.add(network);
                }
                IElectricityNetwork outputNetwork = ElectricityNetworkHelper.getNetworkFromTileEntity(tileEntity, outputDirection);
                if (outputNetwork != null && !inputNetworks.contains(outputNetwork)) {
                    double outputWatts = Math.min(outputNetwork.getRequest(new TileEntity[0]).getWatts(), Math.min(this.getEnergy(), 10000.0));
                    if (this.getEnergy() > 0.0 && outputWatts > 0.0 && this.getEnergy() - outputWatts >= 0.0) {
                        outputNetwork.startProducing(this, Math.min(outputWatts, this.getEnergy()) / this.getVoltage(), this.getVoltage());
                        this.setEnergy(this.electricityStored - outputWatts);
                    } else {
                        outputNetwork.stopProducing(this);
                    }
                }
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IElectricItem || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest((ItemStack)itemstack).amperes != 0.0;
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest((ItemStack)itemstack).amperes != 0.0 || itemstack.field_77993_c == Item.field_77767_aC.field_77779_bT;
        }
        return true;
    }

    @Override
    protected EnumSet getConsumingSides() {
        HashSet<ForgeDirection> set = new HashSet<ForgeDirection>();
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (dir == ForgeDirection.getOrientation((int)this.facing)) continue;
            set.add(dir);
        }
        return EnumSet.copyOf(set);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return direction.toForgeDirection() != ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public int getStored() {
        return (int)(this.electricityStored * Mekanism.TO_IC2);
    }

    @Override
    public int getCapacity() {
        return (int)(this.tier.MAX_ELECTRICITY * Mekanism.TO_IC2);
    }

    @Override
    public int getOutput() {
        return (int)(this.tier.OUTPUT * Mekanism.TO_IC2);
    }

    @Override
    public int demandsEnergy() {
        return (int)((this.tier.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenEnergy = (double)i * Mekanism.FROM_IC2;
        double rejects = 0.0;
        double neededEnergy = this.tier.MAX_ELECTRICITY - this.electricityStored;
        if (givenEnergy <= neededEnergy) {
            this.electricityStored += givenEnergy;
        } else if (givenEnergy > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = givenEnergy - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public double transferEnergyToAcceptor(double amount) {
        double rejects = 0.0;
        double neededElectricity = this.tier.MAX_ELECTRICITY - this.electricityStored;
        if (amount <= neededElectricity) {
            this.electricityStored += amount;
        } else {
            this.electricityStored += neededElectricity;
            rejects = amount - neededElectricity;
        }
        return rejects;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return side != ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return direction.toForgeDirection() == ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public int getMaxEnergyOutput() {
        return (int)(this.tier.OUTPUT * Mekanism.TO_IC2);
    }

    @Override
    public double getMaxEnergy() {
        return this.tier.MAX_ELECTRICITY;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0 || itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0);
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest(itemstack).getWatts() == 0.0 || itemstack.func_77973_b() instanceof IElectricItem && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getReceiveRequest(itemstack).getWatts() == 0.0);
        }
        return false;
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.getOrientation((int)1)) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public double getVoltage() {
        return this.tier.VOLTAGE;
    }

    public boolean isPowerReceptor(TileEntity tileEntity) {
        if (tileEntity instanceof IPowerReceptor) {
            IPowerReceptor receptor = (IPowerReceptor)tileEntity;
            IPowerProvider provider = receptor.getPowerProvider();
            return provider != null && provider.getClass().getSuperclass().equals(PowerProvider.class);
        }
        return false;
    }

    @Override
    public String getType() {
        return this.func_70303_b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.tier.OUTPUT};
            }
            case 2: {
                return new Object[]{this.tier.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.tier.MAX_ELECTRICITY - this.electricityStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.tier = Tier.EnergyCubeTier.getFromName(dataStream.readUTF());
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.tier.name);
        return data;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.tier = Tier.EnergyCubeTier.getFromName(nbtTags.func_74779_i("tier"));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74778_a("tier", this.tier.name);
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public void setStored(int energy) {
        this.setEnergy((double)energy * Mekanism.FROM_IC2);
    }

    @Override
    public int addEnergy(int amount) {
        this.setEnergy(this.electricityStored + (double)amount * Mekanism.FROM_IC2);
        return (int)this.electricityStored;
    }

    @Override
    public boolean isTeleporterCompatible(Direction side) {
        return true;
    }

    @Override
    public int powerRequest(ForgeDirection side) {
        return side != ForgeDirection.getOrientation((int)this.facing) ? Math.min(100, (int)(this.tier.MAX_ELECTRICITY - this.electricityStored)) : 0;
    }

    @Override
    public boolean canOutputTo(ForgeDirection side) {
        return side == ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public void setEnergy(double energy) {
        super.setEnergy(energy);
        int newRedstoneLevel = this.getRedstoneLevel();
        if (newRedstoneLevel != this.currentRedstoneLevel) {
            this.func_70296_d();
            this.currentRedstoneLevel = newRedstoneLevel;
        }
    }

    public int getRedstoneLevel() {
        double fractionFull = this.getEnergy() / this.getMaxEnergy();
        return MathHelper.func_76141_d((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }
}

