/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.IStrictEnergyAcceptor;
import mekanism.api.IUpgradeManagement;
import mekanism.api.Object3D;
import mekanism.api.SideData;
import mekanism.client.IHasSound;
import mekanism.common.BlockMachine;
import mekanism.common.ChargeUtils;
import mekanism.common.IActiveState;
import mekanism.common.IFactory;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.Tier;
import mekanism.common.TileEntityElectricBlock;
import mekanism.common.network.PacketTileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.item.IItemElectric;

public class TileEntityFactory
extends TileEntityElectricBlock
implements IEnergySink,
IPeripheral,
IActiveState,
IConfigurable,
IUpgradeManagement,
IHasSound,
IStrictEnergyAcceptor {
    public Tier.FactoryTier tier;
    public byte[] sideConfig;
    public ArrayList sideOutputs = new ArrayList();
    public int[] progress;
    public int TICKS_REQUIRED = 200;
    public double ENERGY_PER_TICK = Mekanism.factoryUsage;
    public int speedMultiplier;
    public int energyMultiplier;
    public int UPGRADE_TICKS_REQUIRED = 40;
    public int upgradeTicks;
    public int RECIPE_TICKS_REQUIRED = 40;
    public int recipeTicks;
    public boolean prevActive;
    public boolean isActive;
    public int recipeType;

    public TileEntityFactory() {
        this(Tier.FactoryTier.BASIC, BlockMachine.MachineType.BASIC_FACTORY);
        this.sideOutputs.add(new SideData(EnumColor.GREY, 0, 0, new int[0]));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, 0, 1, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, 1, 1, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, 4, 3, new int[]{4, 5, 6}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, 7, 3, new int[]{7, 8, 9}));
        this.sideConfig = new byte[]{4, 3, 0, 0, 2, 1};
    }

    public TileEntityFactory(Tier.FactoryTier type, BlockMachine.MachineType machine) {
        super(type.name + " Factory", machine.baseEnergy);
        this.tier = type;
        this.inventory = new ItemStack[4 + type.processes * 2];
        this.progress = new int[type.processes];
        this.isActive = false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.registerSound(this);
        }
        if (!this.field_70331_k.field_72995_K) {
            ChargeUtils.discharge(1, this);
            if (this.inventory[0] != null) {
                if (this.inventory[0].func_77969_a(new ItemStack(Mekanism.EnergyUpgrade)) && this.energyMultiplier < 8) {
                    if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                        ++this.upgradeTicks;
                    } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                        this.upgradeTicks = 0;
                        ++this.energyMultiplier;
                        --this.inventory[0].field_77994_a;
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                } else if (this.inventory[0].func_77969_a(new ItemStack(Mekanism.SpeedUpgrade)) && this.speedMultiplier < 8) {
                    if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                        ++this.upgradeTicks;
                    } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                        this.upgradeTicks = 0;
                        ++this.speedMultiplier;
                        --this.inventory[0].field_77994_a;
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                } else {
                    this.upgradeTicks = 0;
                }
            } else {
                this.upgradeTicks = 0;
            }
            if (this.inventory[2] != null && this.inventory[3] == null) {
                if (this.inventory[2].func_77969_a(new ItemStack(Mekanism.MachineBlock, 1, BlockMachine.MachineType.ENERGIZED_SMELTER.meta)) && this.recipeType != 0) {
                    if (this.recipeTicks < this.RECIPE_TICKS_REQUIRED) {
                        ++this.recipeTicks;
                    } else if (this.recipeTicks == this.RECIPE_TICKS_REQUIRED) {
                        this.recipeTicks = 0;
                        this.inventory[2] = null;
                        this.inventory[3] = this.getMachineStack();
                        this.recipeType = 0;
                    }
                } else if (this.inventory[2].func_77969_a(new ItemStack(Mekanism.MachineBlock, 1, BlockMachine.MachineType.ENRICHMENT_CHAMBER.meta)) && this.recipeType != 1) {
                    if (this.recipeTicks < this.RECIPE_TICKS_REQUIRED) {
                        ++this.recipeTicks;
                    } else if (this.recipeTicks == this.RECIPE_TICKS_REQUIRED) {
                        this.recipeTicks = 0;
                        this.inventory[2] = null;
                        this.inventory[3] = this.getMachineStack();
                        this.recipeType = 1;
                    }
                } else if (this.inventory[2].func_77969_a(new ItemStack(Mekanism.MachineBlock, 1, BlockMachine.MachineType.CRUSHER.meta)) && this.recipeType != 2) {
                    if (this.recipeTicks < this.RECIPE_TICKS_REQUIRED) {
                        ++this.recipeTicks;
                    } else if (this.recipeTicks == this.RECIPE_TICKS_REQUIRED) {
                        this.recipeTicks = 0;
                        this.inventory[2] = null;
                        this.inventory[3] = this.getMachineStack();
                        this.recipeType = 2;
                    }
                } else {
                    this.recipeTicks = 0;
                }
            } else {
                this.recipeTicks = 0;
            }
            for (int process = 0; process < this.tier.processes; ++process) {
                if (this.electricityStored >= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK)) {
                    if (this.canOperate(this.getInputSlot(process), this.getOutputSlot(process)) && this.progress[process] + 1 < MekanismUtils.getTicks(this.speedMultiplier, this.TICKS_REQUIRED)) {
                        int n = process;
                        this.progress[n] = this.progress[n] + 1;
                        this.electricityStored -= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK);
                    } else if (this.canOperate(this.getInputSlot(process), this.getOutputSlot(process)) && this.progress[process] + 1 >= MekanismUtils.getTicks(this.speedMultiplier, this.TICKS_REQUIRED)) {
                        this.operate(this.getInputSlot(process), this.getOutputSlot(process));
                        this.progress[process] = 0;
                        this.electricityStored -= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK);
                    }
                }
                if (this.canOperate(this.getInputSlot(process), this.getOutputSlot(process))) continue;
                this.progress[process] = 0;
            }
            if (!this.field_70331_k.field_72995_K) {
                boolean hasOperation = false;
                for (int i = 0; i < this.tier.processes; ++i) {
                    if (!this.canOperate(this.getInputSlot(i), this.getOutputSlot(i))) continue;
                    hasOperation = true;
                    break;
                }
                if (hasOperation && this.electricityStored >= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK)) {
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            }
        }
    }

    public ItemStack getMachineStack() {
        switch (this.recipeType) {
            case 0: {
                return new ItemStack(Mekanism.MachineBlock, 1, BlockMachine.MachineType.ENERGIZED_SMELTER.meta);
            }
            case 1: {
                return new ItemStack(Mekanism.MachineBlock, 1, BlockMachine.MachineType.ENRICHMENT_CHAMBER.meta);
            }
            case 2: {
                return new ItemStack(Mekanism.MachineBlock, 1, BlockMachine.MachineType.CRUSHER.meta);
            }
        }
        return null;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0 || itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0);
        }
        if (this.tier == Tier.FactoryTier.BASIC && slotID >= 7 && slotID <= 9) {
            return true;
        }
        if (this.tier == Tier.FactoryTier.ADVANCED && slotID >= 9 && slotID <= 13) {
            return true;
        }
        return this.tier == Tier.FactoryTier.ELITE && slotID >= 11 && slotID <= 17;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (this.tier == Tier.FactoryTier.BASIC) {
            if (slotID >= 7 && slotID <= 9) {
                return false;
            }
            if (slotID >= 4 && slotID <= 6) {
                return IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(itemstack, false) != null;
            }
        } else if (this.tier == Tier.FactoryTier.ADVANCED) {
            if (slotID >= 9 && slotID <= 13) {
                return false;
            }
            if (slotID >= 4 && slotID <= 8) {
                return IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(itemstack, false) != null;
            }
        } else if (this.tier == Tier.FactoryTier.ELITE) {
            if (slotID >= 11 && slotID <= 17) {
                return false;
            }
            if (slotID >= 4 && slotID <= 10) {
                return IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(itemstack, false) != null;
            }
        }
        if (slotID == 0) {
            return itemstack.field_77993_c == Mekanism.SpeedUpgrade.field_77779_bT || itemstack.field_77993_c == Mekanism.EnergyUpgrade.field_77779_bT;
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest((ItemStack)itemstack).amperes != 0.0 || itemstack.field_77993_c == Item.field_77767_aC.field_77779_bT;
        }
        return true;
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.unregisterSound(this);
        }
    }

    public int getScaledProgress(int i, int process) {
        return this.progress[process] * i / MekanismUtils.getTicks(this.speedMultiplier, this.TICKS_REQUIRED);
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY));
    }

    public int getScaledUpgradeProgress(int i) {
        return this.upgradeTicks * i / this.UPGRADE_TICKS_REQUIRED;
    }

    public int getScaledRecipeProgress(int i) {
        return this.recipeTicks * i / this.RECIPE_TICKS_REQUIRED;
    }

    public boolean canOperate(int inputSlot, int outputSlot) {
        if (this.inventory[inputSlot] == null) {
            return false;
        }
        ItemStack itemstack = IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(this.inventory[inputSlot], false);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[outputSlot] == null) {
            return true;
        }
        if (!this.inventory[outputSlot].func_77969_a(itemstack)) {
            return false;
        }
        return this.inventory[outputSlot].field_77994_a + itemstack.field_77994_a <= this.inventory[outputSlot].func_77976_d();
    }

    public void operate(int inputSlot, int outputSlot) {
        if (!this.canOperate(inputSlot, outputSlot)) {
            return;
        }
        ItemStack itemstack = IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(this.inventory[inputSlot], true);
        if (this.inventory[inputSlot].field_77994_a <= 0) {
            this.inventory[inputSlot] = null;
        }
        if (this.inventory[outputSlot] == null) {
            this.inventory[outputSlot] = itemstack;
        } else {
            this.inventory[outputSlot].field_77994_a += itemstack.field_77994_a;
        }
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotStart;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotAmount;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        int i;
        super.handlePacketData(dataStream);
        this.speedMultiplier = dataStream.readInt();
        this.energyMultiplier = dataStream.readInt();
        this.isActive = dataStream.readBoolean();
        this.recipeType = dataStream.readInt();
        this.upgradeTicks = dataStream.readInt();
        this.recipeTicks = dataStream.readInt();
        for (i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = dataStream.readInt();
        }
        for (i = 0; i < 6; ++i) {
            this.sideConfig[i] = dataStream.readByte();
        }
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        int i;
        super.func_70307_a(nbtTags);
        this.speedMultiplier = nbtTags.func_74762_e("speedMultiplier");
        this.energyMultiplier = nbtTags.func_74762_e("energyMultiplier");
        this.isActive = nbtTags.func_74767_n("isActive");
        this.recipeType = nbtTags.func_74762_e("recipeType");
        this.upgradeTicks = nbtTags.func_74762_e("upgradeTicks");
        this.recipeTicks = nbtTags.func_74762_e("recipeTicks");
        for (i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = nbtTags.func_74762_e("progress" + i);
        }
        if (nbtTags.func_74764_b("sideDataStored")) {
            for (i = 0; i < 6; ++i) {
                this.sideConfig[i] = nbtTags.func_74771_c("config" + i);
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        int i;
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("speedMultiplier", this.speedMultiplier);
        nbtTags.func_74768_a("energyMultiplier", this.energyMultiplier);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("recipeType", this.recipeType);
        nbtTags.func_74768_a("upgradeTicks", this.upgradeTicks);
        nbtTags.func_74768_a("recipeTicks", this.recipeTicks);
        for (i = 0; i < this.tier.processes; ++i) {
            nbtTags.func_74768_a("progress" + i, this.progress[i]);
        }
        nbtTags.func_74757_a("sideDataStored", true);
        for (i = 0; i < 6; ++i) {
            nbtTags.func_74774_a("config" + i, this.sideConfig[i]);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.speedMultiplier);
        data.add(this.energyMultiplier);
        data.add(this.isActive);
        data.add(this.recipeType);
        data.add(this.upgradeTicks);
        data.add(this.recipeTicks);
        data.add(this.progress);
        data.add(this.sideConfig);
        return data;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    public int getInputSlot(int operation) {
        return operation + 4;
    }

    public int getOutputSlot(int operation) {
        return this.tier.processes + 4 + operation;
    }

    @Override
    public double transferEnergyToAcceptor(double amount) {
        double rejects = 0.0;
        double neededElectricity = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
        if (amount <= neededElectricity) {
            this.electricityStored += amount;
        } else {
            this.electricityStored += neededElectricity;
            rejects = amount - neededElectricity;
        }
        return rejects;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return true;
    }

    @Override
    public String getType() {
        return this.func_70303_b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.progress[(Integer)arguments[0]]};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.canOperate(this.getInputSlot((Integer)arguments[0]), this.getOutputSlot((Integer)arguments[0]))};
            }
            case 4: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)};
            }
            case 5: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public double getMaxEnergy() {
        return MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY);
    }

    @Override
    public int demandsEnergy() {
        return (int)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.prevActive != active) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
        }
        this.prevActive = active;
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenEnergy = (double)i * Mekanism.FROM_IC2;
        double rejects = 0.0;
        double neededEnergy = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
        if (givenEnergy < neededEnergy) {
            this.electricityStored += givenEnergy;
        } else if (givenEnergy > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = givenEnergy - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public int powerRequest(ForgeDirection side) {
        return (int)Math.min((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_BC, 100.0);
    }

    @Override
    public int[] func_94128_d(int side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side, (int)this.facing)])).availableSlots;
    }

    @Override
    public ArrayList getSideData() {
        return this.sideOutputs;
    }

    @Override
    public byte[] getConfiguration() {
        return this.sideConfig;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.energyMultiplier = multiplier;
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.speedMultiplier = multiplier;
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        return true;
    }

    @Override
    public String getSoundPath() {
        return IFactory.RecipeType.values()[this.recipeType].getSound();
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean hasVisual() {
        return true;
    }
}

