/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.EnumGas;
import mekanism.api.GasTransmission;
import mekanism.api.IGasAcceptor;
import mekanism.api.IGasStorage;
import mekanism.api.IStorageTank;
import mekanism.api.ITubeConnection;
import mekanism.api.Object3D;
import mekanism.common.MekanismUtils;
import mekanism.common.TileEntityContainerBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityGasTank
extends TileEntityContainerBlock
implements IGasStorage,
IGasAcceptor,
ITubeConnection {
    public EnumGas gasType = EnumGas.NONE;
    public int MAX_GAS = 96000;
    public int gasStored;
    public int output = 16;

    public TileEntityGasTank() {
        super("Gas Tank");
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        int rejects;
        int sendingGas;
        IStorageTank item;
        if (this.inventory[0] != null && this.gasStored > 0 && this.inventory[0].func_77973_b() instanceof IStorageTank && (((IStorageTank)this.inventory[0].func_77973_b()).getGasType(this.inventory[0]) == this.gasType || ((IStorageTank)this.inventory[0].func_77973_b()).getGasType(this.inventory[0]) == EnumGas.NONE)) {
            item = (IStorageTank)this.inventory[0].func_77973_b();
            if (this.gasType == EnumGas.NONE) {
                this.gasType = item.getGasType(this.inventory[0]);
            }
            if (item.canReceiveGas(this.inventory[0], this.gasType)) {
                sendingGas = 0;
                if (item.getRate() <= this.gasStored) {
                    sendingGas = item.getRate();
                } else if (item.getRate() > this.gasStored) {
                    sendingGas = this.gasStored;
                }
                rejects = item.addGas(this.inventory[0], this.gasType, sendingGas);
                this.setGas(this.gasType, this.gasStored - (sendingGas - rejects), new Object[0]);
            }
        }
        if (this.inventory[1] != null && this.gasStored < this.MAX_GAS && this.inventory[1].func_77973_b() instanceof IStorageTank && (((IStorageTank)this.inventory[1].func_77973_b()).getGasType(this.inventory[1]) == this.gasType || this.gasType == EnumGas.NONE)) {
            item = (IStorageTank)this.inventory[1].func_77973_b();
            if (this.gasType == EnumGas.NONE) {
                this.gasType = item.getGasType(this.inventory[1]);
            }
            if (item.canProvideGas(this.inventory[1], this.gasType)) {
                int received = 0;
                int gasNeeded = this.MAX_GAS - this.gasStored;
                if (item.getRate() <= gasNeeded) {
                    received = item.removeGas(this.inventory[1], this.gasType, item.getRate());
                } else if (item.getRate() > gasNeeded) {
                    received = item.removeGas(this.inventory[1], this.gasType, gasNeeded);
                }
                this.setGas(this.gasType, this.gasStored + received, new Object[0]);
            }
        }
        if (this.gasStored == 0) {
            this.gasType = EnumGas.NONE;
        }
        if (this.gasStored > 0 && !this.field_70331_k.field_72995_K) {
            this.setGas(this.gasType, this.gasStored - (Math.min(this.gasStored, this.output) - GasTransmission.emitGasToNetwork(this.gasType, Math.min(this.gasStored, this.output), this, ForgeDirection.getOrientation((int)this.facing))), new Object[0]);
            TileEntity tileEntity = Object3D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
            if (tileEntity instanceof IGasAcceptor && ((IGasAcceptor)tileEntity).canReceiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), this.gasType)) {
                sendingGas = 0;
                if (this.getGas(this.gasType, new Object[0]) >= this.output) {
                    sendingGas = this.output;
                } else if (this.getGas(this.gasType, new Object[0]) < this.output) {
                    sendingGas = this.getGas(this.gasType, new Object[0]);
                }
                rejects = ((IGasAcceptor)tileEntity).transferGasToAcceptor(sendingGas, this.gasType);
                this.setGas(this.gasType, this.getGas(this.gasType, new Object[0]) - (sendingGas - rejects), new Object[0]);
            }
        }
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IStorageTank && ((IStorageTank)itemstack.func_77973_b()).getGas(EnumGas.NONE, itemstack) == 0;
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IStorageTank && ((IStorageTank)itemstack.func_77973_b()).getGas(EnumGas.NONE, itemstack) == ((IStorageTank)itemstack.func_77973_b()).getMaxGas(EnumGas.NONE, itemstack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IStorageTank && (this.gasType == EnumGas.NONE || ((IStorageTank)itemstack.func_77973_b()).canReceiveGas(itemstack, this.gasType));
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IStorageTank && (this.gasType == EnumGas.NONE || ((IStorageTank)itemstack.func_77973_b()).canProvideGas(itemstack, this.gasType));
        }
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.getOrientation((int)1)) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public int getGas(EnumGas type, Object ... data) {
        if (type == this.gasType) {
            return this.gasStored;
        }
        return 0;
    }

    @Override
    public void setGas(EnumGas type, int amount, Object ... data) {
        if (type == this.gasType) {
            this.gasStored = Math.max(Math.min(amount, this.MAX_GAS), 0);
        }
    }

    @Override
    public int getMaxGas(EnumGas type, Object ... data) {
        return this.MAX_GAS;
    }

    @Override
    public int transferGasToAcceptor(int amount, EnumGas type) {
        if (type == this.gasType || this.gasType == EnumGas.NONE) {
            if (this.gasType == EnumGas.NONE) {
                this.gasType = type;
            }
            int rejects = 0;
            int neededGas = this.MAX_GAS - this.gasStored;
            if (amount <= neededGas) {
                this.gasStored += amount;
            } else if (amount > neededGas) {
                this.gasStored += neededGas;
                rejects = amount - neededGas;
            }
            return rejects;
        }
        return amount;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, EnumGas type) {
        return (type == this.gasType || this.gasType == EnumGas.NONE) && side != ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.gasStored = dataStream.readInt();
        this.gasType = EnumGas.getFromName(dataStream.readUTF());
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.gasStored = nbtTags.func_74762_e("gasStored");
        this.gasType = EnumGas.getFromName(nbtTags.func_74779_i("gasType"));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("gasStored", this.gasStored);
        nbtTags.func_74778_a("gasType", this.gasType.name);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.gasStored);
        data.add(this.gasType.name);
        return data;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return true;
    }
}

