/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.Object3D;
import mekanism.common.IMechanicalPipe;
import mekanism.common.ITileNetwork;
import mekanism.common.LiquidNetwork;
import mekanism.common.PacketHandler;
import mekanism.common.PipeUtils;
import mekanism.common.network.PacketDataRequest;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileEntityMechanicalPipe
extends TileEntity
implements IMechanicalPipe,
ITankContainer,
ITileNetwork {
    public LiquidTank dummyTank = new LiquidTank(1000);
    public LiquidStack refLiquid = null;
    public LiquidNetwork liquidNetwork;
    public boolean isActive = false;
    public float liquidScale;

    @Override
    public void onTransfer(LiquidStack liquidStack) {
        if (liquidStack.isLiquidEqual(this.refLiquid)) {
            this.liquidScale = Math.min(1.0f, this.liquidScale + (float)liquidStack.amount / 50.0f);
        } else if (this.refLiquid == null) {
            this.refLiquid = liquidStack.copy();
            this.liquidScale += Math.min(1.0f, (float)liquidStack.amount / 50.0f);
        }
    }

    @Override
    public LiquidNetwork getNetwork() {
        if (this.liquidNetwork == null) {
            this.liquidNetwork = new LiquidNetwork(this);
        }
        return this.liquidNetwork;
    }

    public void func_70313_j() {
        if (!this.field_70331_k.field_72995_K) {
            this.getNetwork().split(this);
        }
        super.func_70313_j();
    }

    @Override
    public void setNetwork(LiquidNetwork network) {
        this.liquidNetwork = network;
    }

    @Override
    public void refreshNetwork() {
        if (!this.field_70331_k.field_72995_K) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = Object3D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k);
                if (!(tileEntity instanceof IMechanicalPipe)) continue;
                this.getNetwork().merge(((IMechanicalPipe)tileEntity).getNetwork());
            }
            this.getNetwork().refresh();
        }
    }

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            if (this.liquidScale > 0.0f) {
                this.liquidScale = (float)((double)this.liquidScale - 0.01);
            } else {
                this.refLiquid = null;
            }
        } else if (this.isActive) {
            ITankContainer[] connectedAcceptors;
            for (ITankContainer container : connectedAcceptors = PipeUtils.getConnectedAcceptors(this)) {
                LiquidStack received;
                ForgeDirection side = ForgeDirection.getOrientation((int)Arrays.asList(connectedAcceptors).indexOf(container));
                if (container == null || (received = container.drain(side, 100, false)) == null || received.amount == 0) continue;
                container.drain(side, this.getNetwork().emit(received, true, Object3D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k)), true);
            }
        }
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k.field_72995_K) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketDataRequest().setParams(Object3D.get(this)), new Object[0]);
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        this.isActive = dataStream.readBoolean();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data.add(this.isActive);
        return data;
    }

    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
    }

    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (!this.isActive) {
            return this.getNetwork().emit(resource, doFill, Object3D.get(this).getFromSide(from).getTileEntity((IBlockAccess)this.field_70331_k));
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (!this.isActive) {
            return this.getNetwork().emit(resource, doFill, null);
        }
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.dummyTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.dummyTank;
    }
}

