/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.IStrictEnergyAcceptor;
import mekanism.api.IUpgradeManagement;
import mekanism.api.InfuseObject;
import mekanism.api.InfuseRegistry;
import mekanism.api.InfuseType;
import mekanism.api.InfusionInput;
import mekanism.api.InfusionOutput;
import mekanism.api.Object3D;
import mekanism.api.SideData;
import mekanism.client.IHasSound;
import mekanism.common.BlockMachine;
import mekanism.common.ChargeUtils;
import mekanism.common.IActiveState;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.RecipeHandler;
import mekanism.common.TileEntityElectricBlock;
import mekanism.common.network.PacketTileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.item.IItemElectric;

public class TileEntityMetallurgicInfuser
extends TileEntityElectricBlock
implements IEnergySink,
IPeripheral,
IActiveState,
IConfigurable,
IUpgradeManagement,
IHasSound,
IStrictEnergyAcceptor {
    public byte[] sideConfig;
    public ArrayList sideOutputs = new ArrayList();
    public InfuseType type = null;
    public int MAX_INFUSE = 1000;
    public double ENERGY_PER_TICK = Mekanism.metallurgicInfuserUsage;
    public int TICKS_REQUIRED = 200;
    public int speedMultiplier;
    public int energyMultiplier;
    public int UPGRADE_TICKS_REQUIRED = 40;
    public int upgradeTicks;
    public int infuseStored;
    public int operatingTicks;
    public boolean isActive;
    public boolean prevActive;

    public TileEntityMetallurgicInfuser() {
        super("Metallurgic Infuser", BlockMachine.MachineType.METALLURGIC_INFUSER.baseEnergy);
        this.sideOutputs.add(new SideData(EnumColor.GREY, 0, 0, new int[0]));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, 0, 1, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.PURPLE, 1, 1, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, 2, 1, new int[]{2}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, 3, 1, new int[]{3}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, 4, 1, new int[]{4}));
        this.sideConfig = new byte[]{2, 1, 0, 5, 3, 4};
        this.inventory = new ItemStack[5];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.registerSound(this);
        }
        if (!this.field_70331_k.field_72995_K) {
            ChargeUtils.discharge(4, this);
            if (this.inventory[0] != null) {
                if (this.inventory[0].func_77969_a(new ItemStack(Mekanism.EnergyUpgrade)) && this.energyMultiplier < 8) {
                    if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                        ++this.upgradeTicks;
                    } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                        this.upgradeTicks = 0;
                        ++this.energyMultiplier;
                        --this.inventory[0].field_77994_a;
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                } else if (this.inventory[0].func_77969_a(new ItemStack(Mekanism.SpeedUpgrade)) && this.speedMultiplier < 8) {
                    if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                        ++this.upgradeTicks;
                    } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                        this.upgradeTicks = 0;
                        ++this.speedMultiplier;
                        --this.inventory[0].field_77994_a;
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                } else {
                    this.upgradeTicks = 0;
                }
            } else {
                this.upgradeTicks = 0;
            }
            if (this.inventory[1] != null && InfuseRegistry.getObject(this.inventory[1]) != null) {
                InfuseObject infuse = InfuseRegistry.getObject(this.inventory[1]);
                if ((this.type == null || this.type == infuse.type) && this.infuseStored + infuse.stored <= this.MAX_INFUSE) {
                    this.infuseStored += infuse.stored;
                    this.type = infuse.type;
                    --this.inventory[1].field_77994_a;
                    if (this.inventory[1].field_77994_a <= 0) {
                        this.inventory[1] = null;
                    }
                }
            }
            if (this.electricityStored >= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK)) {
                if (this.canOperate() && this.operatingTicks + 1 < MekanismUtils.getTicks(this.speedMultiplier, this.TICKS_REQUIRED)) {
                    ++this.operatingTicks;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK);
                } else if (this.canOperate() && this.operatingTicks + 1 >= MekanismUtils.getTicks(this.speedMultiplier, this.TICKS_REQUIRED)) {
                    this.operate();
                    this.operatingTicks = 0;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK);
                }
            }
            if (!this.canOperate()) {
                this.operatingTicks = 0;
            }
            if (this.infuseStored <= 0) {
                this.infuseStored = 0;
                this.type = null;
            }
            if (this.canOperate() && this.electricityStored >= MekanismUtils.getEnergyPerTick(this.speedMultiplier, this.energyMultiplier, this.ENERGY_PER_TICK)) {
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        }
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 4) {
            return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0 || itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0);
        }
        return slotID == 3;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 3) {
            return false;
        }
        if (slotID == 1) {
            return InfuseRegistry.getObject(itemstack) != null && (this.type == null || this.type == InfuseRegistry.getObject((ItemStack)itemstack).type);
        }
        if (slotID == 0) {
            return itemstack.field_77993_c == Mekanism.SpeedUpgrade.field_77779_bT || itemstack.field_77993_c == Mekanism.EnergyUpgrade.field_77779_bT;
        }
        if (slotID == 2) {
            if (this.type != null) {
                if (RecipeHandler.getOutput(InfusionInput.getInfusion(this.type, this.infuseStored, itemstack), false, (Map)RecipeHandler.Recipe.METALLURGIC_INFUSER.get()) != null) {
                    return true;
                }
            } else {
                for (Object obj : RecipeHandler.Recipe.METALLURGIC_INFUSER.get().keySet()) {
                    InfusionInput input = (InfusionInput)obj;
                    if (!input.inputStack.func_77969_a(itemstack)) continue;
                    return true;
                }
            }
        } else if (slotID == 4) {
            return itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest((ItemStack)itemstack).amperes != 0.0 || itemstack.field_77993_c == Item.field_77767_aC.field_77779_bT;
        }
        return true;
    }

    public void operate() {
        if (!this.canOperate()) {
            return;
        }
        InfusionOutput output = RecipeHandler.getOutput(InfusionInput.getInfusion(this.type, this.infuseStored, this.inventory[2]), true, (Map)RecipeHandler.Recipe.METALLURGIC_INFUSER.get());
        this.infuseStored -= output.getInfuseRequired();
        if (this.inventory[2].field_77994_a <= 0) {
            this.inventory[2] = null;
        }
        if (this.inventory[3] == null) {
            this.inventory[3] = output.resource.func_77946_l();
        } else {
            this.inventory[3].field_77994_a += output.resource.field_77994_a;
        }
    }

    public boolean canOperate() {
        if (this.inventory[2] == null) {
            return false;
        }
        InfusionOutput output = RecipeHandler.getOutput(InfusionInput.getInfusion(this.type, this.infuseStored, this.inventory[2]), false, (Map)RecipeHandler.Recipe.METALLURGIC_INFUSER.get());
        if (output == null) {
            return false;
        }
        if (this.infuseStored - output.getInfuseRequired() < 0) {
            return false;
        }
        if (this.inventory[3] == null) {
            return true;
        }
        if (!this.inventory[3].func_77969_a(output.resource)) {
            return false;
        }
        return this.inventory[3].field_77994_a + output.resource.field_77994_a <= this.inventory[3].func_77976_d();
    }

    public int getScaledInfuseLevel(int i) {
        return this.infuseStored * i / this.MAX_INFUSE;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY));
    }

    public int getScaledProgress(int i) {
        return this.operatingTicks * i / MekanismUtils.getTicks(this.speedMultiplier, this.TICKS_REQUIRED);
    }

    public int getScaledUpgradeProgress(int i) {
        return this.upgradeTicks * i / this.UPGRADE_TICKS_REQUIRED;
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.unregisterSound(this);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.speedMultiplier = nbtTags.func_74762_e("speedMultiplier");
        this.energyMultiplier = nbtTags.func_74762_e("energyMultiplier");
        this.isActive = nbtTags.func_74767_n("isActive");
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.infuseStored = nbtTags.func_74762_e("infuseStored");
        this.type = InfuseRegistry.get(nbtTags.func_74779_i("type"));
        if (nbtTags.func_74764_b("sideDataStored")) {
            for (int i = 0; i < 6; ++i) {
                this.sideConfig[i] = nbtTags.func_74771_c("config" + i);
            }
        }
    }

    @Override
    public double transferEnergyToAcceptor(double amount) {
        double rejects = 0.0;
        double neededElectricity = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
        if (amount <= neededElectricity) {
            this.electricityStored += amount;
        } else {
            this.electricityStored += neededElectricity;
            rejects = amount - neededElectricity;
        }
        return rejects;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return true;
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotStart;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotAmount;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("speedMultiplier", this.speedMultiplier);
        nbtTags.func_74768_a("energyMultiplier", this.energyMultiplier);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74768_a("infuseStored", this.infuseStored);
        if (this.type != null) {
            nbtTags.func_74778_a("type", this.type.name);
        } else {
            nbtTags.func_74778_a("type", "null");
        }
        nbtTags.func_74757_a("sideDataStored", true);
        for (int i = 0; i < 6; ++i) {
            nbtTags.func_74774_a("config" + i, this.sideConfig[i]);
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            this.infuseStored = dataStream.readInt();
            return;
        }
        super.handlePacketData(dataStream);
        this.speedMultiplier = dataStream.readInt();
        this.energyMultiplier = dataStream.readInt();
        this.isActive = dataStream.readBoolean();
        this.operatingTicks = dataStream.readInt();
        this.infuseStored = dataStream.readInt();
        this.type = InfuseRegistry.get(dataStream.readUTF());
        for (int i = 0; i < 6; ++i) {
            this.sideConfig[i] = dataStream.readByte();
        }
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.speedMultiplier);
        data.add(this.energyMultiplier);
        data.add(this.isActive);
        data.add(this.operatingTicks);
        data.add(this.infuseStored);
        if (this.type != null) {
            data.add(this.type.name);
        } else {
            data.add("null");
        }
        data.add(this.sideConfig);
        return data;
    }

    @Override
    public String getType() {
        return this.func_70303_b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded", "getInfuse", "getInfuseNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                return new Object[]{this.canOperate()};
            }
            case 4: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)};
            }
            case 5: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored};
            }
            case 6: {
                return new Object[]{this.infuseStored};
            }
            case 7: {
                return new Object[]{this.MAX_INFUSE - this.infuseStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public int[] func_94128_d(int side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side, (int)this.facing)])).availableSlots;
    }

    @Override
    public double getMaxEnergy() {
        return MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY);
    }

    @Override
    public int demandsEnergy() {
        return (int)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.prevActive != active) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
        }
        this.prevActive = active;
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenEnergy = (double)i * Mekanism.FROM_IC2;
        double rejects = 0.0;
        double neededEnergy = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
        if (givenEnergy < neededEnergy) {
            this.electricityStored += givenEnergy;
        } else if (givenEnergy > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = givenEnergy - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public int powerRequest(ForgeDirection side) {
        return (int)Math.min((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_BC, 100.0);
    }

    @Override
    public ArrayList getSideData() {
        return this.sideOutputs;
    }

    @Override
    public byte[] getConfiguration() {
        return this.sideConfig;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.energyMultiplier = multiplier;
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.speedMultiplier = multiplier;
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        return true;
    }

    @Override
    public String getSoundPath() {
        return "MetallurgicInfuser.ogg";
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean hasVisual() {
        return true;
    }
}

