/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.api.EnumGas;
import mekanism.api.GasNetwork;
import mekanism.api.IPressurizedTube;
import mekanism.api.ITubeConnection;
import mekanism.api.Object3D;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityPressurizedTube
extends TileEntity
implements IPressurizedTube,
ITubeConnection {
    public EnumGas refGas = null;
    public float gasScale;
    public GasNetwork gasNetwork;

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            if (this.gasScale > 0.0f) {
                this.gasScale = (float)((double)this.gasScale - 0.01);
            } else {
                this.refGas = null;
            }
        }
    }

    @Override
    public GasNetwork getNetwork() {
        if (this.gasNetwork == null) {
            this.gasNetwork = new GasNetwork(this);
        }
        return this.gasNetwork;
    }

    public void func_70313_j() {
        if (!this.field_70331_k.field_72995_K) {
            this.getNetwork().split(this);
        }
        super.func_70313_j();
    }

    @Override
    public void setNetwork(GasNetwork network) {
        this.gasNetwork = network;
    }

    @Override
    public void refreshNetwork() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.canTransferGas()) {
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tileEntity = Object3D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k);
                    if (!(tileEntity instanceof IPressurizedTube) || !((IPressurizedTube)tileEntity).canTransferGas()) continue;
                    this.getNetwork().merge(((IPressurizedTube)tileEntity).getNetwork());
                }
                this.getNetwork().refresh();
            } else {
                this.getNetwork().split(this);
            }
        }
    }

    @Override
    public boolean canTransferGas() {
        return this.field_70331_k.func_94577_B(this.field_70329_l, this.field_70330_m, this.field_70327_n) == 0;
    }

    @Override
    public boolean canTransferGasToTube(TileEntity tile) {
        return this.canTransferGas();
    }

    @Override
    public void onTransfer(EnumGas type) {
        if (type == this.refGas) {
            this.gasScale = Math.min(1.0f, this.gasScale + 0.02f);
        } else if (this.refGas == null) {
            this.refGas = type;
            this.gasScale += Math.min(1.0f, this.gasScale + 0.02f);
        }
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return this.canTransferGas();
    }

    public boolean canUpdate() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

