/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.Map;
import mekanism.api.EnumGas;
import mekanism.api.IGasAcceptor;
import mekanism.api.IGasStorage;
import mekanism.api.IStorageTank;
import mekanism.api.ITubeConnection;
import mekanism.common.BlockMachine;
import mekanism.common.Mekanism;
import mekanism.common.RecipeHandler;
import mekanism.common.TileEntityAdvancedElectricMachine;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityPurificationChamber
extends TileEntityAdvancedElectricMachine
implements IGasAcceptor,
IGasStorage,
ITubeConnection {
    public TileEntityPurificationChamber() {
        super("PurificationChamber.ogg", "Purification Chamber", "/mods/mekanism/gui/GuiPurificationChamber.png", Mekanism.purificationChamberUsage, 1, 200, BlockMachine.MachineType.PURIFICATION_CHAMBER.baseEnergy, 1200);
    }

    @Override
    public Map getRecipes() {
        return RecipeHandler.Recipe.PURIFICATION_CHAMBER.get();
    }

    @Override
    public int getFuelTicks(ItemStack itemstack) {
        if (itemstack.func_77969_a(new ItemStack(Item.field_77804_ap))) {
            return 300;
        }
        return 0;
    }

    @Override
    public int getGas(EnumGas type, Object ... data) {
        if (type == EnumGas.OXYGEN) {
            return this.secondaryEnergyStored;
        }
        return 0;
    }

    @Override
    public void setGas(EnumGas type, int amount, Object ... data) {
        if (type == EnumGas.OXYGEN) {
            this.setSecondaryEnergy(amount);
        }
    }

    @Override
    public int getMaxGas(EnumGas type, Object ... data) {
        if (type == EnumGas.OXYGEN) {
            return this.MAX_SECONDARY_ENERGY;
        }
        return 0;
    }

    @Override
    public int transferGasToAcceptor(int amount, EnumGas type) {
        if (type == EnumGas.OXYGEN) {
            int rejects = 0;
            int neededGas = this.MAX_SECONDARY_ENERGY - this.secondaryEnergyStored;
            if (amount <= neededGas) {
                this.secondaryEnergyStored += amount;
            } else if (amount > neededGas) {
                this.secondaryEnergyStored += neededGas;
                rejects = amount - neededGas;
            }
            return rejects;
        }
        return amount;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, EnumGas type) {
        return type == EnumGas.OXYGEN;
    }

    @Override
    public void handleSecondaryFuel() {
        IStorageTank item;
        if (this.inventory[1] != null && this.secondaryEnergyStored < this.MAX_SECONDARY_ENERGY && this.inventory[1].func_77973_b() instanceof IStorageTank && ((IStorageTank)this.inventory[1].func_77973_b()).getGasType(this.inventory[1]) == EnumGas.OXYGEN && (item = (IStorageTank)this.inventory[1].func_77973_b()).canProvideGas(this.inventory[1], EnumGas.OXYGEN)) {
            int received = 0;
            int gasNeeded = this.MAX_SECONDARY_ENERGY - this.secondaryEnergyStored;
            if (item.getRate() <= gasNeeded) {
                received = item.removeGas(this.inventory[1], EnumGas.OXYGEN, item.getRate());
            } else if (item.getRate() > gasNeeded) {
                received = item.removeGas(this.inventory[1], EnumGas.OXYGEN, gasNeeded);
            }
            this.setGas(EnumGas.OXYGEN, this.secondaryEnergyStored + received, new Object[0]);
        }
        super.handleSecondaryFuel();
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return true;
    }
}

