/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.IStrictEnergyAcceptor;
import mekanism.api.Object3D;
import mekanism.common.ChargeUtils;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.Teleporter;
import mekanism.common.TileEntityElectricBlock;
import mekanism.common.network.PacketPortalFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.item.IItemElectric;

public class TileEntityTeleporter
extends TileEntityElectricBlock
implements IEnergySink,
IPeripheral,
IStrictEnergyAcceptor {
    public Teleporter.Code code;
    public String status = (Object)((Object)EnumColor.DARK_RED) + "Not ready.";

    public TileEntityTeleporter() {
        super("Teleporter", 1000000.0);
        this.inventory = new ItemStack[1];
        this.code = new Teleporter.Code(0, 0, 0, 0);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            if (Mekanism.teleporters.containsKey(this.code)) {
                if (!((ArrayList)Mekanism.teleporters.get(this.code)).contains(Object3D.get(this)) && this.hasFrame()) {
                    ((ArrayList)Mekanism.teleporters.get(this.code)).add(Object3D.get(this));
                } else if (((ArrayList)Mekanism.teleporters.get(this.code)).contains(Object3D.get(this)) && !this.hasFrame()) {
                    ((ArrayList)Mekanism.teleporters.get(this.code)).remove(Object3D.get(this));
                }
            } else if (this.hasFrame()) {
                ArrayList<Object3D> newCoords = new ArrayList<Object3D>();
                newCoords.add(Object3D.get(this));
                Mekanism.teleporters.put(this.code, newCoords);
            }
            switch (this.canTeleport()) {
                case 1: {
                    this.status = (Object)((Object)EnumColor.DARK_GREEN) + "Ready.";
                    break;
                }
                case 2: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "No frame.";
                    break;
                }
                case 3: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "No link found.";
                    break;
                }
                case 4: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "Links > 2.";
                    break;
                }
                case 5: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "Needs energy.";
                    break;
                }
                case 6: {
                    this.status = (Object)((Object)EnumColor.DARK_GREEN) + "Idle.";
                }
            }
        }
        ChargeUtils.discharge(0, this);
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) || itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest((ItemStack)itemstack).amperes != 0.0 || itemstack.field_77993_c == Item.field_77767_aC.field_77779_bT;
        }
        return true;
    }

    public byte canTeleport() {
        if (!this.hasFrame()) {
            return 2;
        }
        if (!Mekanism.teleporters.containsKey(this.code) || ((ArrayList)Mekanism.teleporters.get(this.code)).isEmpty()) {
            return 3;
        }
        if (((ArrayList)Mekanism.teleporters.get(this.code)).size() > 2) {
            return 4;
        }
        if (((ArrayList)Mekanism.teleporters.get(this.code)).size() == 2) {
            List entitiesInPortal = this.field_70331_k.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_70329_l - 1), (double)this.field_70330_m, (double)(this.field_70327_n - 1), (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 3), (double)(this.field_70327_n + 1)));
            Object3D closestCoords = null;
            for (Object3D coords : (ArrayList)Mekanism.teleporters.get(this.code)) {
                if (coords.equals(Object3D.get(this))) continue;
                closestCoords = coords;
                break;
            }
            int electricityNeeded = 0;
            for (EntityPlayer entity : entitiesInPortal) {
                electricityNeeded += this.calculateEnergyCost((Entity)entity, closestCoords);
            }
            if (entitiesInPortal.size() == 0) {
                return 6;
            }
            if (this.electricityStored < (double)electricityNeeded) {
                return 5;
            }
            return 1;
        }
        return 3;
    }

    public void teleport() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        List entitiesInPortal = this.field_70331_k.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_70329_l - 1), (double)this.field_70330_m, (double)(this.field_70327_n - 1), (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 3), (double)(this.field_70327_n + 1)));
        Object3D closestCoords = null;
        for (Object3D coords : (ArrayList)Mekanism.teleporters.get(this.code)) {
            if (coords.equals(Object3D.get(this))) continue;
            closestCoords = coords;
            break;
        }
        for (EntityPlayer entity : entitiesInPortal) {
            this.setEnergy(this.electricityStored - (double)this.calculateEnergyCost((Entity)entity, closestCoords));
            this.field_70331_k.func_72956_a((Entity)((EntityPlayerMP)entity), "mob.endermen.portal", 1.0f, 1.0f);
            if (entity.field_70170_p.field_73011_w.field_76574_g != closestCoords.dimensionId) {
                entity.func_71027_c(closestCoords.dimensionId);
            }
            ((EntityPlayerMP)entity).field_71135_a.func_72569_a((double)closestCoords.xCoord + 0.5, (double)(closestCoords.yCoord + 1), (double)closestCoords.zCoord + 0.5, entity.field_70177_z, entity.field_70125_A);
            for (Object3D coords : (ArrayList)Mekanism.teleporters.get(this.code)) {
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketPortalFX().setParams(coords), coords, 40.0);
            }
        }
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        if (!this.field_70331_k.field_72995_K && Mekanism.teleporters.containsKey(this.code)) {
            if (((ArrayList)Mekanism.teleporters.get(this.code)).contains(Object3D.get(this))) {
                ((ArrayList)Mekanism.teleporters.get(this.code)).remove(Object3D.get(this));
            }
            if (((ArrayList)Mekanism.teleporters.get(this.code)).isEmpty()) {
                Mekanism.teleporters.remove(this.code);
            }
        }
    }

    public int calculateEnergyCost(Entity entity, Object3D coords) {
        int energyCost = 1000;
        if (entity.field_70170_p.field_73011_w.field_76574_g != coords.dimensionId) {
            energyCost += 10000;
        }
        int distance = (int)entity.func_70011_f((double)coords.xCoord, (double)coords.yCoord, (double)coords.zCoord);
        return energyCost += distance * 10;
    }

    public boolean hasFrame() {
        if (this.isFrame(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) && this.isFrame(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) && this.isFrame(this.field_70329_l - 1, this.field_70330_m + 1, this.field_70327_n) && this.isFrame(this.field_70329_l + 1, this.field_70330_m + 1, this.field_70327_n) && this.isFrame(this.field_70329_l - 1, this.field_70330_m + 2, this.field_70327_n) && this.isFrame(this.field_70329_l + 1, this.field_70330_m + 2, this.field_70327_n) && this.isFrame(this.field_70329_l - 1, this.field_70330_m + 3, this.field_70327_n) && this.isFrame(this.field_70329_l + 1, this.field_70330_m + 3, this.field_70327_n) && this.isFrame(this.field_70329_l, this.field_70330_m + 3, this.field_70327_n)) {
            return true;
        }
        return this.isFrame(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) && this.isFrame(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n - 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n + 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 2, this.field_70327_n - 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 2, this.field_70327_n + 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 3, this.field_70327_n - 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 3, this.field_70327_n + 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 3, this.field_70327_n);
    }

    public boolean isFrame(int x, int y, int z) {
        return this.field_70331_k.func_72798_a(x, y, z) == Mekanism.basicBlockID && this.field_70331_k.func_72805_g(x, y, z) == 7;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / this.MAX_ELECTRICITY);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.code.digitOne = nbtTags.func_74762_e("digitOne");
        this.code.digitTwo = nbtTags.func_74762_e("digitTwo");
        this.code.digitThree = nbtTags.func_74762_e("digitThree");
        this.code.digitFour = nbtTags.func_74762_e("digitFour");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("digitOne", this.code.digitOne);
        nbtTags.func_74768_a("digitTwo", this.code.digitTwo);
        nbtTags.func_74768_a("digitThree", this.code.digitThree);
        nbtTags.func_74768_a("digitFour", this.code.digitFour);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            int type;
            if (Mekanism.teleporters.containsKey(this.code)) {
                if (((ArrayList)Mekanism.teleporters.get(this.code)).contains(Object3D.get(this))) {
                    ((ArrayList)Mekanism.teleporters.get(this.code)).remove(Object3D.get(this));
                }
                if (((ArrayList)Mekanism.teleporters.get(this.code)).isEmpty()) {
                    Mekanism.teleporters.remove(this.code);
                }
            }
            if ((type = dataStream.readInt()) == 0) {
                this.code.digitOne = dataStream.readInt();
            } else if (type == 1) {
                this.code.digitTwo = dataStream.readInt();
            } else if (type == 2) {
                this.code.digitThree = dataStream.readInt();
            } else if (type == 3) {
                this.code.digitFour = dataStream.readInt();
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.status = dataStream.readUTF().trim();
        this.code.digitOne = dataStream.readInt();
        this.code.digitTwo = dataStream.readInt();
        this.code.digitThree = dataStream.readInt();
        this.code.digitFour = dataStream.readInt();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.status);
        data.add(this.code.digitOne);
        data.add(this.code.digitTwo);
        data.add(this.code.digitThree);
        data.add(this.code.digitFour);
        return data;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return itemstack.func_77973_b() instanceof IItemElectric && ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0 || itemstack.func_77973_b() instanceof IElectricItem && (!(itemstack.func_77973_b() instanceof IItemElectric) || ((IItemElectric)itemstack.func_77973_b()).getProvideRequest(itemstack).getWatts() == 0.0);
    }

    @Override
    public double transferEnergyToAcceptor(double amount) {
        double rejects = 0.0;
        double neededGas = this.MAX_ELECTRICITY - this.electricityStored;
        if (amount <= neededGas) {
            this.electricityStored += amount;
        } else {
            this.electricityStored += neededGas;
            rejects = amount - neededGas;
        }
        return rejects;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return true;
    }

    @Override
    public String getType() {
        return this.func_70303_b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "canTeleport", "getMaxEnergy", "getEnergyNeeded", "teleport", "set"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        block0 : switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.canTeleport()};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                this.teleport();
                return new Object[]{"Attempted to teleport."};
            }
            case 5: {
                if (!(arguments[0] instanceof Integer) || !(arguments[1] instanceof Integer)) {
                    return new Object[]{"Invalid parameters."};
                }
                int digit = (Integer)arguments[0];
                int newDigit = (Integer)arguments[1];
                switch (digit) {
                    case 0: {
                        this.code.digitOne = newDigit;
                        break block0;
                    }
                    case 1: {
                        this.code.digitTwo = newDigit;
                        break block0;
                    }
                    case 2: {
                        this.code.digitThree = newDigit;
                        break block0;
                    }
                    case 3: {
                        this.code.digitFour = newDigit;
                        break block0;
                    }
                }
                return new Object[]{"No digit found."};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public int demandsEnergy() {
        return (int)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        double givenEnergy = (double)amount * Mekanism.FROM_IC2;
        double rejects = 0.0;
        double neededEnergy = this.MAX_ELECTRICITY - this.electricityStored;
        if (givenEnergy < neededEnergy) {
            this.electricityStored += givenEnergy;
        } else if (givenEnergy > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = givenEnergy - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }
}

