/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import mekanism.api.Object3D;
import mekanism.common.CablePowerProvider;
import mekanism.common.CableUtils;
import mekanism.common.EnergyNetwork;
import mekanism.common.EnergyNetworkRegistry;
import mekanism.common.IUniversalCable;
import mekanism.common.Mekanism;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityUniversalCable
extends TileEntity
implements IUniversalCable,
IPowerReceptor {
    public CablePowerProvider powerProvider = new CablePowerProvider(this);
    public EnergyNetwork energyNetwork;

    public TileEntityUniversalCable() {
        this.powerProvider.configure(0, 0, 100, 0, 100);
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public EnergyNetwork getNetwork() {
        return this.getNetwork(true);
    }

    @Override
    public EnergyNetwork getNetwork(boolean createIfNull) {
        if (this.energyNetwork == null && createIfNull) {
            TileEntity[] adjacentCables = CableUtils.getConnectedCables(this);
            HashSet<EnergyNetwork> connectedNets = new HashSet<EnergyNetwork>();
            for (TileEntity cable : adjacentCables) {
                if (!(cable instanceof IUniversalCable) || ((IUniversalCable)cable).getNetwork(false) == null) continue;
                connectedNets.add(((IUniversalCable)cable).getNetwork());
            }
            if (connectedNets.size() == 0) {
                this.energyNetwork = new EnergyNetwork(this);
            } else if (connectedNets.size() == 1) {
                this.energyNetwork = (EnergyNetwork)connectedNets.toArray()[0];
                this.energyNetwork.cables.add(this);
            } else {
                this.energyNetwork = new EnergyNetwork(connectedNets);
                this.energyNetwork.cables.add(this);
            }
        }
        return this.energyNetwork;
    }

    @Override
    public void fixNetwork() {
        this.getNetwork().fixMessedUpNetwork(this);
    }

    public void func_70313_j() {
        if (!this.field_70331_k.field_72995_K) {
            this.getNetwork().split(this);
        }
        super.func_70313_j();
    }

    @Override
    public void setNetwork(EnergyNetwork network) {
        if (network != this.energyNetwork) {
            this.removeFromNetwork();
            this.energyNetwork = network;
        }
    }

    @Override
    public void removeFromNetwork() {
        if (this.energyNetwork != null) {
            this.energyNetwork.removeCable(this);
        }
    }

    @Override
    public void refreshNetwork() {
        if (!this.field_70331_k.field_72995_K) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = Object3D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k);
                if (!(tileEntity instanceof IUniversalCable)) continue;
                this.getNetwork().merge(((IUniversalCable)tileEntity).getNetwork());
            }
            this.getNetwork().refresh();
        }
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        ArrayList<TileEntity> ignored = new ArrayList<TileEntity>();
        ignored.add(Object3D.get(this).getFromSide(from).getTileEntity((IBlockAccess)this.field_70331_k));
        return (int)Math.min(100.0, this.getNetwork().getEnergyNeeded(ignored) * Mekanism.TO_BC);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void onChunkUnload() {
        this.func_70313_j();
        EnergyNetworkRegistry.getInstance().pruneEmptyNetworks();
    }
}

