/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutputStream;
import mekanism.api.Object3D;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PacketControlPanel
implements IMekanismPacket {
    public String modClass;
    public String modInstance;
    public Object3D object3D;
    public int guiId;

    @Override
    public String getName() {
        return "ControlPanel";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.modClass = (String)data[0];
        this.modInstance = (String)data[1];
        this.object3D = (Object3D)data[2];
        this.guiId = (Integer)data[3];
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        String modClass = dataStream.readUTF();
        String modInstance = dataStream.readUTF();
        int x = dataStream.readInt();
        int y = dataStream.readInt();
        int z = dataStream.readInt();
        int guiId = dataStream.readInt();
        Class<?> mod = Class.forName(modClass);
        if (mod == null) {
            System.err.println("[Mekanism] Incorrectly implemented IAccessibleGui -- ignoring handler packet.");
            System.err.println(" ~ Unable to locate class '" + modClass + ".'");
            System.err.println(" ~ GUI Container may not function correctly.");
            return;
        }
        Object instance = mod.getField(modInstance).get(null);
        if (instance == null) {
            System.err.println("[Mekanism] Incorrectly implemented IAccessibleGui -- ignoring handler packet.");
            System.err.println(" ~ Unable to locate instance object '" + modInstance + ".'");
            System.err.println(" ~ GUI Container may not function correctly.");
            return;
        }
        player.openGui(instance, guiId, world, x, y, z);
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeUTF(this.modClass);
        dataStream.writeUTF(this.modInstance);
        dataStream.writeInt(this.object3D.xCoord);
        dataStream.writeInt(this.object3D.yCoord);
        dataStream.writeInt(this.object3D.zCoord);
        dataStream.writeInt(this.guiId);
    }
}

