/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutputStream;
import mekanism.common.EntityRobit;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PacketRobit
implements IMekanismPacket {
    public RobitPacketType activeType;
    public int guiType;
    public int entityId;
    public String name;

    @Override
    public String getName() {
        return "Robit";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.activeType = (RobitPacketType)((Object)data[0]);
        switch (this.activeType) {
            case GUI: {
                this.guiType = (Integer)data[1];
                this.entityId = (Integer)data[2];
                break;
            }
            case FOLLOW: {
                this.entityId = (Integer)data[1];
                break;
            }
            case NAME: {
                this.name = (String)data[1];
                this.entityId = (Integer)data[2];
                break;
            }
            case GO_HOME: {
                this.entityId = (Integer)data[1];
                break;
            }
            case DROP_PICKUP: {
                this.entityId = (Integer)data[1];
            }
        }
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        int id;
        EntityRobit robit;
        int subType = dataStream.readInt();
        if (subType == 0) {
            int type = dataStream.readInt();
            int id2 = dataStream.readInt();
            if (type == 0) {
                player.openGui((Object)Mekanism.instance, 21, world, id2, 0, 0);
            } else if (type == 1) {
                player.openGui((Object)Mekanism.instance, 22, world, id2, 0, 0);
            } else if (type == 2) {
                player.openGui((Object)Mekanism.instance, 23, world, id2, 0, 0);
            } else if (type == 3) {
                player.openGui((Object)Mekanism.instance, 24, world, id2, 0, 0);
            } else if (type == 4) {
                player.openGui((Object)Mekanism.instance, 25, world, id2, 0, 0);
            }
        } else if (subType == 1) {
            int id3 = dataStream.readInt();
            EntityRobit robit2 = (EntityRobit)world.func_73045_a(id3);
            if (robit2 != null) {
                robit2.setFollowing(!robit2.getFollowing());
            }
        } else if (subType == 2) {
            String name = dataStream.readUTF();
            int id4 = dataStream.readInt();
            EntityRobit robit3 = (EntityRobit)world.func_73045_a(id4);
            if (robit3 != null) {
                robit3.setName(name);
            }
        } else if (subType == 3) {
            int id5 = dataStream.readInt();
            EntityRobit robit4 = (EntityRobit)world.func_73045_a(id5);
            if (robit4 != null) {
                robit4.goHome();
            }
        } else if (subType == 4 && (robit = (EntityRobit)world.func_73045_a(id = dataStream.readInt())) != null) {
            robit.setDropPickup(!robit.getDropPickup());
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.activeType.ordinal());
        switch (this.activeType) {
            case GUI: {
                dataStream.writeInt(this.guiType);
                dataStream.writeInt(this.entityId);
                break;
            }
            case FOLLOW: {
                dataStream.writeInt(this.entityId);
                break;
            }
            case NAME: {
                dataStream.writeUTF(this.name);
                dataStream.writeInt(this.entityId);
                break;
            }
            case GO_HOME: {
                dataStream.writeInt(this.entityId);
                break;
            }
            case DROP_PICKUP: {
                dataStream.writeInt(this.entityId);
            }
        }
    }

    public static enum RobitPacketType {
        GUI,
        FOLLOW,
        NAME,
        GO_HOME,
        DROP_PICKUP;

    }
}

