/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutputStream;
import mekanism.api.EnumGas;
import mekanism.client.GasClientUpdate;
import mekanism.client.LiquidClientUpdate;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidStack;

public class PacketTransmitterTransferUpdate
implements IMekanismPacket {
    public TransmitterTransferType activeType;
    public TileEntity tileEntity;
    public String gasName;
    public LiquidStack liquidStack;

    @Override
    public String getName() {
        return "TransmitterTransferUpdate";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.activeType = (TransmitterTransferType)((Object)data[0]);
        this.tileEntity = (TileEntity)data[1];
        switch (this.activeType) {
            case GAS: {
                this.gasName = ((EnumGas)((Object)data[2])).name;
                break;
            }
            case LIQUID: {
                this.liquidStack = (LiquidStack)data[2];
            }
        }
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        int transmitterType = dataStream.readInt();
        int x = dataStream.readInt();
        int y = dataStream.readInt();
        int z = dataStream.readInt();
        if (transmitterType == 0) {
            EnumGas type = EnumGas.getFromName(dataStream.readUTF());
            TileEntity tileEntity = world.func_72796_p(x, y, z);
            if (tileEntity != null) {
                new GasClientUpdate(tileEntity, type).clientUpdate();
            }
        } else if (transmitterType == 1) {
            TileEntity tileEntity = world.func_72796_p(x, y, z);
            LiquidStack liquidStack = new LiquidStack(dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            if (tileEntity != null) {
                new LiquidClientUpdate(tileEntity, liquidStack).clientUpdate();
            }
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.activeType.ordinal());
        dataStream.writeInt(this.tileEntity.field_70329_l);
        dataStream.writeInt(this.tileEntity.field_70330_m);
        dataStream.writeInt(this.tileEntity.field_70327_n);
        switch (this.activeType) {
            case GAS: {
                dataStream.writeUTF(this.gasName);
                break;
            }
            case LIQUID: {
                dataStream.writeInt(this.liquidStack.itemID);
                dataStream.writeInt(this.liquidStack.amount);
                dataStream.writeInt(this.liquidStack.itemMeta);
            }
        }
    }

    public static enum TransmitterTransferType {
        GAS,
        LIQUID;

    }
}

