/*
 * Decompiled with CFR 0.152.
 */
package mekanism.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Set;
import mekanism.api.InfuseObject;
import mekanism.api.InfuseRegistry;
import mekanism.api.InfuseType;
import mekanism.api.InfusionInput;
import mekanism.api.InfusionOutput;
import mekanism.client.GuiMetallurgicInfuser;
import mekanism.common.RecipeHandler;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class MetallurgicInfuserRecipeHandler
extends TemplateRecipeHandler {
    private int ticksPassed;

    @Override
    public String getRecipeName() {
        return "Metallurgic Infuser";
    }

    @Override
    public String getOverlayIdentifier() {
        return "infuser";
    }

    @Override
    public String getGuiTexture() {
        return "/mods/mekanism/gui/GuiMetallurgicInfuser.png";
    }

    @Override
    public Class getGuiClass() {
        return GuiMetallurgicInfuser.class;
    }

    public String getRecipeId() {
        return "mekanism.infuser";
    }

    public ItemStack getInfuseStack(InfuseType type) {
        for (Map.Entry obj : InfuseRegistry.getObjectMap().entrySet()) {
            if (((InfuseObject)obj.getValue()).type != type) continue;
            return (ItemStack)obj.getKey();
        }
        return null;
    }

    public Set getRecipes() {
        return RecipeHandler.Recipe.METALLURGIC_INFUSER.get().entrySet();
    }

    @Override
    public void drawBackground(GuiContainerManager guimanager, int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guimanager.bindTexture(this.getGuiTexture());
        guimanager.drawTexturedModalRect(0, 0, 5, 15, 166, 56);
    }

    @Override
    public void drawExtras(GuiContainerManager guimanager, int i) {
        InfuseType type = ((CachedIORecipe)this.arecipes.get((int)i)).infusionType;
        float f = this.ticksPassed >= 40 ? (float)((this.ticksPassed - 40) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(guimanager, 67, 32, 202, 52, 32, 8, f, 0);
        float f2 = f = this.ticksPassed >= 20 && this.ticksPassed < 40 ? (float)((this.ticksPassed - 20) % 20) / 20.0f : 1.0f;
        if (this.ticksPassed < 20) {
            f = 0.0f;
        }
        f = this.ticksPassed <= 20 ? (float)this.ticksPassed / 20.0f : 1.0f;
        this.drawProgressBar(guimanager, 160, 2, 202, 0, 4, 52, f, 3);
        guimanager.bindTexture(type.texture);
        this.drawProgressBar(guimanager, 2, 2, type.texX, type.texY, 4, 52, f, 3);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(67, 32, 32, 8), this.getRecipeId(), new Object[0]));
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStack(((InfusionInput)irecipe.getKey()).infusionType), ((InfusionInput)irecipe.getKey()).infusionType));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public int recipiesPerPage() {
        return 2;
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting(((InfusionOutput)irecipe.getValue()).resource, result)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStack(((InfusionInput)irecipe.getKey()).infusionType), ((InfusionInput)irecipe.getKey()).infusionType));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting(((InfusionInput)irecipe.getKey()).inputStack, ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStack(((InfusionInput)irecipe.getKey()).infusionType), ((InfusionInput)irecipe.getKey()).infusionType));
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack inputStack;
        public PositionedStack outputStack;
        public PositionedStack infuseStack;
        public InfuseType infusionType;

        @Override
        public PositionedStack getIngredient() {
            return this.inputStack;
        }

        @Override
        public PositionedStack getResult() {
            return this.outputStack;
        }

        @Override
        public PositionedStack getOtherStack() {
            return this.infuseStack;
        }

        public CachedIORecipe(ItemStack input, ItemStack output, ItemStack infuse, InfuseType type) {
            this.inputStack = new PositionedStack(input, 46, 28);
            this.outputStack = new PositionedStack(output, 104, 28);
            if (infuse != null) {
                this.infuseStack = new PositionedStack(infuse, 12, 20);
            }
            this.infusionType = type;
        }

        public CachedIORecipe(Map.Entry recipe, ItemStack infuse, InfuseType type) {
            this(((InfusionInput)recipe.getKey()).inputStack, ((InfusionOutput)recipe.getValue()).resource, infuse, type);
        }
    }
}

