/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.MapDifference;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.ArgsWrapper;
import cpw.mods.fml.relauncher.FMLRelauncher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JPanel;
import net.minecraft.client.CallableClientMemoryStats;
import net.minecraft.client.CallableClientProfiler;
import net.minecraft.client.CallableGLInfo;
import net.minecraft.client.CallableLWJGLVersion;
import net.minecraft.client.CallableModded;
import net.minecraft.client.CallableTexturePack;
import net.minecraft.client.CallableTickingScreenName;
import net.minecraft.client.CallableType2;
import net.minecraft.client.CallableUpdatingScreenName;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.EnumOSHelper;
import net.minecraft.client.GameWindowListener;
import net.minecraft.client.MinecraftApplet;
import net.minecraft.client.MinecraftFakeLauncher;
import net.minecraft.client.StatStringFormatKeyInv;
import net.minecraft.client.ThreadClientSleep;
import net.minecraft.client.ThreadShutdown;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMemoryErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.gui.LoadingScreenRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.achievement.GuiAchievement;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.CallableParticleScreenName;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderEngine;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.EnumOptions;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.texturepacks.TexturePackList;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.logging.ILogAgent;
import net.minecraft.logging.LogAgent;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.MemoryConnection;
import net.minecraft.network.packet.Packet3Chat;
import net.minecraft.profiler.IPlayerUsage;
import net.minecraft.profiler.PlayerUsageSnooper;
import net.minecraft.profiler.Profiler;
import net.minecraft.profiler.ProfilerResult;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.IStatStringFormat;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.EnumOS;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftError;
import net.minecraft.util.MouseHelper;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.Session;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringTranslate;
import net.minecraft.util.ThreadDownloadResources;
import net.minecraft.util.Timer;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

@SideOnly(value=Side.CLIENT)
public abstract class Minecraft
implements Runnable,
IPlayerUsage {
    public static byte[] field_71444_a = new byte[0xA00000];
    private final ILogAgent field_94139_O = new LogAgent("Minecraft-Client", " [CLIENT]", new File(Minecraft.func_71380_b(), "output-client.log").getAbsolutePath());
    private ServerData field_71422_O;
    private static Minecraft field_71432_P;
    public PlayerControllerMP field_71442_b;
    private boolean field_71431_Q = false;
    private boolean field_71434_R = false;
    private CrashReport field_71433_S;
    public int field_71443_c;
    public int field_71440_d;
    public Timer field_71428_T = new Timer(20.0f);
    private PlayerUsageSnooper field_71427_U = new PlayerUsageSnooper("client", (IPlayerUsage)this);
    public WorldClient field_71441_e;
    public RenderGlobal field_71438_f;
    public EntityClientPlayerMP field_71439_g;
    public EntityLiving field_71451_h;
    public EntityLiving field_96291_i;
    public EffectRenderer field_71452_i;
    public Session field_71449_j = null;
    public String field_71450_k;
    public Canvas field_71447_l;
    public boolean field_71448_m = false;
    public volatile boolean field_71445_n = false;
    public RenderEngine field_71446_o;
    public FontRenderer field_71466_p;
    public FontRenderer field_71464_q;
    public GuiScreen field_71462_r = null;
    public LoadingScreenRenderer field_71461_s;
    public EntityRenderer field_71460_t;
    private ThreadDownloadResources field_71430_V;
    private int field_71429_W = 0;
    private int field_71436_X;
    private int field_71435_Y;
    private IntegratedServer field_71437_Z;
    public GuiAchievement field_71458_u;
    public GuiIngame field_71456_v;
    public boolean field_71454_w = false;
    public MovingObjectPosition field_71476_x = null;
    public GameSettings field_71474_y;
    protected MinecraftApplet field_71473_z;
    public SoundManager field_71416_A = new SoundManager();
    public MouseHelper field_71417_B;
    public TexturePackList field_71418_C;
    public File field_71412_D;
    private ISaveFormat field_71469_aa;
    private static int field_71470_ab;
    private int field_71467_ac = 0;
    private boolean field_71468_ad;
    public StatFileWriter field_71413_E;
    private String field_71475_ae;
    private int field_71477_af;
    boolean field_71414_F = false;
    public boolean field_71415_G = false;
    long field_71423_H = Minecraft.func_71386_F();
    private int field_71457_ai = 0;
    private boolean field_71459_aj;
    private INetworkManager field_71453_ak;
    private boolean field_71455_al;
    public final Profiler field_71424_I = new Profiler();
    private long field_83002_am = -1L;
    private static File field_71463_am;
    public volatile boolean field_71425_J = true;
    public String field_71426_K = "";
    long field_71419_L = Minecraft.func_71386_F();
    int field_71420_M = 0;
    long field_71421_N = -1L;
    private String field_71465_an = "root";
    private static int max_texture_size;

    public Minecraft(Canvas par1Canvas, MinecraftApplet par2MinecraftApplet, int par3, int par4, boolean par5) {
        StatList.func_75919_a();
        this.field_71435_Y = par4;
        this.field_71431_Q = par5;
        this.field_71473_z = par2MinecraftApplet;
        Packet3Chat.field_73478_a = Short.MAX_VALUE;
        this.func_71389_H();
        this.field_71447_l = par1Canvas;
        this.field_71443_c = par3;
        this.field_71440_d = par4;
        this.field_71431_Q = par5;
        field_71432_P = this;
        TextureManager.func_94263_a();
        this.field_71458_u = new GuiAchievement(this);
    }

    private void func_71389_H() {
        ThreadClientSleep threadclientsleep = new ThreadClientSleep(this, "Timer hack thread");
        threadclientsleep.setDaemon(true);
        threadclientsleep.start();
    }

    public void func_71404_a(CrashReport par1CrashReport) {
        this.field_71434_R = true;
        this.field_71433_S = par1CrashReport;
    }

    public void func_71377_b(CrashReport par1CrashReport) {
        this.field_71434_R = true;
        this.func_71406_c(par1CrashReport);
    }

    public abstract void func_71406_c(CrashReport var1);

    public void func_71367_a(String par1Str, int par2) {
        this.field_71475_ae = par1Str;
        this.field_71477_af = par2;
    }

    public void func_71384_a() throws LWJGLException {
        if (this.field_71447_l != null) {
            Graphics graphics = this.field_71447_l.getGraphics();
            if (graphics != null) {
                graphics.setColor(Color.BLACK);
                graphics.fillRect(0, 0, this.field_71443_c, this.field_71440_d);
                graphics.dispose();
            }
            Display.setParent((Canvas)this.field_71447_l);
        } else if (this.field_71431_Q) {
            Display.setFullscreen((boolean)true);
            this.field_71443_c = Display.getDisplayMode().getWidth();
            this.field_71440_d = Display.getDisplayMode().getHeight();
            if (this.field_71443_c <= 0) {
                this.field_71443_c = 1;
            }
            if (this.field_71440_d <= 0) {
                this.field_71440_d = 1;
            }
        } else {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.field_71443_c, this.field_71440_d));
        }
        Display.setTitle((String)"Minecraft Minecraft 1.5.2");
        this.func_98033_al().func_98233_a("LWJGL Version: " + Sys.getVersion());
        try {
            ForgeHooksClient.createDisplay();
        }
        catch (LWJGLException lwjglexception) {
            lwjglexception.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Display.create();
        }
        OpenGlHelper.func_77474_a();
        this.field_71412_D = Minecraft.func_71380_b();
        this.field_71469_aa = new AnvilSaveConverter(new File(this.field_71412_D, "saves"));
        this.field_71474_y = new GameSettings(this, this.field_71412_D);
        this.field_71418_C = new TexturePackList(this.field_71412_D, this);
        this.field_71446_o = new RenderEngine(this.field_71418_C, this.field_71474_y);
        this.func_71357_I();
        this.field_71466_p = new FontRenderer(this.field_71474_y, "/font/default.png", this.field_71446_o, false);
        this.field_71464_q = new FontRenderer(this.field_71474_y, "/font/alternate.png", this.field_71446_o, false);
        FMLClientHandler.instance().beginMinecraftLoading(this);
        if (this.field_71474_y.field_74363_ab != null) {
            StringTranslate.func_74808_a().func_74810_a(this.field_71474_y.field_74363_ab, false);
            this.field_71466_p.func_78264_a(StringTranslate.func_74808_a().func_74804_d());
            this.field_71466_p.func_78275_b(StringTranslate.func_74802_e((String)this.field_71474_y.field_74363_ab));
        }
        ColorizerGrass.func_77479_a((int[])this.field_71446_o.func_78346_a("/misc/grasscolor.png"));
        ColorizerFoliage.func_77467_a((int[])this.field_71446_o.func_78346_a("/misc/foliagecolor.png"));
        this.field_71460_t = new EntityRenderer(this);
        RenderManager.field_78727_a.field_78721_f = new ItemRenderer(this);
        this.field_71413_E = new StatFileWriter(this.field_71449_j, this.field_71412_D);
        AchievementList.field_76004_f.func_75988_a((IStatStringFormat)new StatStringFormatKeyInv(this));
        this.func_71357_I();
        Mouse.create();
        this.field_71417_B = new MouseHelper((Component)this.field_71447_l, this.field_71474_y);
        this.func_71361_d("Pre startup");
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glCullFace((int)1029);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.func_71361_d("Startup");
        this.field_71416_A.func_77373_a(this.field_71474_y);
        this.field_71438_f = new RenderGlobal(this, this.field_71446_o);
        this.field_71446_o.func_94152_c();
        GL11.glViewport((int)0, (int)0, (int)this.field_71443_c, (int)this.field_71440_d);
        this.field_71452_i = new EffectRenderer((World)this.field_71441_e, this.field_71446_o);
        FMLClientHandler.instance().finishMinecraftLoading();
        try {
            this.field_71430_V = new ThreadDownloadResources(this.field_71412_D, this);
            this.field_71430_V.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.func_71361_d("Post startup");
        this.field_71456_v = new GuiIngameForge(this);
        if (this.field_71475_ae != null) {
            this.func_71373_a((GuiScreen)new GuiConnecting((GuiScreen)new GuiMainMenu(), this, this.field_71475_ae, this.field_71477_af));
        } else {
            this.func_71373_a((GuiScreen)new GuiMainMenu());
        }
        this.field_71461_s = new LoadingScreenRenderer(this);
        if (this.field_71474_y.field_74353_u && !this.field_71431_Q) {
            this.func_71352_k();
        }
        FMLClientHandler.instance().onInitializationComplete();
    }

    private void func_71357_I() throws LWJGLException {
        ScaledResolution scaledresolution = new ScaledResolution(this.field_71474_y, this.field_71443_c, this.field_71440_d);
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)this.field_71443_c, (int)this.field_71440_d);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.field_78398_a;
        this.field_71446_o.func_98187_b("/title/mojang.png");
        tessellator.func_78382_b();
        tessellator.func_78378_d(0xFFFFFF);
        tessellator.func_78374_a(0.0, (double)this.field_71440_d, 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)this.field_71443_c, (double)this.field_71440_d, 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)this.field_71443_c, 0.0, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.func_78378_d(0xFFFFFF);
        int short1 = 256;
        int short2 = 256;
        this.func_71392_a((scaledresolution.func_78326_a() - short1) / 2, (scaledresolution.func_78328_b() - short2) / 2, 0, 0, short1, short2);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Display.swapBuffers();
    }

    public void func_71392_a(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par6), 0.0, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), 0.0, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0), 0.0, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), 0.0, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78381_a();
    }

    public static File func_71380_b() {
        if (field_71463_am == null) {
            field_71463_am = Minecraft.func_71394_a("minecraft");
        }
        return field_71463_am;
    }

    public static File func_71394_a(String par0Str) {
        File file1;
        String s1 = System.getProperty("user.home", ".");
        switch (EnumOSHelper.field_90049_a[Minecraft.func_71376_c().ordinal()]) {
            case 1: 
            case 2: {
                file1 = new File(s1, '.' + par0Str + '/');
                break;
            }
            case 3: {
                String s2 = System.getenv("APPDATA");
                if (s2 != null) {
                    file1 = new File(s2, "." + par0Str + '/');
                    break;
                }
                file1 = new File(s1, '.' + par0Str + '/');
                break;
            }
            case 4: {
                file1 = new File(s1, "Library/Application Support/" + par0Str);
                break;
            }
            default: {
                file1 = new File(s1, par0Str + '/');
            }
        }
        if (!file1.exists() && !file1.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file1);
        }
        return file1;
    }

    public static EnumOS func_71376_c() {
        String s = System.getProperty("os.name").toLowerCase();
        return s.contains("win") ? EnumOS.WINDOWS : (s.contains("mac") ? EnumOS.MACOS : (s.contains("solaris") ? EnumOS.SOLARIS : (s.contains("sunos") ? EnumOS.SOLARIS : (s.contains("linux") ? EnumOS.LINUX : (s.contains("unix") ? EnumOS.LINUX : EnumOS.UNKNOWN)))));
    }

    public ISaveFormat func_71359_d() {
        return this.field_71469_aa;
    }

    public void func_71373_a(GuiScreen par1GuiScreen) {
        if (this.field_71462_r != null) {
            this.field_71462_r.func_73874_b();
        }
        this.field_71413_E.func_77446_d();
        if (par1GuiScreen == null && this.field_71441_e == null) {
            par1GuiScreen = new GuiMainMenu();
        } else if (par1GuiScreen == null && this.field_71439_g.func_70630_aN() <= 0) {
            par1GuiScreen = new GuiGameOver();
        }
        if (par1GuiScreen instanceof GuiMainMenu) {
            this.field_71474_y.field_74330_P = false;
            this.field_71456_v.func_73827_b().func_73761_a();
        }
        this.field_71462_r = par1GuiScreen;
        if (par1GuiScreen != null) {
            this.func_71364_i();
            ScaledResolution scaledresolution = new ScaledResolution(this.field_71474_y, this.field_71443_c, this.field_71440_d);
            int i = scaledresolution.func_78326_a();
            int j = scaledresolution.func_78328_b();
            par1GuiScreen.func_73872_a(this, i, j);
            this.field_71454_w = false;
        } else {
            this.func_71381_h();
        }
    }

    private void func_71361_d(String par1Str) {
        int i = GL11.glGetError();
        if (i != 0) {
            String s1 = GLU.gluErrorString((int)i);
            this.func_98033_al().func_98232_c("########## GL ERROR ##########");
            this.func_98033_al().func_98232_c("@ " + par1Str);
            this.func_98033_al().func_98232_c(i + ": " + s1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_71405_e() {
        try {
            this.field_71413_E.func_77446_d();
            try {
                if (this.field_71430_V != null) {
                    this.field_71430_V.func_74574_b();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.func_98033_al().func_98233_a("Stopping!");
            try {
                this.func_71403_a(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                GLAllocation.func_74525_a();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.field_71416_A.func_77370_b();
            Mouse.destroy();
            Keyboard.destroy();
        }
        finally {
            Display.destroy();
            if (!this.field_71434_R) {
                System.exit(0);
            }
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.field_71425_J = true;
        try {
            this.func_71384_a();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.func_71377_b(this.func_71396_d(new CrashReport("Failed to start game", (Throwable)exception)));
            return;
        }
        try {
            while (this.field_71425_J) {
                if (this.field_71434_R && this.field_71433_S != null) {
                    this.func_71377_b(this.field_71433_S);
                    return;
                }
                if (this.field_71468_ad) {
                    this.field_71468_ad = false;
                    this.field_71446_o.func_78352_b();
                }
                try {
                    this.func_71411_J();
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    this.func_71398_f();
                    this.func_71373_a((GuiScreen)new GuiMemoryErrorScreen());
                    System.gc();
                }
            }
        }
        catch (MinecraftError minecrafterror) {
        }
        catch (ReportedException reportedexception) {
            this.func_71396_d(reportedexception.func_71575_a());
            this.func_71398_f();
            reportedexception.printStackTrace();
            this.func_71377_b(reportedexception.func_71575_a());
        }
        catch (Throwable throwable) {
            CrashReport crashreport = this.func_71396_d(new CrashReport("Unexpected error", throwable));
            this.func_71398_f();
            throwable.printStackTrace();
            this.func_71377_b(crashreport);
        }
        finally {
            this.func_71405_e();
        }
    }

    private void func_71411_J() {
        if (this.field_71473_z != null && !this.field_71473_z.isActive()) {
            this.field_71425_J = false;
        } else {
            AxisAlignedBB.func_72332_a().func_72298_a();
            if (this.field_71441_e != null) {
                this.field_71441_e.func_82732_R().func_72343_a();
            }
            this.field_71424_I.func_76320_a("root");
            if (this.field_71447_l == null && Display.isCloseRequested()) {
                this.func_71400_g();
            }
            if (this.field_71445_n && this.field_71441_e != null) {
                float f = this.field_71428_T.field_74281_c;
                this.field_71428_T.func_74275_a();
                this.field_71428_T.field_74281_c = f;
            } else {
                this.field_71428_T.func_74275_a();
            }
            long i = System.nanoTime();
            this.field_71424_I.func_76320_a("tick");
            for (int j = 0; j < this.field_71428_T.field_74280_b; ++j) {
                this.func_71407_l();
            }
            this.field_71424_I.func_76318_c("preRenderErrors");
            long k = System.nanoTime() - i;
            this.func_71361_d("Pre render");
            RenderBlocks.field_78667_b = this.field_71474_y.field_74347_j;
            this.field_71424_I.func_76318_c("sound");
            this.field_71416_A.func_77369_a((EntityLiving)this.field_71439_g, this.field_71428_T.field_74281_c);
            if (!this.field_71445_n) {
                this.field_71416_A.func_92071_g();
            }
            this.field_71424_I.func_76319_b();
            this.field_71424_I.func_76320_a("render");
            this.field_71424_I.func_76320_a("display");
            GL11.glEnable((int)3553);
            if (!Keyboard.isKeyDown((int)65)) {
                Display.update();
            }
            if (this.field_71439_g != null && this.field_71439_g.func_70094_T()) {
                this.field_71474_y.field_74320_O = 0;
            }
            this.field_71424_I.func_76319_b();
            if (!this.field_71454_w) {
                FMLCommonHandler.instance().onRenderTickStart(this.field_71428_T.field_74281_c);
                this.field_71424_I.func_76318_c("gameRenderer");
                this.field_71460_t.func_78480_b(this.field_71428_T.field_74281_c);
                this.field_71424_I.func_76319_b();
                FMLCommonHandler.instance().onRenderTickEnd(this.field_71428_T.field_74281_c);
            }
            GL11.glFlush();
            this.field_71424_I.func_76319_b();
            if (!Display.isActive() && this.field_71431_Q) {
                this.func_71352_k();
            }
            if (this.field_71474_y.field_74330_P && this.field_71474_y.field_74329_Q) {
                if (!this.field_71424_I.field_76327_a) {
                    this.field_71424_I.func_76317_a();
                }
                this.field_71424_I.field_76327_a = true;
                this.func_71366_a(k);
            } else {
                this.field_71424_I.field_76327_a = false;
                this.field_71421_N = System.nanoTime();
            }
            this.field_71458_u.func_73847_a();
            this.field_71424_I.func_76320_a("root");
            Thread.yield();
            if (Keyboard.isKeyDown((int)65)) {
                Display.update();
            }
            this.func_71365_K();
            if (!(this.field_71447_l == null || this.field_71431_Q || this.field_71447_l.getWidth() == this.field_71443_c && this.field_71447_l.getHeight() == this.field_71440_d)) {
                this.field_71443_c = this.field_71447_l.getWidth();
                this.field_71440_d = this.field_71447_l.getHeight();
                if (this.field_71443_c <= 0) {
                    this.field_71443_c = 1;
                }
                if (this.field_71440_d <= 0) {
                    this.field_71440_d = 1;
                }
                this.func_71370_a(this.field_71443_c, this.field_71440_d);
            }
            this.func_71361_d("Post render");
            ++this.field_71420_M;
            boolean flag = this.field_71445_n;
            boolean bl = this.field_71445_n = this.func_71356_B() && this.field_71462_r != null && this.field_71462_r.func_73868_f() && !this.field_71437_Z.func_71344_c();
            if (this.func_71387_A() && this.field_71439_g != null && this.field_71439_g.field_71174_a != null && this.field_71445_n != flag) {
                ((MemoryConnection)this.field_71439_g.field_71174_a.func_72548_f()).func_74437_a(this.field_71445_n);
            }
            while (Minecraft.func_71386_F() >= this.field_71419_L + 1000L) {
                field_71470_ab = this.field_71420_M;
                this.field_71426_K = field_71470_ab + " fps, " + WorldRenderer.field_78922_b + " chunk updates";
                WorldRenderer.field_78922_b = 0;
                this.field_71419_L += 1000L;
                this.field_71420_M = 0;
                this.field_71427_U.func_76471_b();
                if (this.field_71427_U.func_76468_d()) continue;
                this.field_71427_U.func_76463_a();
            }
            this.field_71424_I.func_76319_b();
            if (this.func_90020_K() > 0) {
                Display.sync((int)EntityRenderer.func_78465_a((int)this.func_90020_K()));
            }
        }
    }

    private int func_90020_K() {
        return this.field_71462_r != null && this.field_71462_r instanceof GuiMainMenu ? 2 : this.field_71474_y.field_74350_i;
    }

    public void func_71398_f() {
        try {
            field_71444_a = new byte[0];
            this.field_71438_f.func_72728_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            AxisAlignedBB.func_72332_a().func_72300_b();
            this.field_71441_e.func_82732_R().func_72344_b();
        }
        catch (Throwable throwable1) {
            // empty catch block
        }
        try {
            System.gc();
            this.func_71403_a(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    private void func_71365_K() {
        if (Keyboard.isKeyDown((int)60)) {
            if (!this.field_71414_F) {
                this.field_71414_F = true;
                this.field_71456_v.func_73827_b().func_73765_a(ScreenShotHelper.func_74291_a((File)field_71463_am, (int)this.field_71443_c, (int)this.field_71440_d));
            }
        } else {
            this.field_71414_F = false;
        }
    }

    private void func_71383_b(int par1) {
        List list = this.field_71424_I.func_76321_b(this.field_71465_an);
        if (list != null && !list.isEmpty()) {
            ProfilerResult profilerresult = (ProfilerResult)list.remove(0);
            if (par1 == 0) {
                int j;
                if (profilerresult.field_76331_c.length() > 0 && (j = this.field_71465_an.lastIndexOf(".")) >= 0) {
                    this.field_71465_an = this.field_71465_an.substring(0, j);
                }
            } else if (--par1 < list.size() && !((ProfilerResult)list.get((int)par1)).field_76331_c.equals("unspecified")) {
                if (this.field_71465_an.length() > 0) {
                    this.field_71465_an = this.field_71465_an + ".";
                }
                this.field_71465_an = this.field_71465_an + ((ProfilerResult)list.get((int)par1)).field_76331_c;
            }
        }
    }

    private void func_71366_a(long par1) {
        if (this.field_71424_I.field_76327_a) {
            int l;
            List list = this.field_71424_I.func_76321_b(this.field_71465_an);
            ProfilerResult profilerresult = (ProfilerResult)list.remove(0);
            GL11.glClear((int)256);
            GL11.glMatrixMode((int)5889);
            GL11.glEnable((int)2903);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)this.field_71443_c, (double)this.field_71440_d, (double)0.0, (double)1000.0, (double)3000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            GL11.glLineWidth((float)1.0f);
            GL11.glDisable((int)3553);
            Tessellator tessellator = Tessellator.field_78398_a;
            int short1 = 160;
            int j = this.field_71443_c - short1 - 10;
            int k = this.field_71440_d - short1 * 2;
            GL11.glEnable((int)3042);
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 200);
            tessellator.func_78377_a((double)((float)j - (float)short1 * 1.1f), (double)((float)k - (float)short1 * 0.6f - 16.0f), 0.0);
            tessellator.func_78377_a((double)((float)j - (float)short1 * 1.1f), (double)(k + short1 * 2), 0.0);
            tessellator.func_78377_a((double)((float)j + (float)short1 * 1.1f), (double)(k + short1 * 2), 0.0);
            tessellator.func_78377_a((double)((float)j + (float)short1 * 1.1f), (double)((float)k - (float)short1 * 0.6f - 16.0f), 0.0);
            tessellator.func_78381_a();
            GL11.glDisable((int)3042);
            double d0 = 0.0;
            for (int i1 = 0; i1 < list.size(); ++i1) {
                float f1;
                float f2;
                float f;
                int j1;
                ProfilerResult profilerresult1 = (ProfilerResult)list.get(i1);
                l = MathHelper.func_76128_c((double)(profilerresult1.field_76332_a / 4.0)) + 1;
                tessellator.func_78371_b(6);
                tessellator.func_78378_d(profilerresult1.func_76329_a());
                tessellator.func_78377_a((double)j, (double)k, 0.0);
                for (j1 = l; j1 >= 0; --j1) {
                    f = (float)((d0 + profilerresult1.field_76332_a * (double)j1 / (double)l) * Math.PI * 2.0 / 100.0);
                    f2 = MathHelper.func_76126_a((float)f) * (float)short1;
                    f1 = MathHelper.func_76134_b((float)f) * (float)short1 * 0.5f;
                    tessellator.func_78377_a((double)((float)j + f2), (double)((float)k - f1), 0.0);
                }
                tessellator.func_78381_a();
                tessellator.func_78371_b(5);
                tessellator.func_78378_d((profilerresult1.func_76329_a() & 0xFEFEFE) >> 1);
                for (j1 = l; j1 >= 0; --j1) {
                    f = (float)((d0 + profilerresult1.field_76332_a * (double)j1 / (double)l) * Math.PI * 2.0 / 100.0);
                    f2 = MathHelper.func_76126_a((float)f) * (float)short1;
                    f1 = MathHelper.func_76134_b((float)f) * (float)short1 * 0.5f;
                    tessellator.func_78377_a((double)((float)j + f2), (double)((float)k - f1), 0.0);
                    tessellator.func_78377_a((double)((float)j + f2), (double)((float)k - f1 + 10.0f), 0.0);
                }
                tessellator.func_78381_a();
                d0 += profilerresult1.field_76332_a;
            }
            DecimalFormat decimalformat = new DecimalFormat("##0.00");
            GL11.glEnable((int)3553);
            String s = "";
            if (!profilerresult.field_76331_c.equals("unspecified")) {
                s = s + "[0] ";
            }
            s = profilerresult.field_76331_c.length() == 0 ? s + "ROOT " : s + profilerresult.field_76331_c + " ";
            l = 0xFFFFFF;
            this.field_71466_p.func_78261_a(s, j - short1, k - short1 / 2 - 16, l);
            s = decimalformat.format(profilerresult.field_76330_b) + "%";
            this.field_71466_p.func_78261_a(s, j + short1 - this.field_71466_p.func_78256_a(s), k - short1 / 2 - 16, l);
            for (int k1 = 0; k1 < list.size(); ++k1) {
                ProfilerResult profilerresult2 = (ProfilerResult)list.get(k1);
                String s1 = "";
                s1 = profilerresult2.field_76331_c.equals("unspecified") ? s1 + "[?] " : s1 + "[" + (k1 + 1) + "] ";
                s1 = s1 + profilerresult2.field_76331_c;
                this.field_71466_p.func_78261_a(s1, j - short1, k + short1 / 2 + k1 * 8 + 20, profilerresult2.func_76329_a());
                s1 = decimalformat.format(profilerresult2.field_76332_a) + "%";
                this.field_71466_p.func_78261_a(s1, j + short1 - 50 - this.field_71466_p.func_78256_a(s1), k + short1 / 2 + k1 * 8 + 20, profilerresult2.func_76329_a());
                s1 = decimalformat.format(profilerresult2.field_76330_b) + "%";
                this.field_71466_p.func_78261_a(s1, j + short1 - this.field_71466_p.func_78256_a(s1), k + short1 / 2 + k1 * 8 + 20, profilerresult2.func_76329_a());
            }
        }
    }

    public void func_71400_g() {
        this.field_71425_J = false;
    }

    public void func_71381_h() {
        if (Display.isActive() && !this.field_71415_G) {
            this.field_71415_G = true;
            this.field_71417_B.func_74372_a();
            this.func_71373_a(null);
            this.field_71429_W = 10000;
        }
    }

    public void func_71364_i() {
        if (this.field_71415_G) {
            KeyBinding.func_74506_a();
            this.field_71415_G = false;
            this.field_71417_B.func_74373_b();
        }
    }

    public void func_71385_j() {
        if (this.field_71462_r == null) {
            this.func_71373_a((GuiScreen)new GuiIngameMenu());
            if (this.func_71356_B() && !this.field_71437_Z.func_71344_c()) {
                this.field_71416_A.func_82466_e();
            }
        }
    }

    private void func_71399_a(int par1, boolean par2) {
        if (!par2) {
            this.field_71429_W = 0;
        }
        if (par1 != 0 || this.field_71429_W <= 0) {
            if (par2 && this.field_71476_x != null && this.field_71476_x.field_72313_a == EnumMovingObjectType.TILE && par1 == 0) {
                int j = this.field_71476_x.field_72311_b;
                int k = this.field_71476_x.field_72312_c;
                int l = this.field_71476_x.field_72309_d;
                this.field_71442_b.func_78759_c(j, k, l, this.field_71476_x.field_72310_e);
                if (this.field_71439_g.func_82246_f(j, k, l)) {
                    this.field_71452_i.addBlockHitEffects(j, k, l, this.field_71476_x);
                    this.field_71439_g.func_71038_i();
                }
            } else {
                this.field_71442_b.func_78767_c();
            }
        }
    }

    private void func_71402_c(int par1) {
        if (par1 != 0 || this.field_71429_W <= 0) {
            if (par1 == 0) {
                this.field_71439_g.func_71038_i();
            }
            if (par1 == 1) {
                this.field_71467_ac = 4;
            }
            boolean flag = true;
            ItemStack itemstack = this.field_71439_g.field_71071_by.func_70448_g();
            if (this.field_71476_x == null) {
                if (par1 == 0 && this.field_71442_b.func_78762_g()) {
                    this.field_71429_W = 10;
                }
            } else if (this.field_71476_x.field_72313_a == EnumMovingObjectType.ENTITY) {
                if (par1 == 0) {
                    this.field_71442_b.func_78764_a((EntityPlayer)this.field_71439_g, this.field_71476_x.field_72308_g);
                }
                if (par1 == 1 && this.field_71442_b.func_78768_b((EntityPlayer)this.field_71439_g, this.field_71476_x.field_72308_g)) {
                    flag = false;
                }
            } else if (this.field_71476_x.field_72313_a == EnumMovingObjectType.TILE) {
                int j = this.field_71476_x.field_72311_b;
                int k = this.field_71476_x.field_72312_c;
                int l = this.field_71476_x.field_72309_d;
                int i1 = this.field_71476_x.field_72310_e;
                if (par1 == 0) {
                    this.field_71442_b.func_78743_b(j, k, l, this.field_71476_x.field_72310_e);
                } else {
                    boolean result;
                    int j1 = itemstack != null ? itemstack.field_77994_a : 0;
                    boolean bl = result = !ForgeEventFactory.onPlayerInteract((EntityPlayer)this.field_71439_g, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)j, (int)k, (int)l, (int)i1).isCanceled();
                    if (result && this.field_71442_b.func_78760_a((EntityPlayer)this.field_71439_g, (World)this.field_71441_e, itemstack, j, k, l, i1, this.field_71476_x.field_72307_f)) {
                        flag = false;
                        this.field_71439_g.func_71038_i();
                    }
                    if (itemstack == null) {
                        return;
                    }
                    if (itemstack.field_77994_a == 0) {
                        this.field_71439_g.field_71071_by.field_70462_a[this.field_71439_g.field_71071_by.field_70461_c] = null;
                    } else if (itemstack.field_77994_a != j1 || this.field_71442_b.func_78758_h()) {
                        this.field_71460_t.field_78516_c.func_78444_b();
                    }
                }
            }
            if (flag && par1 == 1) {
                boolean result;
                ItemStack itemstack1 = this.field_71439_g.field_71071_by.func_70448_g();
                boolean bl = result = !ForgeEventFactory.onPlayerInteract((EntityPlayer)this.field_71439_g, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_AIR, (int)0, (int)0, (int)0, (int)-1).isCanceled();
                if (result && itemstack1 != null && this.field_71442_b.func_78769_a((EntityPlayer)this.field_71439_g, (World)this.field_71441_e, itemstack1)) {
                    this.field_71460_t.field_78516_c.func_78445_c();
                }
            }
        }
    }

    public void func_71352_k() {
        try {
            boolean bl = this.field_71431_Q = !this.field_71431_Q;
            if (this.field_71431_Q) {
                Display.setDisplayMode((DisplayMode)Display.getDesktopDisplayMode());
                this.field_71443_c = Display.getDisplayMode().getWidth();
                this.field_71440_d = Display.getDisplayMode().getHeight();
                if (this.field_71443_c <= 0) {
                    this.field_71443_c = 1;
                }
                if (this.field_71440_d <= 0) {
                    this.field_71440_d = 1;
                }
            } else {
                if (this.field_71447_l != null) {
                    this.field_71443_c = this.field_71447_l.getWidth();
                    this.field_71440_d = this.field_71447_l.getHeight();
                } else {
                    this.field_71443_c = this.field_71436_X;
                    this.field_71440_d = this.field_71435_Y;
                }
                if (this.field_71443_c <= 0) {
                    this.field_71443_c = 1;
                }
                if (this.field_71440_d <= 0) {
                    this.field_71440_d = 1;
                }
            }
            if (this.field_71462_r != null) {
                this.func_71370_a(this.field_71443_c, this.field_71440_d);
            }
            Display.setFullscreen((boolean)this.field_71431_Q);
            Display.setVSyncEnabled((boolean)this.field_71474_y.field_74352_v);
            Display.update();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_71370_a(int par1, int par2) {
        this.field_71443_c = par1 <= 0 ? 1 : par1;
        int n = this.field_71440_d = par2 <= 0 ? 1 : par2;
        if (this.field_71462_r != null) {
            ScaledResolution scaledresolution = new ScaledResolution(this.field_71474_y, par1, par2);
            int k = scaledresolution.func_78326_a();
            int l = scaledresolution.func_78328_b();
            this.field_71462_r.func_73872_a(this, k, l);
        }
    }

    public void func_71407_l() {
        FMLCommonHandler.instance().rescheduleTicks(Side.CLIENT);
        if (this.field_71467_ac > 0) {
            --this.field_71467_ac;
        }
        FMLCommonHandler.instance().onPreClientTick();
        this.field_71424_I.func_76320_a("stats");
        this.field_71413_E.func_77449_e();
        this.field_71424_I.func_76318_c("gui");
        if (!this.field_71445_n) {
            this.field_71456_v.func_73831_a();
        }
        this.field_71424_I.func_76318_c("pick");
        this.field_71460_t.func_78473_a(1.0f);
        this.field_71424_I.func_76318_c("gameMode");
        if (!this.field_71445_n && this.field_71441_e != null) {
            this.field_71442_b.func_78765_e();
        }
        this.field_71446_o.func_98187_b("/terrain.png");
        this.field_71424_I.func_76318_c("textures");
        if (!this.field_71445_n) {
            this.field_71446_o.func_78343_a();
        }
        if (this.field_71462_r == null && this.field_71439_g != null) {
            if (this.field_71439_g.func_70630_aN() <= 0) {
                this.func_71373_a(null);
            } else if (this.field_71439_g.func_70608_bn() && this.field_71441_e != null) {
                this.func_71373_a((GuiScreen)new GuiSleepMP());
            }
        } else if (this.field_71462_r != null && this.field_71462_r instanceof GuiSleepMP && !this.field_71439_g.func_70608_bn()) {
            this.func_71373_a(null);
        }
        if (this.field_71462_r != null) {
            this.field_71429_W = 10000;
        }
        if (this.field_71462_r != null) {
            try {
                this.field_71462_r.func_73862_m();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Updating screen events");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Affected screen");
                crashreportcategory.func_71500_a("Screen name", (Callable)new CallableUpdatingScreenName(this));
                throw new ReportedException(crashreport);
            }
            if (this.field_71462_r != null) {
                try {
                    this.field_71462_r.field_73884_l.func_73774_a();
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable1, (String)"Ticking screen particles");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Affected screen");
                    crashreportcategory.func_71500_a("Screen name", (Callable)new CallableParticleScreenName(this));
                    throw new ReportedException(crashreport);
                }
                try {
                    this.field_71462_r.func_73876_c();
                }
                catch (Throwable throwable2) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable2, (String)"Ticking screen");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Affected screen");
                    crashreportcategory.func_71500_a("Screen name", (Callable)new CallableTickingScreenName(this));
                    throw new ReportedException(crashreport);
                }
            }
        }
        if (this.field_71462_r == null || this.field_71462_r.field_73885_j) {
            boolean flag;
            this.field_71424_I.func_76318_c("mouse");
            while (Mouse.next()) {
                long i;
                KeyBinding.func_74510_a((int)(Mouse.getEventButton() - 100), (boolean)Mouse.getEventButtonState());
                if (Mouse.getEventButtonState()) {
                    KeyBinding.func_74507_a((int)(Mouse.getEventButton() - 100));
                }
                if ((i = Minecraft.func_71386_F() - this.field_71423_H) > 200L) continue;
                int j = Mouse.getEventDWheel();
                if (j != 0) {
                    this.field_71439_g.field_71071_by.func_70453_c(j);
                    if (this.field_71474_y.field_74331_S) {
                        if (j > 0) {
                            j = 1;
                        }
                        if (j < 0) {
                            j = -1;
                        }
                        this.field_71474_y.field_74328_V += (float)j * 0.25f;
                    }
                }
                if (this.field_71462_r == null) {
                    if (this.field_71415_G || !Mouse.getEventButtonState()) continue;
                    this.func_71381_h();
                    continue;
                }
                if (this.field_71462_r == null) continue;
                this.field_71462_r.func_73867_d();
            }
            if (this.field_71429_W > 0) {
                --this.field_71429_W;
            }
            this.field_71424_I.func_76318_c("keyboard");
            while (Keyboard.next()) {
                int k;
                KeyBinding.func_74510_a((int)Keyboard.getEventKey(), (boolean)Keyboard.getEventKeyState());
                if (Keyboard.getEventKeyState()) {
                    KeyBinding.func_74507_a((int)Keyboard.getEventKey());
                }
                if (this.field_83002_am > 0L) {
                    if (Minecraft.func_71386_F() - this.field_83002_am >= 6000L) {
                        throw new ReportedException(new CrashReport("Manually triggered debug crash", new Throwable()));
                    }
                    if (!Keyboard.isKeyDown((int)46) || !Keyboard.isKeyDown((int)61)) {
                        this.field_83002_am = -1L;
                    }
                } else if (Keyboard.isKeyDown((int)46) && Keyboard.isKeyDown((int)61)) {
                    this.field_83002_am = Minecraft.func_71386_F();
                }
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 87) {
                    this.func_71352_k();
                    continue;
                }
                if (this.field_71462_r != null) {
                    this.field_71462_r.func_73860_n();
                } else {
                    if (Keyboard.getEventKey() == 1) {
                        this.func_71385_j();
                    }
                    if (Keyboard.getEventKey() == 31 && Keyboard.isKeyDown((int)61)) {
                        this.func_71358_L();
                    }
                    if (Keyboard.getEventKey() == 20 && Keyboard.isKeyDown((int)61)) {
                        this.field_71446_o.func_78352_b();
                        this.field_71438_f.func_72712_a();
                    }
                    if (Keyboard.getEventKey() == 33 && Keyboard.isKeyDown((int)61)) {
                        boolean flag2 = Keyboard.isKeyDown((int)42) | Keyboard.isKeyDown((int)54);
                        this.field_71474_y.func_74306_a(EnumOptions.RENDER_DISTANCE, flag2 ? -1 : 1);
                    }
                    if (Keyboard.getEventKey() == 30 && Keyboard.isKeyDown((int)61)) {
                        this.field_71438_f.func_72712_a();
                    }
                    if (Keyboard.getEventKey() == 35 && Keyboard.isKeyDown((int)61)) {
                        this.field_71474_y.field_82882_x = !this.field_71474_y.field_82882_x;
                        this.field_71474_y.func_74303_b();
                    }
                    if (Keyboard.getEventKey() == 48 && Keyboard.isKeyDown((int)61)) {
                        boolean bl = RenderManager.field_85095_o = !RenderManager.field_85095_o;
                    }
                    if (Keyboard.getEventKey() == 25 && Keyboard.isKeyDown((int)61)) {
                        this.field_71474_y.field_82881_y = !this.field_71474_y.field_82881_y;
                        this.field_71474_y.func_74303_b();
                    }
                    if (Keyboard.getEventKey() == 59) {
                        boolean bl = this.field_71474_y.field_74319_N = !this.field_71474_y.field_74319_N;
                    }
                    if (Keyboard.getEventKey() == 61) {
                        this.field_71474_y.field_74330_P = !this.field_71474_y.field_74330_P;
                        this.field_71474_y.field_74329_Q = GuiScreen.func_73877_p();
                    }
                    if (Keyboard.getEventKey() == 63) {
                        ++this.field_71474_y.field_74320_O;
                        if (this.field_71474_y.field_74320_O > 2) {
                            this.field_71474_y.field_74320_O = 0;
                        }
                    }
                    if (Keyboard.getEventKey() == 66) {
                        this.field_71474_y.field_74326_T = !this.field_71474_y.field_74326_T;
                    }
                }
                for (k = 0; k < 9; ++k) {
                    if (Keyboard.getEventKey() != 2 + k) continue;
                    this.field_71439_g.field_71071_by.field_70461_c = k;
                }
                if (!this.field_71474_y.field_74330_P || !this.field_71474_y.field_74329_Q) continue;
                if (Keyboard.getEventKey() == 11) {
                    this.func_71383_b(0);
                }
                for (k = 0; k < 9; ++k) {
                    if (Keyboard.getEventKey() != 2 + k) continue;
                    this.func_71383_b(k + 1);
                }
            }
            boolean bl = flag = this.field_71474_y.field_74343_n != 2;
            while (this.field_71474_y.field_74315_B.func_74509_c()) {
                this.func_71373_a((GuiScreen)new GuiInventory((EntityPlayer)this.field_71439_g));
            }
            while (this.field_71474_y.field_74316_C.func_74509_c()) {
                this.field_71439_g.func_71040_bB(GuiScreen.func_73861_o());
            }
            while (this.field_71474_y.field_74310_D.func_74509_c() && flag) {
                this.func_71373_a((GuiScreen)new GuiChat());
            }
            if (this.field_71462_r == null && this.field_71474_y.field_74323_J.func_74509_c() && flag) {
                this.func_71373_a((GuiScreen)new GuiChat("/"));
            }
            if (this.field_71439_g.func_71039_bw()) {
                if (!this.field_71474_y.field_74313_G.field_74513_e) {
                    this.field_71442_b.func_78766_c((EntityPlayer)this.field_71439_g);
                }
                while (this.field_71474_y.field_74312_F.func_74509_c()) {
                }
                while (this.field_71474_y.field_74313_G.func_74509_c()) {
                }
                while (this.field_71474_y.field_74322_I.func_74509_c()) {
                }
            } else {
                while (this.field_71474_y.field_74312_F.func_74509_c()) {
                    this.func_71402_c(0);
                }
                while (this.field_71474_y.field_74313_G.func_74509_c()) {
                    this.func_71402_c(1);
                }
                while (this.field_71474_y.field_74322_I.func_74509_c()) {
                    this.func_71397_M();
                }
            }
            if (this.field_71474_y.field_74313_G.field_74513_e && this.field_71467_ac == 0 && !this.field_71439_g.func_71039_bw()) {
                this.func_71402_c(1);
            }
            this.func_71399_a(0, this.field_71462_r == null && this.field_71474_y.field_74312_F.field_74513_e && this.field_71415_G);
        }
        if (this.field_71441_e != null) {
            if (this.field_71439_g != null) {
                ++this.field_71457_ai;
                if (this.field_71457_ai == 30) {
                    this.field_71457_ai = 0;
                    this.field_71441_e.func_72897_h((Entity)this.field_71439_g);
                }
            }
            this.field_71424_I.func_76318_c("gameRenderer");
            if (!this.field_71445_n) {
                this.field_71460_t.func_78464_a();
            }
            this.field_71424_I.func_76318_c("levelRenderer");
            if (!this.field_71445_n) {
                this.field_71438_f.func_72734_e();
            }
            this.field_71424_I.func_76318_c("level");
            if (!this.field_71445_n) {
                if (this.field_71441_e.field_73016_r > 0) {
                    --this.field_71441_e.field_73016_r;
                }
                this.field_71441_e.func_72939_s();
            }
            if (!this.field_71445_n) {
                this.field_71441_e.func_72891_a(this.field_71441_e.field_73013_u > 0, true);
                try {
                    this.field_71441_e.func_72835_b();
                }
                catch (Throwable throwable3) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable3, (String)"Exception in world tick");
                    if (this.field_71441_e == null) {
                        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Affected level");
                        crashreportcategory.func_71507_a("Problem", (Object)"Level is null!");
                    } else {
                        this.field_71441_e.func_72914_a(crashreport);
                    }
                    throw new ReportedException(crashreport);
                }
            }
            this.field_71424_I.func_76318_c("animateTick");
            if (!this.field_71445_n && this.field_71441_e != null) {
                this.field_71441_e.func_73029_E(MathHelper.func_76128_c((double)this.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)this.field_71439_g.field_70163_u), MathHelper.func_76128_c((double)this.field_71439_g.field_70161_v));
            }
            this.field_71424_I.func_76318_c("particles");
            if (!this.field_71445_n) {
                this.field_71452_i.func_78868_a();
            }
        } else if (this.field_71453_ak != null) {
            this.field_71424_I.func_76318_c("pendingConnection");
            this.field_71453_ak.func_74428_b();
        }
        FMLCommonHandler.instance().onPostClientTick();
        this.field_71424_I.func_76319_b();
        this.field_71423_H = Minecraft.func_71386_F();
    }

    private void func_71358_L() {
        this.func_98033_al().func_98233_a("FORCING RELOAD!");
        if (this.field_71416_A != null) {
            this.field_71416_A.func_82464_d();
        }
        this.field_71416_A = new SoundManager();
        this.field_71416_A.func_77373_a(this.field_71474_y);
        this.field_71430_V.func_74573_a();
    }

    public void func_71371_a(String par1Str, String par2Str, WorldSettings par3WorldSettings) {
        this.func_71403_a(null);
        System.gc();
        ISaveHandler isavehandler = this.field_71469_aa.func_75804_a(par1Str, false);
        WorldInfo worldinfo = isavehandler.func_75757_d();
        if (worldinfo == null && par3WorldSettings != null) {
            this.field_71413_E.func_77450_a(StatList.field_75937_g, 1);
            worldinfo = new WorldInfo(par3WorldSettings, par1Str);
            isavehandler.func_75761_a(worldinfo);
        }
        if (par3WorldSettings == null) {
            par3WorldSettings = new WorldSettings(worldinfo);
        }
        this.field_71413_E.func_77450_a(StatList.field_75936_f, 1);
        GameData.initializeServerGate((int)2);
        this.field_71437_Z = new IntegratedServer(this, par1Str, par2Str, par3WorldSettings);
        this.field_71437_Z.func_71256_s();
        MapDifference idDifferences = GameData.gateWorldLoadingForValidation();
        if (idDifferences != null) {
            FMLClientHandler.instance().warnIDMismatch(idDifferences, true);
        } else {
            GameData.releaseGate((boolean)true);
            this.continueWorldLoading();
        }
    }

    public void continueWorldLoading() {
        this.field_71455_al = true;
        this.field_71461_s.func_73720_a(StatCollector.func_74838_a((String)"menu.loadingLevel"));
        while (!this.field_71437_Z.func_71200_ad()) {
            String s2 = this.field_71437_Z.func_71195_b_();
            if (s2 != null) {
                this.field_71461_s.func_73719_c(StatCollector.func_74838_a((String)s2));
            } else {
                this.field_71461_s.func_73719_c("");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.func_71373_a(null);
        try {
            NetClientHandler netclienthandler = new NetClientHandler(this, this.field_71437_Z);
            this.field_71453_ak = netclienthandler.func_72548_f();
        }
        catch (IOException ioexception) {
            this.func_71377_b(this.func_71396_d(new CrashReport("Connecting to integrated server", (Throwable)ioexception)));
        }
    }

    public void func_71403_a(WorldClient par1WorldClient) {
        this.func_71353_a(par1WorldClient, "");
    }

    public void func_71353_a(WorldClient par1WorldClient, String par2Str) {
        this.field_71413_E.func_77446_d();
        if (this.field_71441_e != null) {
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((World)this.field_71441_e));
        }
        if (par1WorldClient == null) {
            NetClientHandler netclienthandler = this.func_71391_r();
            if (netclienthandler != null) {
                netclienthandler.func_72547_c();
            }
            if (this.field_71453_ak != null) {
                this.field_71453_ak.func_74431_f();
            }
            if (this.field_71437_Z != null) {
                this.field_71437_Z.func_71263_m();
                if (this.field_71461_s != null) {
                    this.field_71461_s.func_73719_c("Shutting down internal server...");
                }
                while (!this.field_71437_Z.func_71241_aa()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            this.field_71437_Z = null;
        }
        this.field_71451_h = null;
        this.field_71453_ak = null;
        if (this.field_71461_s != null) {
            this.field_71461_s.func_73721_b(par2Str);
            this.field_71461_s.func_73719_c("");
        }
        if (par1WorldClient == null && this.field_71441_e != null) {
            if (this.field_71418_C.func_77295_a()) {
                this.field_71418_C.func_77304_b();
            }
            this.func_71351_a(null);
            this.field_71455_al = false;
        }
        this.field_71416_A.func_77368_a((String)null, 0.0f, 0.0f, 0.0f);
        this.field_71416_A.func_82464_d();
        this.field_71441_e = par1WorldClient;
        if (par1WorldClient != null) {
            if (this.field_71438_f != null) {
                this.field_71438_f.func_72732_a(par1WorldClient);
            }
            if (this.field_71452_i != null) {
                this.field_71452_i.func_78870_a((World)par1WorldClient);
            }
            if (this.field_71439_g == null) {
                this.field_71439_g = this.field_71442_b.func_78754_a((World)par1WorldClient);
                this.field_71442_b.func_78745_b((EntityPlayer)this.field_71439_g);
            }
            this.field_71439_g.func_70065_x();
            par1WorldClient.func_72838_d((Entity)this.field_71439_g);
            this.field_71439_g.field_71158_b = new MovementInputFromOptions(this.field_71474_y);
            this.field_71442_b.func_78748_a((EntityPlayer)this.field_71439_g);
            this.field_71451_h = this.field_71439_g;
        } else {
            this.field_71469_aa.func_75800_d();
            this.field_71439_g = null;
        }
        System.gc();
        this.field_71423_H = 0L;
    }

    public void func_71360_a(String par1Str, File par2File) {
        int i = par1Str.indexOf("/");
        String s1 = par1Str.substring(0, i);
        par1Str = par1Str.substring(i + 1);
        if (s1.equalsIgnoreCase("sound3")) {
            this.field_71416_A.func_77372_a(par1Str, par2File);
        } else if (s1.equalsIgnoreCase("streaming")) {
            this.field_71416_A.func_77374_b(par1Str, par2File);
        } else if (!s1.equalsIgnoreCase("music") && !s1.equalsIgnoreCase("newmusic")) {
            if (s1.equalsIgnoreCase("lang")) {
                StringTranslate.func_74808_a().func_94519_a(par1Str, par2File);
            }
        } else {
            this.field_71416_A.func_77365_c(par1Str, par2File);
        }
    }

    public String func_71393_m() {
        return this.field_71438_f.func_72735_c();
    }

    public String func_71408_n() {
        return this.field_71438_f.func_72723_d();
    }

    public String func_71388_o() {
        return this.field_71441_e.func_72827_u();
    }

    public String func_71374_p() {
        return "P: " + this.field_71452_i.func_78869_b() + ". T: " + this.field_71441_e.func_72981_t();
    }

    public void func_71354_a(int par1) {
        this.field_71441_e.func_72974_f();
        this.field_71441_e.func_73022_a();
        int j = 0;
        if (this.field_71439_g != null) {
            j = this.field_71439_g.field_70157_k;
            this.field_71441_e.func_72900_e((Entity)this.field_71439_g);
        }
        this.field_71451_h = null;
        this.field_71439_g = this.field_71442_b.func_78754_a((World)this.field_71441_e);
        this.field_71439_g.field_71093_bK = par1;
        this.field_71451_h = this.field_71439_g;
        this.field_71439_g.func_70065_x();
        this.field_71441_e.func_72838_d((Entity)this.field_71439_g);
        this.field_71442_b.func_78745_b((EntityPlayer)this.field_71439_g);
        this.field_71439_g.field_71158_b = new MovementInputFromOptions(this.field_71474_y);
        this.field_71439_g.field_70157_k = j;
        this.field_71442_b.func_78748_a((EntityPlayer)this.field_71439_g);
        if (this.field_71462_r instanceof GuiGameOver) {
            this.func_71373_a(null);
        }
    }

    void func_71390_a(boolean par1) {
        this.field_71459_aj = par1;
    }

    public final boolean func_71355_q() {
        return this.field_71459_aj;
    }

    public NetClientHandler func_71391_r() {
        return this.field_71439_g != null ? this.field_71439_g.field_71174_a : null;
    }

    public static void main(String[] par0ArrayOfStr) {
        FMLRelauncher.handleClientRelaunch((ArgsWrapper)new ArgsWrapper(par0ArrayOfStr));
    }

    public static void fmlReentry(ArgsWrapper wrapper) {
        String s;
        String[] par0ArrayOfStr = wrapper.args;
        HashMap<String, String> hashmap = new HashMap<String, String>();
        boolean flag = false;
        boolean flag1 = true;
        boolean flag2 = false;
        String s1 = s = "Player" + Minecraft.func_71386_F() % 1000L;
        if (par0ArrayOfStr.length > 0) {
            s1 = par0ArrayOfStr[0];
        }
        String s2 = "-";
        if (par0ArrayOfStr.length > 1) {
            s2 = par0ArrayOfStr[1];
        }
        ArrayList<String> arraylist = new ArrayList<String>();
        for (int i = 2; i < par0ArrayOfStr.length; ++i) {
            String s3 = par0ArrayOfStr[i];
            String s4 = i == par0ArrayOfStr.length - 1 ? null : par0ArrayOfStr[i + 1];
            boolean flag3 = false;
            if (!s3.equals("-demo") && !s3.equals("--demo")) {
                if (s3.equals("--applet")) {
                    flag1 = false;
                } else if (s3.equals("--password") && s4 != null) {
                    String[] astring1 = HttpUtil.func_82718_a((ILogAgent)null, (String)s1, (String)s4);
                    if (astring1 != null) {
                        s1 = astring1[0];
                        s2 = astring1[1];
                        arraylist.add("Logged in insecurely as " + s1);
                    } else {
                        arraylist.add("Could not log in as " + s1 + " with given password");
                    }
                    flag3 = true;
                }
            } else {
                flag = true;
            }
            if (!flag3) continue;
            ++i;
        }
        if (s1.contains("@") && s2.length() <= 1) {
            s1 = s;
        }
        hashmap.put("demo", "" + flag);
        hashmap.put("stand-alone", "" + flag1);
        hashmap.put("username", s1);
        hashmap.put("fullscreen", "" + flag2);
        hashmap.put("sessionid", s2);
        Frame frame = new Frame();
        frame.setTitle("Minecraft");
        frame.setBackground(Color.BLACK);
        JPanel jpanel = new JPanel();
        frame.setLayout(new BorderLayout());
        jpanel.setPreferredSize(new Dimension(854, 480));
        frame.add((Component)jpanel, "Center");
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.addWindowListener((WindowListener)new GameWindowListener());
        MinecraftFakeLauncher minecraftfakelauncher = new MinecraftFakeLauncher(hashmap);
        MinecraftApplet minecraftapplet = new MinecraftApplet();
        minecraftapplet.setStub((AppletStub)minecraftfakelauncher);
        minecraftfakelauncher.setLayout((LayoutManager)new BorderLayout());
        minecraftfakelauncher.add((Component)minecraftapplet, (Object)"Center");
        minecraftfakelauncher.validate();
        frame.removeAll();
        frame.setLayout(new BorderLayout());
        frame.add((Component)minecraftfakelauncher, "Center");
        frame.validate();
        minecraftapplet.init();
        for (String s5 : arraylist) {
            Minecraft.func_71410_x().func_98033_al().func_98233_a(s5);
        }
        minecraftapplet.start();
        Runtime.getRuntime().addShutdownHook((Thread)new ThreadShutdown());
    }

    public static boolean func_71382_s() {
        return field_71432_P == null || !Minecraft.field_71432_P.field_71474_y.field_74319_N;
    }

    public static boolean func_71375_t() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74347_j;
    }

    public static boolean func_71379_u() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74348_k != 0;
    }

    public boolean func_71409_c(String par1Str) {
        return !par1Str.startsWith("/") ? false : false;
    }

    private void func_71397_M() {
        if (this.field_71476_x != null) {
            boolean flag = this.field_71439_g.field_71075_bZ.field_75098_d;
            if (!ForgeHooks.onPickBlock((MovingObjectPosition)this.field_71476_x, (EntityPlayer)this.field_71439_g, (World)this.field_71441_e)) {
                return;
            }
            if (flag) {
                int k = this.field_71439_g.field_71069_bz.field_75151_b.size() - 9 + this.field_71439_g.field_71071_by.field_70461_c;
                this.field_71442_b.func_78761_a(this.field_71439_g.field_71071_by.func_70301_a(this.field_71439_g.field_71071_by.field_70461_c), k);
            }
        }
    }

    public CrashReport func_71396_d(CrashReport par1CrashReport) {
        par1CrashReport.func_85056_g().func_71500_a("LWJGL", (Callable)new CallableLWJGLVersion(this));
        par1CrashReport.func_85056_g().func_71500_a("OpenGL", (Callable)new CallableGLInfo(this));
        par1CrashReport.func_85056_g().func_71500_a("Is Modded", (Callable)new CallableModded(this));
        par1CrashReport.func_85056_g().func_71500_a("Type", (Callable)new CallableType2(this));
        par1CrashReport.func_85056_g().func_71500_a("Texture Pack", (Callable)new CallableTexturePack(this));
        par1CrashReport.func_85056_g().func_71500_a("Profiler Position", (Callable)new CallableClientProfiler(this));
        par1CrashReport.func_85056_g().func_71500_a("Vec3 Pool Size", (Callable)new CallableClientMemoryStats(this));
        if (this.field_71441_e != null) {
            this.field_71441_e.func_72914_a(par1CrashReport);
        }
        return par1CrashReport;
    }

    public static Minecraft func_71410_x() {
        return field_71432_P;
    }

    public void func_71395_y() {
        this.field_71468_ad = true;
    }

    public void func_70000_a(PlayerUsageSnooper par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.func_76472_a("fps", (Object)field_71470_ab);
        par1PlayerUsageSnooper.func_76472_a("texpack_name", (Object)this.field_71418_C.func_77292_e().func_77538_c());
        par1PlayerUsageSnooper.func_76472_a("vsync_enabled", (Object)this.field_71474_y.field_74352_v);
        par1PlayerUsageSnooper.func_76472_a("display_frequency", (Object)Display.getDisplayMode().getFrequency());
        par1PlayerUsageSnooper.func_76472_a("display_type", (Object)(this.field_71431_Q ? "fullscreen" : "windowed"));
        if (this.field_71437_Z != null && this.field_71437_Z.func_80003_ah() != null) {
            par1PlayerUsageSnooper.func_76472_a("snooper_partner", (Object)this.field_71437_Z.func_80003_ah().func_80006_f());
        }
    }

    public void func_70001_b(PlayerUsageSnooper par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.func_76472_a("opengl_version", (Object)GL11.glGetString((int)7938));
        par1PlayerUsageSnooper.func_76472_a("opengl_vendor", (Object)GL11.glGetString((int)7936));
        par1PlayerUsageSnooper.func_76472_a("client_brand", (Object)ClientBrandRetriever.getClientModName());
        par1PlayerUsageSnooper.func_76472_a("applet", (Object)this.field_71448_m);
        ContextCapabilities contextcapabilities = GLContext.getCapabilities();
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_multitexture]", (Object)contextcapabilities.GL_ARB_multitexture);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_multisample]", (Object)contextcapabilities.GL_ARB_multisample);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_texture_cube_map]", (Object)contextcapabilities.GL_ARB_texture_cube_map);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_vertex_blend]", (Object)contextcapabilities.GL_ARB_vertex_blend);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_matrix_palette]", (Object)contextcapabilities.GL_ARB_matrix_palette);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_vertex_program]", (Object)contextcapabilities.GL_ARB_vertex_program);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_vertex_shader]", (Object)contextcapabilities.GL_ARB_vertex_shader);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_fragment_program]", (Object)contextcapabilities.GL_ARB_fragment_program);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_fragment_shader]", (Object)contextcapabilities.GL_ARB_fragment_shader);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_shader_objects]", (Object)contextcapabilities.GL_ARB_shader_objects);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_vertex_buffer_object]", (Object)contextcapabilities.GL_ARB_vertex_buffer_object);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_framebuffer_object]", (Object)contextcapabilities.GL_ARB_framebuffer_object);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_pixel_buffer_object]", (Object)contextcapabilities.GL_ARB_pixel_buffer_object);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_uniform_buffer_object]", (Object)contextcapabilities.GL_ARB_uniform_buffer_object);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[ARB_texture_non_power_of_two]", (Object)contextcapabilities.GL_ARB_texture_non_power_of_two);
        par1PlayerUsageSnooper.func_76472_a("gl_caps[gl_max_vertex_uniforms]", (Object)GL11.glGetInteger((int)35658));
        par1PlayerUsageSnooper.func_76472_a("gl_caps[gl_max_fragment_uniforms]", (Object)GL11.glGetInteger((int)35657));
        par1PlayerUsageSnooper.func_76472_a("gl_max_texture_size", (Object)Minecraft.func_71369_N());
    }

    public static int func_71369_N() {
        if (max_texture_size != -1) {
            return max_texture_size;
        }
        for (int i = 16384; i > 0; i >>= 1) {
            GL11.glTexImage2D((int)32868, (int)0, (int)6408, (int)i, (int)i, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            int j = GL11.glGetTexLevelParameteri((int)32868, (int)0, (int)4096);
            if (j == 0) continue;
            max_texture_size = i;
            return i;
        }
        return -1;
    }

    public boolean func_70002_Q() {
        return this.field_71474_y.field_74355_t;
    }

    public void func_71351_a(ServerData par1ServerData) {
        this.field_71422_O = par1ServerData;
    }

    public ServerData func_71362_z() {
        return this.field_71422_O;
    }

    public boolean func_71387_A() {
        return this.field_71455_al;
    }

    public boolean func_71356_B() {
        return this.field_71455_al && this.field_71437_Z != null;
    }

    public IntegratedServer func_71401_C() {
        return this.field_71437_Z;
    }

    public static void func_71363_D() {
        IntegratedServer integratedserver;
        if (field_71432_P != null && (integratedserver = field_71432_P.func_71401_C()) != null) {
            integratedserver.func_71260_j();
        }
    }

    public PlayerUsageSnooper func_71378_E() {
        return this.field_71427_U;
    }

    public static long func_71386_F() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public boolean func_71372_G() {
        return this.field_71431_Q;
    }

    public ILogAgent func_98033_al() {
        return this.field_94139_O;
    }

    static {
        field_71463_am = null;
        max_texture_size = -1;
    }
}

