/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import cpw.mods.fml.common.network.Player;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.IPropertyModifier;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.clickable.ClickableItem;
import net.machinemuse.general.gui.clickable.ClickableTinkerSlider;
import net.machinemuse.general.gui.frame.ItemSelectionFrame;
import net.machinemuse.general.gui.frame.ModuleSelectionFrame;
import net.machinemuse.general.gui.frame.ScrollableFrame;
import net.machinemuse.powersuits.network.packets.MusePacketTweakRequest;
import net.machinemuse.powersuits.powermodule.PowerModule;
import net.machinemuse.powersuits.powermodule.PropertyModifierLinearAdditive;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import org.lwjgl.opengl.GL11;

public class ModuleTweakFrame
extends ScrollableFrame {
    protected static double SCALERATIO = 0.75;
    protected ItemSelectionFrame itemTarget;
    protected ModuleSelectionFrame moduleTarget;
    protected List sliders;
    protected Map propertyStrings;
    protected ClickableTinkerSlider selectedSlider;
    protected EntityClientPlayerMP player;

    public ModuleTweakFrame(EntityClientPlayerMP player, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame itemTarget, ModuleSelectionFrame moduleTarget) {
        super(topleft.times(1.0 / SCALERATIO), bottomright.times(1.0 / SCALERATIO), borderColour, insideColour);
        this.itemTarget = itemTarget;
        this.moduleTarget = moduleTarget;
        this.player = player;
    }

    @Override
    public void update(double mousex, double mousey) {
        mousex /= SCALERATIO;
        mousey /= SCALERATIO;
        if (this.itemTarget.getSelectedItem() != null && this.moduleTarget.getSelectedModule() != null) {
            ItemStack stack = this.itemTarget.getSelectedItem().getItem();
            IPowerModule module = this.moduleTarget.getSelectedModule().getModule();
            if (MuseItemUtils.itemHasModule(this.itemTarget.getSelectedItem().getItem(), this.moduleTarget.getSelectedModule().getModule().getName())) {
                this.loadTweaks(stack, module);
            } else {
                this.sliders = null;
                this.propertyStrings = null;
            }
        } else {
            this.sliders = null;
            this.propertyStrings = null;
        }
        if (this.selectedSlider != null) {
            this.selectedSlider.moveSlider(mousex, mousey);
        }
    }

    @Override
    public void draw() {
        if (this.sliders != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)SCALERATIO, (double)SCALERATIO, (double)SCALERATIO);
            super.draw();
            MuseRenderer.drawCenteredString("Tinker", (this.border.left() + this.border.right()) / 2.0, this.border.top() + 2.0);
            for (ClickableTinkerSlider slider : this.sliders) {
                slider.draw();
            }
            int nexty = (int)((double)(this.sliders.size() * 20) + this.border.top() + 14.0);
            for (Map.Entry property : this.propertyStrings.entrySet()) {
                String[] str = new String[]{(String)property.getKey() + ':', MuseStringUtils.formatNumberFromUnits((Double)property.getValue(), PowerModule.getUnit((String)property.getKey()))};
                MuseRenderer.drawStringsJustified(Arrays.asList(str), this.border.left() + 4.0, this.border.right() - 4.0, nexty += 9);
            }
            GL11.glPopMatrix();
        }
    }

    private void loadTweaks(ItemStack stack, IPowerModule module) {
        NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
        NBTTagCompound moduleTag = itemTag.func_74775_l(module.getName());
        this.propertyStrings = new HashMap();
        HashSet<String> tweaks = new HashSet<String>();
        Map propertyModifiers = module.getPropertyModifiers();
        for (Map.Entry property : propertyModifiers.entrySet()) {
            double currValue = 0.0;
            for (IPropertyModifier modifier : (List)property.getValue()) {
                currValue = modifier.applyModifier(moduleTag, currValue);
                if (!(modifier instanceof PropertyModifierLinearAdditive)) continue;
                tweaks.add(((PropertyModifierLinearAdditive)modifier).getTradeoffName());
            }
            this.propertyStrings.put(property.getKey(), currValue);
        }
        this.sliders = new LinkedList();
        int y = 0;
        for (String tweak : tweaks) {
            ClickableTinkerSlider slider = new ClickableTinkerSlider(new MusePoint2D((this.border.left() + this.border.right()) / 2.0, this.border.top() + (double)(y += 20)), this.border.right() - this.border.left() - 8.0, moduleTag, tweak);
            this.sliders.add(slider);
        }
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
        x /= SCALERATIO;
        y /= SCALERATIO;
        if (button == 0 && this.sliders != null) {
            for (ClickableTinkerSlider slider : this.sliders) {
                if (!slider.hitBox(x, y)) continue;
                this.selectedSlider = slider;
            }
        }
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
        if (this.selectedSlider != null && this.itemTarget.getSelectedItem() != null && this.moduleTarget.getSelectedModule() != null) {
            ClickableItem item = this.itemTarget.getSelectedItem();
            IPowerModule module = this.moduleTarget.getSelectedModule().getModule();
            MusePacketTweakRequest tweakRequest = new MusePacketTweakRequest((Player)this.player, item.inventorySlot, module.getName(), this.selectedSlider.name(), this.selectedSlider.value());
            this.player.field_71174_a.func_72552_c((Packet)tweakRequest.getPacket250());
        }
        if (button == 0) {
            this.selectedSlider = null;
        }
    }
}

