/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import net.machinemuse.general.recipe.RecipeManager;
import net.machinemuse.powersuits.block.BlockLuxCapacitor;
import net.machinemuse.powersuits.block.BlockTinkerTable;
import net.machinemuse.powersuits.common.CommonProxy;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.GuiHandler;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.entity.EntityLuxCapacitor;
import net.machinemuse.powersuits.entity.EntityPlasmaBolt;
import net.machinemuse.powersuits.entity.EntitySpinningBlade;
import net.machinemuse.powersuits.event.HarvestEventHandler;
import net.machinemuse.powersuits.event.MovementManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.item.ItemPowerArmorBoots;
import net.machinemuse.powersuits.item.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.item.ItemPowerArmorLeggings;
import net.machinemuse.powersuits.item.ItemPowerFist;
import net.machinemuse.powersuits.network.MusePacketHandler;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="mmmPowersuits", name="MachineMuse's Modular Powersuits", dependencies="required-after:Forge@[7.8.0.712,)", version="0.7.0-534")
@NetworkMod(clientSideRequired=true, serverSideRequired=true, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"mmmPowersuits"}, packetHandler=MusePacketHandler.class), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"mmmPowersuits"}, packetHandler=MusePacketHandler.class))
public class ModularPowersuits {
    public static ItemPowerArmorHelmet powerArmorHead;
    public static ItemPowerArmorChestplate powerArmorTorso;
    public static ItemPowerArmorLeggings powerArmorLegs;
    public static ItemPowerArmorBoots powerArmorFeet;
    public static ItemPowerFist powerTool;
    public static ItemComponent components;
    public static BlockTinkerTable tinkerTable;
    public static BlockLuxCapacitor luxCapacitor;
    @Mod.Instance(value="ModularPowersuits")
    public static ModularPowersuits instance;
    @SidedProxy(clientSide="net.machinemuse.powersuits.client.ClientProxy", serverSide="net.machinemuse.powersuits.common.ServerProxy")
    public static CommonProxy proxy;
    public static Config config;
    public static GuiHandler guiHandler;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        Config.init(new Configuration(event.getSuggestedConfigurationFile()));
        MinecraftForge.EVENT_BUS.register((Object)new HarvestEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MovementManager());
        proxy.registerEvents();
    }

    @Mod.Init
    public void load(FMLInitializationEvent event) {
        powerArmorHead = new ItemPowerArmorHelmet(Config.helmID);
        powerArmorTorso = new ItemPowerArmorChestplate(Config.chestID);
        powerArmorLegs = new ItemPowerArmorLeggings(Config.legsID);
        powerArmorFeet = new ItemPowerArmorBoots(Config.bootsID);
        powerTool = new ItemPowerFist();
        tinkerTable = new BlockTinkerTable();
        luxCapacitor = new BlockLuxCapacitor();
        components = new ItemComponent();
        components.populate();
        Config.loadPowerModules();
        Config.getMaximumArmorPerPiece();
        Config.getMaximumFlyingSpeedmps();
        Config.useMouseWheel();
        Config.useGraphicalMeters();
        Config.getSalvageChance();
        Config.baseMaxHeat();
        Config.allowConflictingKeybinds();
        Config.fontURI();
        Config.fontName();
        Config.fontDetail();
        Config.fontAntiAliasing();
        Config.useCustomFonts();
        Config.useSounds();
        Config.glowMultiplier();
        Config.useShaders();
        EntityRegistry.registerModEntity(EntityPlasmaBolt.class, (String)"entityPlasmaBolt", (int)2477, (Object)this, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntitySpinningBlade.class, (String)"entitySpinningBlade", (int)2478, (Object)this, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityLuxCapacitor.class, (String)"entityLuxCapacitor", (int)2479, (Object)this, (int)64, (int)20, (boolean)true);
        proxy.registerHandlers();
        proxy.registerRenderers();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)guiHandler);
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        RecipeManager.addRecipes();
        ModCompatability.registerModSpecificModules();
        Config.getConfig().save();
    }

    static {
        guiHandler = new GuiHandler();
    }
}

